/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.core.subscribers.SubscriberChangeSetManager;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelManager;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.SubscriberParticipantPage;
import org.eclipse.team.tests.ccvs.core.subscriber.CVSSyncSubscriberTest;
import org.eclipse.team.tests.ccvs.ui.SubscriberParticipantSyncInfoSource;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.PartInitException;

public class CVSChangeSetTests
extends CVSSyncSubscriberTest {
    public static Test suite() {
        return CVSChangeSetTests.suite(CVSChangeSetTests.class);
    }

    public CVSChangeSetTests() {
    }

    public CVSChangeSetTests(String name) {
        super(name);
    }

    private void assertIncomingChangesInSets(IFile[][] files, String[] messages) throws CoreException {
        Subscriber workspaceSubscriber = this.getWorkspaceSubscriber();
        this.refresh(workspaceSubscriber);
        ISynchronizeModelElement root = this.getModelRoot(workspaceSubscriber);
        ChangeSetDiffNode[] nodes = this.getCheckedInChangeSetNodes(root);
        this.assertNodesInViewer(workspaceSubscriber, nodes);
        CVSChangeSetTests.assertEquals((String)"The number of change sets in the sync view do not match the expected number", (int)messages.length, (int)nodes.length);
        int i = 0;
        while (i < messages.length) {
            String message = messages[i];
            ChangeSetDiffNode node = this.getCommitSetFor(root, message);
            CVSChangeSetTests.assertNotNull((String)("The commit set for '" + message + "' is not in the sync view"), (Object)node);
            ArrayList<IResource> filesInSet = new ArrayList<IResource>();
            this.getFileChildren((ISynchronizeModelElement)node, filesInSet);
            CVSChangeSetTests.assertTrue((String)"The number of files in the set do not match the expected number", (files[i].length == filesInSet.size() ? 1 : 0) != 0);
            int j = 0;
            while (j < files[i].length) {
                IFile file = files[i][j];
                CVSChangeSetTests.assertTrue((String)("File " + file.getFullPath() + " is not in the set"), (boolean)filesInSet.contains(file));
                ++j;
            }
            ++i;
        }
    }

    private void assertNodesInViewer(Subscriber workspaceSubscriber, ChangeSetDiffNode[] nodes) throws PartInitException {
        SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(workspaceSubscriber);
        SubscriberParticipantPage page = (SubscriberParticipantPage)SubscriberParticipantSyncInfoSource.getSyncViewPage((ISynchronizeParticipant)participant);
        TreeViewer viewer = (TreeViewer)page.getViewer();
        Tree tree = viewer.getTree();
        ArrayList<ChangeSetDiffNode> nodeList = new ArrayList<ChangeSetDiffNode>();
        nodeList.addAll(Arrays.asList(nodes));
        TreeItem[] items = tree.getItems();
        this.removeTreeItemsFromList(nodeList, items);
        CVSChangeSetTests.assertTrue((String)"Not all nodes are visible in the view", (boolean)nodeList.isEmpty());
    }

    private void removeTreeItemsFromList(List<?> nodeList, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            nodeList.remove(item.getData());
            TreeItem[] children = item.getItems();
            this.removeTreeItemsFromList(nodeList, children);
            ++i;
        }
    }

    private ChangeSetDiffNode[] getCheckedInChangeSetNodes(ISynchronizeModelElement root) {
        ArrayList<ChangeSetDiffNode> result = new ArrayList<ChangeSetDiffNode>();
        IDiffElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeSetDiffNode node;
            IDiffElement element = children[i];
            if (element instanceof ChangeSetDiffNode && (node = (ChangeSetDiffNode)element).getSet() instanceof CheckedInChangeSet) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ChangeSetDiffNode[result.size()]);
    }

    private ChangeSetDiffNode[] getActiveChangeSetNodes(ISynchronizeModelElement root) {
        ArrayList<ChangeSetDiffNode> result = new ArrayList<ChangeSetDiffNode>();
        IDiffElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeSetDiffNode node;
            IDiffElement element = children[i];
            if (element instanceof ChangeSetDiffNode && (node = (ChangeSetDiffNode)element).getSet() instanceof ActiveChangeSet) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ChangeSetDiffNode[result.size()]);
    }

    private void getFileChildren(ISynchronizeModelElement node, List<IResource> list) {
        IResource resource = node.getResource();
        if (resource != null && resource.getType() == 1) {
            list.add(resource);
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement child = children[i];
            this.getFileChildren((ISynchronizeModelElement)child, list);
            ++i;
        }
    }

    private ChangeSetDiffNode getCommitSetFor(ISynchronizeModelElement root, String message) {
        IDiffElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeSetDiffNode node;
            IDiffElement element = children[i];
            if (element instanceof ChangeSetDiffNode && (node = (ChangeSetDiffNode)element).getSet().getComment().equals(message)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private void refresh(Subscriber workspaceSubscriber) throws TeamException {
        workspaceSubscriber.refresh(workspaceSubscriber.roots(), 2, DEFAULT_MONITOR);
    }

    private void enableChangeSets(Subscriber workspaceSubscriber) throws PartInitException {
        SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(workspaceSubscriber);
        SubscriberParticipantPage page = (SubscriberParticipantPage)SubscriberParticipantSyncInfoSource.getSyncViewPage((ISynchronizeParticipant)participant);
        ChangeSetModelManager manager = (ChangeSetModelManager)page.getConfiguration().getProperty("org.eclipse.team.ui.P_MODEL_MANAGER");
        manager.setCommitSetsEnabled(true);
        page.getConfiguration().setMode(4);
    }

    private void enableCheckedInChangeSets(Subscriber workspaceSubscriber) throws PartInitException {
        this.enableChangeSets(workspaceSubscriber);
        SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(workspaceSubscriber);
        SubscriberParticipantPage page = (SubscriberParticipantPage)SubscriberParticipantSyncInfoSource.getSyncViewPage((ISynchronizeParticipant)participant);
        page.getConfiguration().setMode(1);
    }

    private void enableActiveChangeSets(Subscriber workspaceSubscriber) throws PartInitException {
        this.enableChangeSets(workspaceSubscriber);
        SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(workspaceSubscriber);
        SubscriberParticipantPage page = (SubscriberParticipantPage)SubscriberParticipantSyncInfoSource.getSyncViewPage((ISynchronizeParticipant)participant);
        page.getConfiguration().setMode(2);
    }

    private ISynchronizeModelElement getModelRoot(Subscriber workspaceSubscriber) throws CoreException {
        IProgressMonitor eventLoopProgressMonitor = new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
        };
        SubscriberParticipantSyncInfoSource.getCollector(workspaceSubscriber);
        SubscriberParticipant participant = SubscriberParticipantSyncInfoSource.getParticipant(workspaceSubscriber);
        ChangeSetCapability capability = ((IChangeSetProvider)participant).getChangeSetCapability();
        SubscriberChangeSetManager activeManager = (SubscriberChangeSetManager)capability.getActiveChangeSetManager();
        activeManager.waitUntilDone(eventLoopProgressMonitor);
        SubscriberParticipantPage page = (SubscriberParticipantPage)SubscriberParticipantSyncInfoSource.getSyncViewPage((ISynchronizeParticipant)participant);
        ChangeSetModelManager manager = (ChangeSetModelManager)page.getConfiguration().getProperty("org.eclipse.team.ui.P_MODEL_MANAGER");
        AbstractSynchronizeModelProvider provider = (AbstractSynchronizeModelProvider)manager.getActiveModelProvider();
        provider.waitUntilDone(eventLoopProgressMonitor);
        return provider.getModelRoot();
    }

    private ActiveChangeSetManager getActiveChangeSetManager() {
        return CVSUIPlugin.getPlugin().getChangeSetManager();
    }

    private void assertInActiveSet(IResource[] resources, ActiveChangeSet set) throws CoreException {
        this.assertResourcesAreTheSame(resources, set.getResources(), true);
        ISynchronizeModelElement root = this.getModelRoot(((SubscriberChangeSetManager)this.getActiveChangeSetManager()).getSubscriber());
        ChangeSetDiffNode node = this.getChangeSetNodeFor(root, (ChangeSet)set);
        CVSChangeSetTests.assertNotNull((String)("Change set " + set.getTitle() + " did not appear in the sync view"), (Object)node);
        IResource[] outOfSync = this.getOutOfSyncResources((ISynchronizeModelElement)node);
        this.assertResourcesAreTheSame(resources, outOfSync, true);
        ChangeSet[] sets = this.getActiveChangeSetManager().getSets();
        int i = 0;
        while (i < sets.length) {
            ChangeSet changeSet = sets[i];
            node = this.getChangeSetNodeFor(root, changeSet);
            CVSChangeSetTests.assertNotNull((String)("The node for set " + set.getName() + " is not in the view"), (Object)node);
            ++i;
        }
        ChangeSetDiffNode[] nodes = this.getActiveChangeSetNodes(root);
        this.assertNodesInViewer(this.getWorkspaceSubscriber(), nodes);
    }

    private ChangeSetDiffNode getChangeSetNodeFor(ISynchronizeModelElement root, ChangeSet set) {
        IDiffElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            ChangeSetDiffNode node;
            IDiffElement element = children[i];
            if (element instanceof ChangeSetDiffNode && (node = (ChangeSetDiffNode)element).getSet() == set) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private IResource[] getOutOfSyncResources(ISynchronizeModelElement element) {
        ArrayList<SyncInfo> arrayList = new ArrayList<SyncInfo>();
        this.getOutOfSync(element, arrayList);
        SyncInfo[] infos = arrayList.toArray(new SyncInfo[arrayList.size()]);
        IResource[] resources = this.getResources(infos);
        return resources;
    }

    private IResource[] getResources(SyncInfo[] infos) {
        IResource[] resources = new IResource[infos.length];
        int i = 0;
        while (i < resources.length) {
            resources[i] = infos[i].getLocal();
            ++i;
        }
        return resources;
    }

    private void getOutOfSync(ISynchronizeModelElement node, List<SyncInfo> list) {
        SyncInfo info = this.getSyncInfo(node);
        if (info != null && info.getKind() != 0) {
            list.add(info);
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement child = children[i];
            this.getOutOfSync((ISynchronizeModelElement)child, list);
            ++i;
        }
    }

    private SyncInfo getSyncInfo(ISynchronizeModelElement node) {
        if (node instanceof IAdaptable) {
            return (SyncInfo)((IAdaptable)node).getAdapter(SyncInfo.class);
        }
        return null;
    }

    private void assertResourcesAreTheSame(IResource[] resources1, IResource[] resources2, boolean doNotAllowExtra) {
        IResource resource;
        int i;
        if (doNotAllowExtra) {
            if (resources1.length != resources2.length) {
                System.out.println("Expected");
                i = 0;
                while (i < resources1.length) {
                    resource = resources1[i];
                    System.out.println(resource.getFullPath().toString());
                    ++i;
                }
                System.out.println("Actual");
                i = 0;
                while (i < resources2.length) {
                    resource = resources2[i];
                    System.out.println(resource.getFullPath().toString());
                    ++i;
                }
            }
            CVSChangeSetTests.assertEquals((String)"The number of resources do not match the expected number", (int)resources1.length, (int)resources2.length);
        }
        i = 0;
        while (i < resources1.length) {
            resource = resources1[i];
            boolean found = false;
            int j = 0;
            while (j < resources2.length) {
                IResource resource2 = resources2[j];
                if (resource2.equals((Object)resource)) {
                    found = true;
                    break;
                }
                ++j;
            }
            CVSChangeSetTests.assertTrue((String)("Expected resource " + resource.getFullPath().toString() + " was not present"), (boolean)found);
            ++i;
        }
    }

    private void assertInRootSet(IResource[] resources) throws CoreException {
        ISynchronizeModelElement[] nodes = this.getNonChangeSetRoots(this.getModelRoot(((SubscriberChangeSetManager)this.getActiveChangeSetManager()).getSubscriber()));
        ArrayList<SyncInfo> list = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < nodes.length) {
            ISynchronizeModelElement element = nodes[i];
            this.getOutOfSync(element, list);
            ++i;
        }
        IResource[] outOfSync = this.getResources(list.toArray(new SyncInfo[list.size()]));
        this.assertResourcesAreTheSame(resources, outOfSync, false);
    }

    private ISynchronizeModelElement[] getNonChangeSetRoots(ISynchronizeModelElement modelRoot) {
        ArrayList<ISynchronizeModelElement> result = new ArrayList<ISynchronizeModelElement>();
        IDiffElement[] children = modelRoot.getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement element = children[i];
            if (!(element instanceof ChangeSetDiffNode)) {
                result.add((ISynchronizeModelElement)element);
            }
            ++i;
        }
        return result.toArray(new ISynchronizeModelElement[result.size()]);
    }

    public void testSimpleCommit() throws CoreException {
        this.enableCheckedInChangeSets(this.getWorkspaceSubscriber());
        IProject project = this.createProject(new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IProject copy = this.checkoutCopy(project, CVSTag.DEFAULT);
        this.setContentsAndEnsureModified(copy.getFile("file1.txt"));
        String message1 = "Commit 1";
        this.commitResources(new IResource[]{copy}, 2, message1);
        this.assertIncomingChangesInSets(new IFile[][]{{project.getFile("file1.txt")}}, new String[]{message1});
        this.setContentsAndEnsureModified(copy.getFile("file2.txt"));
        this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"));
        String message2 = "Commit 2";
        this.commitResources(new IResource[]{copy}, 2, message2);
        this.assertIncomingChangesInSets(new IFile[][]{{project.getFile("file1.txt")}, {project.getFile("file2.txt"), project.getFile("folder1/a.txt")}}, new String[]{message1, message2});
        this.setContentsAndEnsureModified(copy.getFile("file2.txt"));
        String message3 = "Commit 3";
        this.commitResources(new IResource[]{copy}, 2, message3);
        this.assertIncomingChangesInSets(new IFile[][]{{project.getFile("file1.txt")}, {project.getFile("folder1/a.txt")}, {project.getFile("file2.txt")}}, new String[]{message1, message2, message3});
        this.updateResources(new IResource[]{project.getFile("file1.txt")}, false);
        this.assertIncomingChangesInSets(new IFile[][]{{project.getFile("folder1/a.txt")}, {project.getFile("file2.txt")}}, new String[]{message2, message3});
    }

    public void testSimpleActiveChangeSet() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.enableActiveChangeSets(this.getWorkspaceSubscriber());
        IFolder newFolder = project.getFolder("folder2");
        newFolder.create(false, true, null);
        IFile newFile = newFolder.getFile("file.txt");
        newFile.create((InputStream)new ByteArrayInputStream("Hi There".getBytes()), false, null);
        ActiveChangeSetManager manager = this.getActiveChangeSetManager();
        ActiveChangeSet set = manager.createSet("test", new IDiff[0]);
        manager.add((ChangeSet)set);
        this.assertInActiveSet(new IResource[0], set);
        this.assertInRootSet(new IResource[]{newFolder, newFile});
        set.add(new IResource[]{newFile});
        this.assertInActiveSet(new IResource[]{newFile}, set);
        this.assertInRootSet(new IResource[]{newFolder});
        set.add(new IResource[]{newFolder});
        this.assertInActiveSet(new IResource[]{newFolder, newFile}, set);
    }
}

