/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.subscriber.CVSSyncSubscriberTest;

public class CVSCompareSubscriberTest
extends CVSSyncSubscriberTest {
    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(CVSCompareSubscriberTest.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new CVSCompareSubscriberTest(testName));
    }

    public CVSCompareSubscriberTest() {
    }

    public CVSCompareSubscriberTest(String name) {
        super(name);
    }

    public void testStandardChanges() throws CoreException, IOException {
        IProject project = this.createProject("testCompareChanges", new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/deleted.txt"});
        CVSTag tag = new CVSTag("v1", 2);
        this.tagProject(project, tag, true);
        this.addResources((IContainer)project, new String[]{"addition.txt", "folderAddition/", "folderAddition/new.txt"}, true);
        this.deleteResources((IContainer)project, new String[]{"folder1/a.txt"}, true);
        this.deleteResources((IContainer)project, new String[]{"folder2/"}, true);
        this.appendText((IResource)project.getFile("file1.txt"), "Appended text 1", false);
        this.commitProject(project);
        this.appendText((IResource)project.getFile("file1.txt"), "Appended text 2", false);
        this.commitProject(project);
        this.appendText((IResource)project.getFile("file2.txt"), "appended text", false);
        this.commitProject(project);
        CVSCompareSubscriber subscriber = this.getSyncInfoSource().createCompareSubscriber((IResource)project, tag);
        int[] nArray = new int[10];
        nArray[0] = 3;
        nArray[1] = 3;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[7] = 2;
        nArray[9] = 1;
        this.assertSyncEquals("testIncomingChanges", (Subscriber)subscriber, (IContainer)project, new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/b.txt", "folder1/a.txt", "addition.txt", "folderAddition/", "folderAddition/new.txt", "folder2/", "folder2/deleted.txt"}, true, nArray);
    }

    @Override
    protected void tearDown() throws Exception {
        this.getSyncInfoSource().tearDown();
        super.tearDown();
    }

    public void testInvalidTag() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/deleted.txt"});
        CVSTag tag = new CVSTag("non-existant", 2);
        CVSCompareSubscriber subscriber = this.getSyncInfoSource().createCompareSubscriber((IResource)project.getFolder("folder1"), tag);
        this.assertSyncEquals("testInvalidTag", (Subscriber)subscriber, (IContainer)project.getFolder("folder1"), new String[]{"a.txt", "b.txt"}, true, new int[]{2, 2});
    }

    public void testBinaryAddition() throws CoreException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            CVSTag v1 = new CVSTag("v1", 2);
            IProject copy = this.checkoutCopy(project, "-copy");
            this.create((IResource)copy.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(copy.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{copy.getFile("binaryFile")});
            this.commitProject(copy);
            this.tagProject(copy, v1, false);
            CVSCompareSubscriber subscriber = this.getSyncInfoSource().createCompareSubscriber((IResource)project, v1);
            this.getSyncInfoSource().refresh((Subscriber)subscriber, (IResource)project);
            this.getSyncInfoSource().overrideAndUpdateResources((Subscriber)subscriber, false, new IResource[]{project.getFile("binaryFile")});
            this.assertContentsEqual(copy.getFile("binaryFile"), project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }

    public void testBinaryMarkAsMerged() throws CoreException, InvocationTargetException, InterruptedException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            CVSTag v1 = new CVSTag("v1", 2);
            IProject copy = this.checkoutCopy(project, "-copy");
            this.create((IResource)copy.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(copy.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{copy.getFile("binaryFile")});
            this.commitProject(copy);
            this.tagProject(copy, v1, false);
            this.create((IResource)project.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(project.getFile("binaryFile"), "/n/nSome Content\n\n");
            CVSCompareSubscriber subscriber = this.getSyncInfoSource().createCompareSubscriber((IResource)project, v1);
            this.getSyncInfoSource().refresh((Subscriber)subscriber, (IResource)project);
            this.getSyncInfoSource().markAsMerged((Subscriber)subscriber, new IResource[]{project.getFile("binaryFile")});
            this.assertIsBinary(project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }
}

