/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.tests.ccvs.core.subscriber.CVSSyncSubscriberTest;
import org.eclipse.team.tests.ccvs.ui.ModelParticipantSyncInfoSource;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CompareEditorTests
extends CVSSyncSubscriberTest {
    public static Test suite() {
        return CompareEditorTests.suite(CompareEditorTests.class);
    }

    public CompareEditorTests() {
    }

    public CompareEditorTests(String name) {
        super(name);
    }

    protected CVSSyncTreeSubscriber getSubscriber() throws TeamException {
        return (CVSSyncTreeSubscriber)this.getWorkspaceSubscriber();
    }

    private IEditorInput openEditor(Subscriber subscriber, Object element) {
        IEditorInput input = OpenInCompareAction.openCompareEditor((ISynchronizePageConfiguration)((ModelParticipantSyncInfoSource)this.getSyncInfoSource()).getConfiguration(subscriber), (Object)element, (boolean)false, (boolean)false);
        CompareEditorTests.assertNotNull((Object)input);
        this.assertEditorOpen(input, subscriber);
        return input;
    }

    private IEditorInput openEditor(Object element) throws TeamException {
        return this.openEditor((Subscriber)this.getSubscriber(), element);
    }

    private void assertEditorOpen(IEditorInput input, Subscriber subscriber) {
        this.waitForCollectors(subscriber);
        while (Display.getCurrent().readAndDispatch()) {
        }
        IEditorPart part = this.findOpenEditor(input);
        CompareEditorTests.assertNotNull((String)"The editor is not open", (Object)part);
    }

    private void assertEditorClosed(IEditorInput input) {
        while (Display.getCurrent().readAndDispatch()) {
        }
        IEditorPart part = this.findOpenEditor(input);
        CompareEditorTests.assertNull((String)"The editor is not closed", (Object)part);
    }

    private void assertRevisionsEquals(IEditorInput input, IFile file) throws CVSException {
        while (Display.getCurrent().readAndDispatch()) {
        }
        CompareEditorInput cei = (CompareEditorInput)input;
        ICompareInput node = (ICompareInput)cei.getCompareResult();
        String remoteRevision = ((FileRevisionTypedElement)node.getRight()).getContentIdentifier();
        String localRevision = CVSWorkspaceRoot.getCVSFileFor((IFile)file).getSyncInfo().getRevision();
        CompareEditorTests.assertEquals((String)localRevision, (String)remoteRevision);
    }

    private void assertEditorState(IEditorInput input) throws TeamException {
        ModelCompareEditorInput mcei;
        ICompareInput ci;
        this.waitForCollectors();
        while (Display.getCurrent().readAndDispatch()) {
        }
        CompareEditorInput cei = (CompareEditorInput)input;
        if (cei instanceof ModelCompareEditorInput && (ci = (ICompareInput)(mcei = (ModelCompareEditorInput)cei).getCompareResult()) instanceof ResourceDiffCompareInput) {
            ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)ci;
            IFile file = (IFile)rdci.getResource();
            LocalResourceTypedElement element = (LocalResourceTypedElement)rdci.getLeft();
            EditableSharedDocumentAdapter adapter = (EditableSharedDocumentAdapter)element.getAdapter(ISharedDocumentAdapter.class);
            CompareEditorTests.assertTrue((element.exists() == file.exists() ? 1 : 0) != 0);
            CompareEditorTests.assertTrue((file.exists() == (adapter != null) ? 1 : 0) != 0);
            if (file.exists()) {
                CompareEditorTests.assertTrue((boolean)adapter.isConnected());
            }
            return;
        }
        CompareEditorTests.fail((String)"Unexpected compare input type");
    }

    private void closeAllEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    private IEditorPart findOpenEditor(IEditorInput input) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorInput testInput;
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && (testInput = part.getEditorInput()) == input) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private void dirtyEditor(IFile file, IEditorInput input, String string) {
        FileEditorInput fileEditorInput = new FileEditorInput(file);
        IDocumentProvider provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)fileEditorInput);
        IDocument document = provider.getDocument((Object)fileEditorInput);
        document.set(string);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Utilities.RUNNING_TESTS = true;
        Utils.RUNNING_TESTS = true;
    }

    protected void setTestingFlushOnCompareInputChange(boolean b) {
        Utilities.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE = b;
        Utils.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE = b;
    }

    @Override
    protected void tearDown() throws Exception {
        this.closeAllEditors();
        super.tearDown();
    }

    private void waitForCollectors() throws TeamException {
        this.waitForCollectors((Subscriber)this.getSubscriber());
    }

    private void waitForCollectors(Subscriber subcriber) {
        ((ModelParticipantSyncInfoSource)this.getSyncInfoSource()).waitForCollectionToFinish(subcriber);
    }

    public void testCloseOnUpdate() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("file1.txt"));
        this.commitProject(copy);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        this.updateProject(project, null, false);
        this.waitForCollectors();
        this.assertEditorClosed(input);
    }

    public void testCloseOnCommit() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        this.commitProject(project);
        this.waitForCollectors();
        this.assertEditorClosed(input);
    }

    public void testSaveOnUpdateWhenDirty() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("file1.txt"));
        this.commitProject(copy);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        String contents = "this is the file contents";
        this.dirtyEditor(project.getFile("file1.txt"), input, contents);
        this.setTestingFlushOnCompareInputChange(true);
        this.updateProject(project, null, false);
        this.waitForCollectors();
        this.assertContentsEqual(project.getFile("file1.txt"), contents);
    }

    public void testCloseOnUpdateWhenDirty() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        String incomingContents = "Incoming change";
        this.setContentsAndEnsureModified(copy.getFile("file1.txt"), incomingContents);
        this.commitProject(copy);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        String contents = "this is the file contents";
        this.dirtyEditor(project.getFile("file1.txt"), input, contents);
        this.setTestingFlushOnCompareInputChange(false);
        this.updateProject(project, null, false);
        this.waitForCollectors();
        this.assertContentsEqual(project.getFile("file1.txt"), incomingContents);
    }

    public void testSaveOnCommitWhenDirty() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        String contents = "this is the file contents";
        this.dirtyEditor(project.getFile("file1.txt"), input, contents);
        this.setTestingFlushOnCompareInputChange(true);
        this.commitProject(project);
        this.waitForCollectors();
        this.assertContentsEqual(project.getFile("file1.txt"), contents);
    }

    public void testCloseOnCommitWhenDirty() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        String committedContents = "Committed contents";
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), committedContents);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        String contents = "this is the file contents";
        this.dirtyEditor(project.getFile("file1.txt"), input, contents);
        this.setTestingFlushOnCompareInputChange(false);
        this.commitProject(project);
        this.waitForCollectors();
        this.assertContentsEqual(project.getFile("file1.txt"), committedContents);
    }

    public void testCloseOnParticipantDispose() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        CVSTag v1 = new CVSTag("v1", 2);
        this.tagProject(project, v1, true);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.commitProject(project);
        CVSCompareSubscriber subscriber = this.getSyncInfoSource().createCompareSubscriber((IResource)project, v1);
        this.refresh((Subscriber)subscriber, (IResource)project);
        IEditorInput input = this.openEditor((Subscriber)subscriber, project.getFile("file1.txt"));
        this.getSyncInfoSource().disposeSubscriber((Subscriber)subscriber);
        this.assertEditorClosed(input);
    }

    public void testStayOpenOnParticipantDisposeWhenDirty() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        CVSTag v1 = new CVSTag("v1", 2);
        this.tagProject(project, v1, true);
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.commitProject(project);
        CVSCompareSubscriber subscriber = this.getSyncInfoSource().createCompareSubscriber((IResource)project, v1);
        this.refresh((Subscriber)subscriber, (IResource)project);
        IEditorInput input = this.openEditor((Subscriber)subscriber, project.getFile("file1.txt"));
        String contents = "this is the file contents";
        this.dirtyEditor(project.getFile("file1.txt"), input, contents);
        this.setTestingFlushOnCompareInputChange(true);
        this.getSyncInfoSource().disposeSubscriber((Subscriber)subscriber);
        this.assertEditorOpen(input, (Subscriber)subscriber);
    }

    public void testUpdateOnRemoteChange() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        this.assertRevisionsEquals(input, project.getFile("file1.txt"));
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("file1.txt"));
        this.commitProject(copy);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        this.assertRevisionsEquals(input, copy.getFile("file1.txt"));
    }

    public void testUpdateOnRemoteChangeWhenDirty() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        this.assertRevisionsEquals(input, project.getFile("file1.txt"));
        String contents = "this is the file contents";
        this.dirtyEditor(project.getFile("file1.txt"), input, contents);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("file1.txt"));
        this.commitProject(copy);
        this.setTestingFlushOnCompareInputChange(true);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
        this.assertRevisionsEquals(input, copy.getFile("file1.txt"));
        this.assertContentsEqual(project.getFile("file1.txt"), contents);
    }

    public void testFileCreation() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        project.getFile("file1.txt").delete(false, null);
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        this.assertEditorState(input);
        project.getFile("file1.txt").create((InputStream)new ByteArrayInputStream("Recreated file".getBytes()), false, null);
        this.assertEditorState(input);
    }

    public void testFileDeletion() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        IEditorInput input = this.openEditor(project.getFile("file1.txt"));
        this.assertEditorState(input);
        project.getFile("file1.txt").delete(false, null);
        this.assertEditorState(input);
    }
}

