/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.provider.Diff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.ConfirmMergedOperation;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.subscriber.TestCommitOperation;
import org.eclipse.team.tests.ccvs.core.subscriber.TestMergeUpdateOperation;
import org.eclipse.team.tests.ccvs.core.subscriber.TestOverrideAndUpdateOperation;
import org.eclipse.team.tests.ccvs.core.subscriber.TestUpdateOperation;
import org.junit.Assert;

public class SyncInfoSource {
    protected static IProgressMonitor DEFAULT_MONITOR = new NullProgressMonitor();
    protected List<CVSMergeSubscriber> mergeSubscribers = new ArrayList<CVSMergeSubscriber>();
    protected List<CVSCompareSubscriber> compareSubscribers = new ArrayList<CVSCompareSubscriber>();

    public CVSMergeSubscriber createMergeSubscriber(IProject project, CVSTag root, CVSTag branch) {
        return this.createMergeSubscriber(project, root, branch, false);
    }

    public CVSMergeSubscriber createMergeSubscriber(IProject project, CVSTag root, CVSTag branch, boolean isModelSync) {
        CVSMergeSubscriber subscriber = new CVSMergeSubscriber(new IResource[]{project}, root, branch, isModelSync);
        this.mergeSubscribers.add(subscriber);
        return subscriber;
    }

    public CVSCompareSubscriber createCompareSubscriber(IResource resource, CVSTag tag) {
        CVSCompareSubscriber subscriber = new CVSCompareSubscriber(new IResource[]{resource}, tag);
        this.compareSubscribers.add(subscriber);
        return subscriber;
    }

    public void disposeSubscriber(Subscriber subscriber) {
    }

    public Subscriber createWorkspaceSubscriber() throws TeamException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    protected SyncInfo getSyncInfo(Subscriber subscriber, IResource resource) throws TeamException {
        return subscriber.getSyncInfo(resource);
    }

    protected IDiff getDiff(Subscriber subscriber, IResource resource) throws CoreException {
        return subscriber.getDiff(resource);
    }

    public void refresh(Subscriber subscriber, IResource resource) throws TeamException {
        this.refresh(subscriber, new IResource[]{resource});
    }

    public void refresh(Subscriber subscriber, IResource[] resources) throws TeamException {
        subscriber.refresh(resources, 2, DEFAULT_MONITOR);
    }

    protected void assertProjectRemoved(Subscriber subscriber, IProject project) {
        IResource[] roots = subscriber.roots();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            if (resource.equals((Object)project)) {
                throw new AssertionFailedError();
            }
            ++i;
        }
    }

    public void tearDown() {
        for (CVSMergeSubscriber s : this.mergeSubscribers) {
            s.cancel();
        }
    }

    public void assertSyncEquals(String message, Subscriber subscriber, IResource resource, int syncKind) throws CoreException {
        int kindOther;
        int conflictTypeMask = 15;
        SyncInfo info = this.getSyncInfo(subscriber, resource);
        int kind = info == null ? 0 : info.getKind() & conflictTypeMask;
        if (kind != (kindOther = syncKind & conflictTypeMask) && resource.getType() == 2) {
            if (info.getKind() == 0 && (syncKind & 1) != 0) {
                return;
            }
        } else {
            this.assertDiffKindEquals(message, subscriber, resource, SyncInfoToDiffConverter.asDiffFlags((int)syncKind));
        }
        Assert.assertTrue((String)(String.valueOf(message) + ": improper sync state for " + resource + " expected " + SyncInfo.kindToString((int)kindOther) + " but was " + SyncInfo.kindToString((int)kind)), (kind == kindOther ? 1 : 0) != 0);
    }

    protected void assertDiffKindEquals(String message, Subscriber subscriber, IResource resource, int expectedFlags) throws CoreException {
        int actualFlags = this.getActualDiffFlags(subscriber, resource);
        boolean result = this.compareFlags(resource, actualFlags, expectedFlags);
        int count = 0;
        while (!result && count < 40) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            actualFlags = this.getActualDiffFlags(subscriber, resource);
            result = this.compareFlags(resource, actualFlags, expectedFlags);
            if (result) {
                System.out.println("A timing issue has been detected in the CVS test");
                new Exception().printStackTrace();
                continue;
            }
            ++count;
        }
        String errorString = String.valueOf(message) + ": improper diff for " + resource + " expected " + SyncInfoToDiffConverter.diffStatusToString((int)expectedFlags) + " but was " + SyncInfoToDiffConverter.diffStatusToString((int)actualFlags);
        if (CVSTestSetup.FAIL_ON_BAD_DIFF || expectedFlags != 0 && actualFlags == 0) {
            Assert.assertTrue((String)errorString, (boolean)result);
        } else if (!result) {
            System.out.println(errorString);
            new Exception().printStackTrace();
        }
    }

    private boolean compareFlags(IResource resource, int actualFlags, int expectedFlags) {
        if (actualFlags != expectedFlags && resource.getType() == 2) {
            int expectedKind = expectedFlags & 0xFF;
            int actualKind = actualFlags & 0xFF;
            if (actualKind == 0 && expectedKind == 1) {
                return true;
            }
        }
        return actualFlags == expectedFlags;
    }

    private int getActualDiffFlags(Subscriber subscriber, IResource resource) throws CoreException {
        IDiff node = this.getDiff(subscriber, resource);
        int actualFlags = node == null ? 0 : ((Diff)node).getStatus();
        return actualFlags;
    }

    public void mergeResources(Subscriber subscriber, IResource[] resources, boolean allowOverwrite) throws TeamException, InvocationTargetException, InterruptedException {
        SyncInfo[] infos = this.createSyncInfos(subscriber, resources);
        this.mergeResources(subscriber, infos, allowOverwrite);
    }

    private void mergeResources(Subscriber subscriber, SyncInfo[] infos, boolean allowOverwrite) throws InvocationTargetException, InterruptedException {
        TestMergeUpdateOperation action = new TestMergeUpdateOperation(this.getElements(infos), allowOverwrite);
        action.run(DEFAULT_MONITOR);
    }

    protected SyncInfo[] createSyncInfos(Subscriber subscriber, IResource[] resources) throws TeamException {
        SyncInfo[] result = new SyncInfo[resources.length];
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            result[i] = this.getSyncInfo(subscriber, resource);
            ++i;
        }
        return result;
    }

    public void markAsMerged(Subscriber subscriber, IResource[] resources) throws InvocationTargetException, InterruptedException, TeamException {
        SyncInfo[] infos = this.createSyncInfos(subscriber, resources);
        new ConfirmMergedOperation(null, this.getElements(infos)).run(DEFAULT_MONITOR);
    }

    protected IDiffElement[] getElements(SyncInfo[] infos) {
        SyncInfoModelElement[] elements = new SyncInfoModelElement[infos.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = new SyncInfoModelElement(null, infos[i]);
            ++i;
        }
        return elements;
    }

    public void updateResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        this.runSubscriberOperation((CVSSubscriberOperation)new TestUpdateOperation(this.getElements(this.createSyncInfos(subscriber, resources))));
    }

    public void commitResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        this.runSubscriberOperation((CVSSubscriberOperation)new TestCommitOperation(this.getElements(this.createSyncInfos(subscriber, resources)), false));
    }

    public void overrideAndUpdateResources(Subscriber subscriber, boolean shouldPrompt, IResource[] resources) throws CoreException {
        TestOverrideAndUpdateOperation action = new TestOverrideAndUpdateOperation(this.getElements(this.createSyncInfos(subscriber, resources)));
        this.runSubscriberOperation((CVSSubscriberOperation)action);
        Assert.assertTrue((shouldPrompt == action.isPrompted() ? 1 : 0) != 0);
    }

    public void overrideAndCommitResources(Subscriber subscriber, IResource[] resources) throws CoreException {
        TestCommitOperation action = new TestCommitOperation(this.getElements(this.createSyncInfos(subscriber, resources)), true);
        this.runSubscriberOperation((CVSSubscriberOperation)action);
    }

    private void runSubscriberOperation(CVSSubscriberOperation op) throws CoreException {
        try {
            op.run();
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Assert.fail((String)"Operation was interrupted");
        }
    }
}

