/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.util.List;
import junit.framework.Test;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.ui.ReflectionUtils;

public class CVSHisoryTableProviderTest
extends EclipseTest {
    public void testAllNegatives() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        CVSHistoryTableProvider provider = new CVSHistoryTableProvider();
        TreeViewer treeViewer = provider.createTree(composite);
        Tree tree = treeViewer.getTree();
        Layout layout = tree.getLayout();
        Item[] items = (Item[])ReflectionUtils.callMethod(layout, "getColumns", new Class[]{Composite.class}, new Object[]{tree});
        CVSHisoryTableProviderTest.assertEquals((int)6, (int)items.length);
        List columns = (List)ReflectionUtils.getField(layout, "columns");
        int weight = ((ColumnWeightData)columns.get((int)0)).weight;
        for (ColumnLayoutData column : columns) {
            CVSHisoryTableProviderTest.assertTrue((boolean)(column instanceof ColumnWeightData));
            ColumnWeightData c = (ColumnWeightData)column;
            CVSHisoryTableProviderTest.assertTrue((c.weight > 0 ? 1 : 0) != 0);
            CVSHisoryTableProviderTest.assertEquals((int)weight, (int)c.weight);
        }
    }

    public void testAllZeros() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        CVSHistoryTableProvider provider = new CVSHistoryTableProvider();
        ReflectionUtils.setField(provider, "settings", this.createDialogSettings(provider, new int[6]));
        TreeViewer treeViewer = provider.createTree(composite);
        Tree tree = treeViewer.getTree();
        Layout layout = tree.getLayout();
        Item[] items = (Item[])ReflectionUtils.callMethod(layout, "getColumns", new Class[]{Composite.class}, new Object[]{tree});
        CVSHisoryTableProviderTest.assertEquals((int)6, (int)items.length);
        List columns = (List)ReflectionUtils.getField(layout, "columns");
        int weight = ((ColumnWeightData)columns.get((int)0)).weight;
        for (ColumnLayoutData column : columns) {
            CVSHisoryTableProviderTest.assertTrue((boolean)(column instanceof ColumnWeightData));
            ColumnWeightData c = (ColumnWeightData)column;
            CVSHisoryTableProviderTest.assertTrue((c.weight > 0 ? 1 : 0) != 0);
            CVSHisoryTableProviderTest.assertEquals((int)weight, (int)c.weight);
        }
    }

    public void testNewBranchColumn() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        CVSHistoryTableProvider provider = new CVSHistoryTableProvider();
        ReflectionUtils.setField(provider, "settings", this.createDialogSettings(provider, new int[]{100, -1, 100, 100, 100, 100}));
        TreeViewer treeViewer = provider.createTree(composite);
        Tree tree = treeViewer.getTree();
        Layout layout = tree.getLayout();
        Item[] items = (Item[])ReflectionUtils.callMethod(layout, "getColumns", new Class[]{Composite.class}, new Object[]{tree});
        CVSHisoryTableProviderTest.assertEquals((int)6, (int)items.length);
        List columns = (List)ReflectionUtils.getField(layout, "columns");
        for (ColumnLayoutData column : columns) {
            CVSHisoryTableProviderTest.assertTrue((boolean)(column instanceof ColumnPixelData));
            ColumnPixelData c = (ColumnPixelData)column;
            CVSHisoryTableProviderTest.assertTrue((c.width > 0 ? 1 : 0) != 0);
        }
        int branchesColumnWidth = ((ColumnPixelData)columns.get((int)1)).width;
        int pixels = new PixelConverter((Control)tree).convertWidthInCharsToPixels(CVSUIMessages.HistoryView_branches.length() + 4);
        CVSHisoryTableProviderTest.assertEquals((int)pixels, (int)branchesColumnWidth);
    }

    public void testAllPositives() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        CVSHistoryTableProvider provider = new CVSHistoryTableProvider();
        ReflectionUtils.setField(provider, "settings", this.createDialogSettings(provider, new int[]{100, 100, 100, 100, 100, 100}));
        TreeViewer treeViewer = provider.createTree(composite);
        Tree tree = treeViewer.getTree();
        Layout layout = tree.getLayout();
        Item[] items = (Item[])ReflectionUtils.callMethod(layout, "getColumns", new Class[]{Composite.class}, new Object[]{tree});
        CVSHisoryTableProviderTest.assertEquals((int)6, (int)items.length);
        List columns = (List)ReflectionUtils.getField(layout, "columns");
        for (ColumnLayoutData column : columns) {
            CVSHisoryTableProviderTest.assertTrue((boolean)(column instanceof ColumnPixelData));
            ColumnPixelData c = (ColumnPixelData)column;
            CVSHisoryTableProviderTest.assertEquals((int)100, (int)c.width);
        }
    }

    public void testHiddenColumn() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        CVSHistoryTableProvider provider = new CVSHistoryTableProvider();
        int[] nArray = new int[6];
        nArray[0] = 100;
        nArray[2] = 100;
        nArray[3] = 100;
        nArray[4] = 100;
        nArray[5] = 100;
        ReflectionUtils.setField(provider, "settings", this.createDialogSettings(provider, nArray));
        TreeViewer treeViewer = provider.createTree(composite);
        Tree tree = treeViewer.getTree();
        Layout layout = tree.getLayout();
        Item[] items = (Item[])ReflectionUtils.callMethod(layout, "getColumns", new Class[]{Composite.class}, new Object[]{tree});
        CVSHisoryTableProviderTest.assertEquals((int)6, (int)items.length);
        List columns = (List)ReflectionUtils.getField(layout, "columns");
        ColumnPixelData[] columnsArray = columns.toArray(new ColumnPixelData[0]);
        CVSHisoryTableProviderTest.assertEquals((int)100, (int)columnsArray[0].width);
        CVSHisoryTableProviderTest.assertEquals((int)0, (int)columnsArray[1].width);
        CVSHisoryTableProviderTest.assertEquals((int)100, (int)columnsArray[2].width);
        CVSHisoryTableProviderTest.assertEquals((int)100, (int)columnsArray[3].width);
        CVSHisoryTableProviderTest.assertEquals((int)100, (int)columnsArray[4].width);
        CVSHisoryTableProviderTest.assertEquals((int)100, (int)columnsArray[5].width);
    }

    private IDialogSettings createDialogSettings(CVSHistoryTableProvider provider, int[] widths) {
        String sectionName = (String)ReflectionUtils.getField(provider, "CVS_HISTORY_TABLE_PROVIDER_SECTION");
        DialogSettings settings = new DialogSettings(sectionName);
        CVSHisoryTableProviderTest.assertEquals((int)6, (int)widths.length);
        String key = (String)ReflectionUtils.getField(provider, "COL_REVISIONID_NAME");
        settings.put(key, widths[0]);
        key = (String)ReflectionUtils.getField(provider, "COL_BRANCHES_NAME");
        settings.put(key, widths[1]);
        key = (String)ReflectionUtils.getField(provider, "COL_TAGS_NAME");
        settings.put(key, widths[2]);
        key = (String)ReflectionUtils.getField(provider, "COL_DATE_NAME");
        settings.put(key, widths[3]);
        key = (String)ReflectionUtils.getField(provider, "COL_AUTHOR_NAME");
        settings.put(key, widths[4]);
        key = (String)ReflectionUtils.getField(provider, "COL_COMMENT_NAME");
        settings.put(key, widths[5]);
        return settings;
    }

    public static Test suite() {
        return CVSHisoryTableProviderTest.suite(CVSHisoryTableProviderTest.class);
    }
}

