/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutMultipleProjectsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutSingleProjectOperation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.ui.CVSOperationTest;

public class CheckoutOperationTests
extends CVSOperationTest {
    public CheckoutOperationTests() {
    }

    public CheckoutOperationTests(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(CheckoutOperationTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new CheckoutOperationTests(testName));
    }

    public void testSimpleCheckout() throws CoreException, TeamException, IOException {
        IProject project = this.createProject("testSimpleCheckout", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        project.move((IPath)new Path("moved-project"), false, DEFAULT_MONITOR);
        IProject movedProject = ResourcesPlugin.getWorkspace().getRoot().getProject("moved-project");
        CheckoutMultipleProjectsOperation op = new CheckoutMultipleProjectsOperation(null, new ICVSRemoteFolder[]{(ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)movedProject)}, null);
        this.run((CVSOperation)op);
        this.assertEquals(project, movedProject);
    }

    public void testNonRootCheckout() throws CoreException, TeamException {
        IProject project = this.createProject("testNonRootCheckout", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        CheckoutMultipleProjectsOperation op = new CheckoutMultipleProjectsOperation(null, new ICVSRemoteFolder[]{(ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFolder("folder1"))}, null);
        this.run((CVSOperation)op);
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject("folder1");
        CheckoutOperationTests.assertTrue((boolean)newProject.exists());
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)newProject);
        FolderSyncInfo projectInfo = cvsFolder.getFolderSyncInfo();
        CheckoutOperationTests.assertTrue((projectInfo != null ? 1 : 0) != 0);
        ICVSFolder cvsFolder2 = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("folder1"));
        FolderSyncInfo folderInfo = cvsFolder2.getFolderSyncInfo();
        CheckoutOperationTests.assertTrue((folderInfo != null ? 1 : 0) != 0);
        CheckoutOperationTests.assertTrue((boolean)projectInfo.equals((Object)folderInfo));
    }

    public void testMulitpleCheckout() throws CoreException, TeamException {
        IProject project1 = this.createProject("testNonRootCheckout1", new String[]{"file.txt", "folder1/", "folder1/a.txt"});
        IProject project2 = this.createProject("testNonRootCheckout2", new String[]{"file2.txt", "folder2/", "folder2/b.txt"});
        project1.move((IPath)new Path("moved-project1"), false, DEFAULT_MONITOR);
        IProject movedProject1 = ResourcesPlugin.getWorkspace().getRoot().getProject("moved-project1");
        project2.move((IPath)new Path("moved-project2"), false, DEFAULT_MONITOR);
        IProject movedProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject("moved-project2");
        CheckoutMultipleProjectsOperation op = new CheckoutMultipleProjectsOperation(null, new ICVSRemoteFolder[]{(ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)movedProject1), (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)movedProject2)}, null);
        this.run((CVSOperation)op);
    }

    public void testCheckoutAs() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testCheckoutAs", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + "-copy");
        CheckoutSingleProjectOperation op = new CheckoutSingleProjectOperation(null, (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project), copy, null, false);
        this.run((CVSOperation)op);
        this.assertEquals(project, copy);
    }
}

