/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class CommitSetTests
extends EclipseTest {
    private List<ChangeSet> addedSets = new ArrayList<ChangeSet>();
    private List<ChangeSet> removedSets = new ArrayList<ChangeSet>();
    private IChangeSetChangeListener listener = new IChangeSetChangeListener(){

        public void setAdded(ChangeSet set) {
            CommitSetTests.this.addedSets.add(set);
        }

        public void setRemoved(ChangeSet set) {
            CommitSetTests.this.removedSets.add(set);
        }

        public void nameChanged(ChangeSet set) {
        }

        public void defaultSetChanged(ChangeSet oldDefault, ChangeSet set) {
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
        }
    };

    public static Test suite() {
        return CommitSetTests.suite(CommitSetTests.class);
    }

    public CommitSetTests() {
    }

    public CommitSetTests(String name) {
        super(name);
    }

    protected ActiveChangeSet createCommitSet(String title, IFile[] files, boolean manageSet) throws CoreException {
        this.assertIsModified(this.getName(), (IResource[])files);
        ActiveChangeSetManager manager = CVSUIPlugin.getPlugin().getChangeSetManager();
        ActiveChangeSet set = manager.createSet(title, files);
        CommitSetTests.assertEquals((String)"Not all files were added to the set", (int)files.length, (int)set.getResources().length);
        if (manageSet) {
            manager.add((ChangeSet)set);
            this.waitForSetAddedEvent(set);
        }
        return set;
    }

    protected void commit(ActiveChangeSet set) throws CoreException {
        boolean isManaged = this.setIsManaged(set);
        this.commitResources(set.getResources(), 0);
        if (isManaged) {
            this.waitForSetRemovedEvent(set);
        }
    }

    private boolean setIsManaged(ActiveChangeSet set) {
        return CVSUIPlugin.getPlugin().getChangeSetManager().contains((ChangeSet)set);
    }

    private void waitForSetAddedEvent(ActiveChangeSet set) {
        int count = 0;
        while (count < 5) {
            if (this.addedSets.contains(set)) {
                this.addedSets.remove(set);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++count;
        }
        CommitSetTests.fail((String)"Did not receive expected set added event");
    }

    private void waitForSetRemovedEvent(ActiveChangeSet set) {
        int count = 0;
        while (count < 5) {
            if (this.removedSets.contains(set)) {
                this.removedSets.remove(set);
                return;
            }
            try {
                while (Display.getCurrent().readAndDispatch()) {
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++count;
        }
        CommitSetTests.fail((String)"Did not receive expected set removed event");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CVSUIPlugin.getPlugin().getChangeSetManager().addListener(this.listener);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        CVSUIPlugin.getPlugin().getChangeSetManager().removeListener(this.listener);
    }

    public void testSimpleCommit() throws TeamException, CoreException, IOException {
        IProject project = this.createProject(new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.deleteResources((IContainer)project, new String[]{"deleted.txt"}, false);
        this.addResources((IContainer)project, new String[]{"added.txt"}, false);
        IFile[] files = new IFile[]{project.getFile("changed.txt"), project.getFile("deleted.txt"), project.getFile("added.txt")};
        ActiveChangeSet set = this.createCommitSet("testSimpleCommit", files, false);
        this.commit(set);
        this.assertLocalStateEqualsRemote(project);
    }

    public void testManagedCommit() throws TeamException, CoreException, IOException {
        IProject project = this.createProject(new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.deleteResources((IContainer)project, new String[]{"deleted.txt"}, false);
        this.addResources((IContainer)project, new String[]{"added.txt"}, false);
        IFile[] files = new IFile[]{project.getFile("changed.txt"), project.getFile("deleted.txt"), project.getFile("added.txt")};
        ActiveChangeSet set = this.createCommitSet("testSimpleCommit", files, true);
        this.commit(set);
        this.assertLocalStateEqualsRemote(project);
    }
}

