/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.DiffListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.core.TeamCVSTestPlugin;
import org.eclipse.team.tests.ccvs.ui.ReflectionUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreatePatchTest
extends EclipseTest {
    public static final String PATCHDATA = "patchdata";
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 350;
    private GenerateDiffFileWizard wizard = null;
    private WizardDialog wizardDialog = null;
    private IProject testProject = null;

    public CreatePatchTest() {
    }

    public CreatePatchTest(String name) {
        super(name);
    }

    public static Test suite() {
        return CreatePatchTest.suite(CreatePatchTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testProject = this.createProject("ApplyPatchTest", new String[0]);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.testProject.delete(true, null);
    }

    public void _testCreateWorkspacePatch() {
        this.copyIntoWorkspace("exp_addition.txt", "addition.txt");
        this.openGenerateDiffFileWizard(new IResource[]{this.testProject});
        CreatePatchTest.assertTrue((this.wizard.getPageCount() == 2 ? 1 : 0) != 0);
        IWizardPage locationPage = this.wizard.getPages()[0];
        this.getButton(locationPage, "cpRadio").setSelection(false);
        this.getButton(locationPage, "fsRadio").setSelection(false);
        this.getButton(locationPage, "wsRadio").setSelection(true);
        this.getButton(locationPage, "wsRadio").notifyListeners(13, this.createSelectionEvent());
        this.getText(locationPage, "wsPathText").setText("/" + this.testProject.getName() + "/patch_addition.txt");
        this.waitForSelection();
        this.processQueuedEvents();
        CreatePatchTest.assertTrue((boolean)locationPage.canFlipToNextPage());
        this.callMethod(this.wizardDialog, "nextPressed");
        IWizardPage optionsPage = this.wizard.getPages()[1];
        this.getButton(optionsPage, "unifiedDiffOption").setSelection(true);
        this.getButton(optionsPage, "contextDiffOption").setSelection(false);
        this.getButton(optionsPage, "regularDiffOption").setSelection(false);
        this.getButton(optionsPage, "unified_workspaceRelativeOption").setSelection(true);
        this.getButton(optionsPage, "unified_projectRelativeOption").setSelection(false);
        this.getButton(optionsPage, "unified_selectionRelativeOption").setSelection(false);
        this.processQueuedEvents();
        CreatePatchTest.assertTrue((boolean)this.wizard.canFinish());
        this.wizard.performFinish();
        this.wizardDialog.close();
        String[] prefixesToIgnore = new String[]{"#P ApplyPatchTest-", "--- /dev/null", "+++ addition.txt"};
        InputStream expectedIS = this.asInputStream("patch_addition.txt");
        String expected = this.filterStream(expectedIS, prefixesToIgnore);
        IFile patchFile = this.testProject.getFile("patch_addition.txt");
        String actual = this.readProjectFile(patchFile, prefixesToIgnore);
        CreatePatchTest.assertEquals((String)expected, (String)actual);
    }

    private void openGenerateDiffFileWizard(IResource[] resources) {
        String title = CVSUIMessages.GenerateCVSDiff_title;
        this.wizard = new GenerateDiffFileWizard(this.getActivePart(), resources, true);
        this.wizard.setWindowTitle(title);
        this.wizardDialog = new WizardDialog(this.getShell(), (IWizard)this.wizard);
        this.wizardDialog.setMinimumPageSize(300, 350);
        this.wizardDialog.setBlockOnOpen(false);
        this.wizardDialog.open();
    }

    private void copyIntoWorkspace(String source, String target) {
        IFile file = this.testProject.getFile(target);
        InputStream is = this.asInputStream(source);
        try {
            if (file.exists()) {
                file.setContents(is, true, true, null);
            } else {
                file.create(is, true, null);
            }
        }
        catch (CoreException e) {
            CreatePatchTest.fail((String)e.getMessage());
        }
    }

    private void waitForSelection() {
        IWizardPage locationPage = this.wizard.getPages()[0];
        int toSleep = 100;
        int totalWaited = 0;
        IResource[] sel = null;
        while (sel == null || sel.length == 0) {
            sel = (IResource[])this.callMethod(locationPage, "getSelectedResources");
            this.processQueuedEvents();
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException e) {
                CreatePatchTest.fail((String)e.getMessage());
            }
            CreatePatchTest.assertTrue(((totalWaited += toSleep) < 2500 ? 1 : 0) != 0);
        }
    }

    private String readProjectFile(IFile file, String[] prefixesToIgnore) {
        String[] ret = new String[1];
        int toSleep = 100;
        int totalWaited = 0;
        while (!file.exists()) {
            this.processQueuedEvents();
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException e) {
                CreatePatchTest.fail((String)e.getMessage());
            }
            CreatePatchTest.assertTrue(((totalWaited += toSleep) < 2500 ? 1 : 0) != 0);
        }
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                String string = this.filterStream(file.getContents(), prefixesToIgnore);
            }, (ISchedulingRule)file, 0, null);
        }
        catch (CoreException e) {
            CreatePatchTest.fail((String)e.getMessage());
        }
        return ret[0];
    }

    private String filterStream(InputStream stream, String[] prefixesToIgnore) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        try {
            while ((line = reader.readLine()) != null) {
                boolean ignore = false;
                int i = 0;
                while (i < prefixesToIgnore.length && !ignore) {
                    ignore = line.startsWith(prefixesToIgnore[i]);
                    ++i;
                }
                if (ignore) continue;
                buffer.append(String.valueOf(line) + "\n");
            }
        }
        catch (IOException e) {
            CreatePatchTest.fail((String)e.getMessage());
        }
        String ret = buffer.toString();
        try {
            reader.close();
        }
        catch (IOException e) {
            CreatePatchTest.fail((String)e.getMessage());
        }
        return ret;
    }

    private InputStream asInputStream(String name) {
        IPath path = new Path(PATCHDATA).append(name);
        try {
            URL base = TeamCVSTestPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(base, path.toString());
            return url.openStream();
        }
        catch (IOException iOException) {
            CreatePatchTest.fail((String)("Failed while reading " + name));
            return null;
        }
    }

    private Text getText(Object object, String name) {
        return (Text)ReflectionUtils.getField(object, name);
    }

    private Button getButton(Object object, String name) {
        return (Button)ReflectionUtils.getField(object, name);
    }

    private Object callMethod(Object object, String name) {
        return ReflectionUtils.callMethod(object, name, new Object[0]);
    }

    private Shell getShell() {
        return this.getActivePart().getSite().getShell();
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        CreatePatchTest.assertNotNull((Object)window);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            window.setActivePage(window.getPages()[0]);
            page = window.getActivePage();
        }
        CreatePatchTest.assertNotNull((Object)page);
        return page.getActivePart();
    }

    private void processQueuedEvents() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    private Event createSelectionEvent() {
        Event event = new Event();
        event.type = 13;
        return event;
    }

    public void testBug319661() throws FileNotFoundException, CoreException {
        Session session = new Session((ICVSRepositoryLocation)this.getRepository(), (ICVSFolder)this.getCVSResource((IResource)this.testProject)){
            private BufferedReader serverResp;
            {
                this.serverResp = new BufferedReader(new InputStreamReader(CreatePatchTest.this.asInputStream("server_response_with_error.txt")));
            }

            public String readLine() throws CVSException {
                try {
                    return this.serverResp.readLine();
                }
                catch (IOException e) {
                    throw new CVSException((IStatus)new Status(4, null, null, (Throwable)e));
                }
            }

            public void close() {
                try {
                    super.close();
                    this.serverResp.close();
                }
                catch (IOException e) {
                    CreatePatchTest.fail((String)e.getMessage());
                }
            }
        };
        PrintStream stream = new PrintStream(new FileOutputStream(this.testProject.getFile("/patch_with_error.txt").getLocation().toFile()));
        try {
            session.open(this.getMonitor());
            DiffListener diffListener = new DiffListener(stream);
            IStatus status = Command.DIFF.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[0], new String[0], (ICommandOutputListener)diffListener, this.getMonitor());
            CreatePatchTest.assertNotNull((String)"Diff command did not report error when some changes were excluded", (Object)status);
            CreatePatchTest.assertEquals((String)"Diff command did not report server error", (int)-10, (int)status.getCode());
            IStatus[] children = status.getChildren();
            CreatePatchTest.assertTrue((String)"Diff command did not report any server errors", (children.length > 0 ? 1 : 0) != 0);
            boolean errorLineOccurred = false;
            int i = 0;
            while (i < children.length) {
                if (children[i].getCode() == -14) {
                    errorLineOccurred = true;
                    break;
                }
                ++i;
            }
            CreatePatchTest.assertTrue((String)"Diff command did not report error line", (boolean)errorLineOccurred);
        }
        finally {
            session.close();
            stream.close();
        }
    }
}

