/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.ui.IActionDelegate;

public class EnablementTest
extends EclipseTest {
    public EnablementTest() {
    }

    public EnablementTest(String name) {
        super(name);
    }

    protected IProject createTestProject(IActionDelegate actionDelegate) throws CoreException, TeamException {
        String actionName = this.getName(actionDelegate);
        return this.createProject(actionName, new String[]{"file.txt", "folder1/", "folder1/a.txt"});
    }

    protected List<IResource> getManagedResources(IProject testProject, boolean includeFolders, boolean multiple) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        if (includeFolders) {
            result.add((IResource)testProject.getFolder("folder1"));
        } else {
            result.add((IResource)testProject.getFile("folder1/a.txt"));
        }
        if (multiple) {
            result.add((IResource)testProject.getFile("file.txt"));
        }
        return result;
    }

    protected List<IResource> getAddedResources(IProject testProject) throws CoreException, TeamException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFile file = testProject.getFile("added.txt");
        if (!file.exists()) {
            this.addResources((IContainer)testProject, new String[]{"added.txt"}, false);
        }
        result.add((IResource)file);
        return result;
    }

    protected List<IResource> getIgnoredResources(IProject testProject) throws CoreException, TeamException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFile file = testProject.getFile("ignored.txt");
        if (!file.exists()) {
            file.create(this.getRandomContents(), false, null);
        }
        result.add((IResource)file);
        IFile ignoreFile = testProject.getFile(".cvsignore");
        ByteArrayInputStream contents = new ByteArrayInputStream("ignored.txt".getBytes());
        if (ignoreFile.exists()) {
            ignoreFile.setContents((InputStream)contents, false, false, null);
        } else {
            ignoreFile.create((InputStream)contents, false, null);
        }
        return result;
    }

    protected List<IResource> getUnmanagedResources(IProject testProject) throws CoreException, TeamException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFile file = testProject.getFile("unmanaged.txt");
        if (!file.exists()) {
            file.create(this.getRandomContents(), false, null);
        }
        result.add((IResource)file);
        return result;
    }

    protected List<IResource> getResourceWithUnmanagedParent(IProject project) throws CoreException {
        IFile file;
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFolder folder = project.getFolder("newFolder");
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        if (!(file = folder.getFile("unmanaged.txt")).exists()) {
            file.create(this.getRandomContents(), false, null);
        }
        result.add((IResource)file);
        return result;
    }

    protected List<IResource> getOverlappingResources(IProject testProject, boolean includeFiles) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        result.add((IResource)testProject);
        result.add((IResource)testProject.getFolder("folder1"));
        if (includeFiles) {
            result.add((IResource)testProject.getFile("folder1/a.txt"));
        }
        return result;
    }

    protected ISelection asSelection(List<IResource> resources) {
        return new StructuredSelection(resources);
    }

    protected String getName(IActionDelegate actionDelegate) {
        return actionDelegate.getClass().getName();
    }

    protected void assertEnablement(IActionDelegate actionDelegate, ISelection selection, boolean expectedEnablement) {
        Action action = new Action(){};
        actionDelegate.selectionChanged((IAction)action, selection);
        EnablementTest.assertEquals((String)(String.valueOf(this.getName(actionDelegate)) + " enablement wrong!"), (boolean)expectedEnablement, (boolean)action.isEnabled());
    }
}

