/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.actions.AddAction;
import org.eclipse.team.internal.ccvs.ui.actions.BranchAction;
import org.eclipse.team.internal.ccvs.ui.actions.CommitAction;
import org.eclipse.team.internal.ccvs.ui.actions.CompareWithRevisionAction;
import org.eclipse.team.internal.ccvs.ui.actions.CompareWithTagAction;
import org.eclipse.team.internal.ccvs.ui.actions.GenerateDiffFileAction;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.actions.MergeAction;
import org.eclipse.team.internal.ccvs.ui.actions.ReplaceWithRemoteAction;
import org.eclipse.team.internal.ccvs.ui.actions.ReplaceWithSelectableTagAction;
import org.eclipse.team.internal.ccvs.ui.actions.SetKeywordSubstitutionAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.actions.SyncAction;
import org.eclipse.team.internal.ccvs.ui.actions.TagLocalAction;
import org.eclipse.team.internal.ccvs.ui.actions.UnmanageAction;
import org.eclipse.team.internal.ccvs.ui.actions.UpdateAction;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.ui.EnablementTest;
import org.eclipse.ui.IActionDelegate;

public class MenuEnablementTest
extends EnablementTest {
    private static final int MANAGED = 1;
    private static final int ADDED = 2;
    private static final int UNMANAGED = 4;
    private static final int IGNORED = 8;
    private static final int SINGLE_ONLY = 16;
    private static final int FOLDERS = 32;
    private static final int FILES = 64;
    private static final int UNMANAGED_PARENT = 128;

    public MenuEnablementTest() {
    }

    public MenuEnablementTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MenuEnablementTest.class);
        return new CVSTestSetup((Test)suite);
    }

    private void assertEnablement(IActionDelegate action, IProject project, int kind, boolean expectedEnablement) throws CoreException, TeamException {
        boolean includeFolders;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        boolean multiple = (kind & 0x10) == 0;
        boolean bl = includeFolders = (kind & 0x20) > 0 || (kind & 0x40) == 0;
        if ((kind & 1) > 0) {
            resources.addAll(this.getManagedResources(project, includeFolders, multiple));
        }
        if ((kind & 4) > 0) {
            resources.addAll(this.getUnmanagedResources(project));
        }
        if ((kind & 8) > 0) {
            resources.addAll(this.getIgnoredResources(project));
        }
        if ((kind & 2) > 0) {
            resources.addAll(this.getAddedResources(project));
        }
        if ((kind & 0x80) > 0) {
            resources.addAll(this.getResourceWithUnmanagedParent(project));
        }
        this.ensureAllSyncInfoLoaded(project);
        this.assertEnablement(action, this.asSelection(resources), expectedEnablement);
    }

    private void ensureAllSyncInfoLoaded(IProject project) throws CVSException {
        EclipseSynchronizer.getInstance().ensureSyncInfoLoaded(new IResource[]{project}, 2);
    }

    public void assertDisabledForCommonReasons(IActionDelegate action, IProject project) throws CoreException {
        this.assertDisabledForNoSelection(action);
        this.assertDisabledForFolderFileOverlap(action, project);
        this.assertDisabledForClosedProject(action, project);
        this.assertDisabledForNonCVSProject(action);
    }

    private void assertDisabledForNoSelection(IActionDelegate actionDelegate) {
        this.assertEnablement(actionDelegate, (ISelection)StructuredSelection.EMPTY, false);
    }

    private void assertDisabledForFolderFileOverlap(IActionDelegate action, IProject project) {
        List<IResource> resources = this.getOverlappingResources(project, true);
        this.assertEnablement(action, this.asSelection(resources), false);
    }

    private void assertDisabledForClosedProject(IActionDelegate action, IProject project) throws CoreException {
        project.close(null);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add((IResource)project);
        this.assertEnablement(action, this.asSelection(resources), false);
        project.open(null);
    }

    private void assertDisabledForNonCVSProject(IActionDelegate action) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Non-CVS");
        if (!project.exists()) {
            project.create(null);
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add((IResource)project);
        this.assertEnablement(action, this.asSelection(resources), false);
    }

    private void assertEnabledForFolderOnlyOverlap(IActionDelegate action, IProject project) {
        List<IResource> resources = this.getOverlappingResources(project, false);
        this.assertEnablement(action, this.asSelection(resources), true);
    }

    public void testAddAction() throws CoreException, TeamException {
        AddAction action = new AddAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, false);
        this.assertEnablement((IActionDelegate)action, project, 2, false);
        this.assertEnablement((IActionDelegate)action, project, 8, true);
        this.assertEnablement((IActionDelegate)action, project, 4, true);
        this.assertEnablement((IActionDelegate)action, project, 12, true);
        this.assertEnablement((IActionDelegate)action, project, 20, true);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, true);
    }

    public void testBranchAction() throws CoreException, TeamException {
        BranchAction action = new BranchAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
    }

    public void testCommitAction() throws CoreException, TeamException {
        CommitAction action = new CommitAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 7, true);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, true);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, true);
    }

    public void testCompareWithRevison() throws CoreException, TeamException {
        CompareWithRevisionAction action = new CompareWithRevisionAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 81, true);
        this.assertEnablement((IActionDelegate)action, project, 97, false);
        this.assertEnablement((IActionDelegate)action, project, 49, false);
        this.assertEnablement((IActionDelegate)action, project, 65, false);
        this.assertEnablement((IActionDelegate)action, project, 18, false);
        this.assertEnablement((IActionDelegate)action, project, 20, false);
        this.assertEnablement((IActionDelegate)action, project, 24, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
    }

    public void testCompareWithTagAction() throws CoreException, TeamException {
        CompareWithTagAction action = new CompareWithTagAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
    }

    public void testGenerateDiffAction() throws CoreException, TeamException {
        GenerateDiffFileAction action = new GenerateDiffFileAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 81, true);
        this.assertEnablement((IActionDelegate)action, project, 97, false);
        this.assertEnablement((IActionDelegate)action, project, 49, true);
        this.assertEnablement((IActionDelegate)action, project, 65, false);
        this.assertEnablement((IActionDelegate)action, project, 18, true);
        this.assertEnablement((IActionDelegate)action, project, 20, true);
        this.assertEnablement((IActionDelegate)action, project, 24, false);
        this.assertEnablement((IActionDelegate)action, project, 128, true);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
    }

    public void testIgnoreAction() throws CoreException, TeamException {
        IgnoreAction action = new IgnoreAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, false);
        this.assertEnablement((IActionDelegate)action, project, 2, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, true);
        this.assertEnablement((IActionDelegate)action, project, 20, true);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, true);
    }

    public void testMergeAction() throws CoreException, TeamException {
        MergeAction action = new MergeAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
    }

    public void testReplaceWithRemoteAction() throws CoreException, TeamException {
        ReplaceWithRemoteAction action = new ReplaceWithRemoteAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, false);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
    }

    public void testReplaceWithTagAction() throws CoreException, TeamException {
        ReplaceWithSelectableTagAction action = new ReplaceWithSelectableTagAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
    }

    public void testKeywordSubstitutionAction() throws CoreException, TeamException {
        SetKeywordSubstitutionAction action = new SetKeywordSubstitutionAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
    }

    public void testShowInHistory() throws CoreException, TeamException {
        ShowResourceInHistoryAction action = new ShowResourceInHistoryAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 81, true);
        this.assertEnablement((IActionDelegate)action, project, 97, false);
        this.assertEnablement((IActionDelegate)action, project, 49, false);
        this.assertEnablement((IActionDelegate)action, project, 65, false);
        this.assertEnablement((IActionDelegate)action, project, 18, false);
        this.assertEnablement((IActionDelegate)action, project, 20, false);
        this.assertEnablement((IActionDelegate)action, project, 24, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
    }

    public void testSyncAction() throws CoreException, TeamException {
        SyncAction action = new SyncAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, true);
        this.assertEnablement((IActionDelegate)action, project, 7, true);
        this.assertEnablement((IActionDelegate)action, project, 8, true);
        this.assertEnablement((IActionDelegate)action, project, 4, true);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
        this.assertEnablement((IActionDelegate)action, project, 13, true);
    }

    public void testTagAction() throws CoreException, TeamException {
        TagLocalAction action = new TagLocalAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, false);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
    }

    public void testUnmanageAction() throws CoreException, TeamException {
        UnmanageAction action = new UnmanageAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add((IResource)project);
        this.ensureAllSyncInfoLoaded(project);
        this.assertEnablement((IActionDelegate)action, this.asSelection(resources), true);
    }

    public void testUpdateAction() throws CoreException, TeamException {
        UpdateAction action = new UpdateAction();
        IProject project = this.createTestProject((IActionDelegate)action);
        this.assertDisabledForCommonReasons((IActionDelegate)action, project);
        this.assertEnabledForFolderOnlyOverlap((IActionDelegate)action, project);
        this.assertEnablement((IActionDelegate)action, project, 1, true);
        this.assertEnablement((IActionDelegate)action, project, 3, false);
        this.assertEnablement((IActionDelegate)action, project, 7, false);
        this.assertEnablement((IActionDelegate)action, project, 8, false);
        this.assertEnablement((IActionDelegate)action, project, 4, false);
        this.assertEnablement((IActionDelegate)action, project, 13, false);
        this.assertEnablement((IActionDelegate)action, project, 128, false);
    }
}

