/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.DisconnectOperation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.ui.CVSOperationTest;

public class MiscOperationsTests
extends CVSOperationTest {
    public MiscOperationsTests() {
    }

    public MiscOperationsTests(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(MiscOperationsTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new MiscOperationsTests(testName));
    }

    public void testDisconnect() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.run((CVSOperation)new DisconnectOperation(null, new IProject[]{project}, false));
        MiscOperationsTests.assertNull((Object)RepositoryProvider.getProvider((IProject)project));
        MiscOperationsTests.assertTrue((boolean)project.getFolder("CVS").exists());
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
        this.run((CVSOperation)new DisconnectOperation(null, new IProject[]{project}, true));
        MiscOperationsTests.assertNull((Object)RepositoryProvider.getProvider((IProject)project));
        MiscOperationsTests.assertTrue((boolean)project.getFolder("folder1").exists());
        MiscOperationsTests.assertTrue((boolean)project.getFile("file1.txt").exists());
        MiscOperationsTests.assertTrue((!project.getFolder("CVS").exists() ? 1 : 0) != 0);
    }
}

