/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard;

public class PatchWizardRadioButtonGroupTests
extends TestCase {
    private MyRadioButtonGroup group;
    private Button button1;
    private Button button2;
    private Button button3;
    private static final int FORMAT_UNIFIED = PatchWizardRadioButtonGroupTests.getFieldValue("FORMAT_UNIFIED");
    private static final int FORMAT_CONTEXT = PatchWizardRadioButtonGroupTests.getFieldValue("FORMAT_CONTEXT");
    private static final int FORMAT_STANDARD = PatchWizardRadioButtonGroupTests.getFieldValue("FORMAT_STANDARD");

    public PatchWizardRadioButtonGroupTests() {
    }

    public PatchWizardRadioButtonGroupTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PatchWizardRadioButtonGroupTests.class.getName());
        suite.addTest((Test)new PatchWizardRadioButtonGroupTests("testSingleSelection"));
        suite.addTest((Test)new PatchWizardRadioButtonGroupTests("testMultipleSelection"));
        suite.addTest((Test)new PatchWizardRadioButtonGroupTests("testSelectDisabled1"));
        suite.addTest((Test)new PatchWizardRadioButtonGroupTests("testSelectDisabled2"));
        suite.addTest((Test)new PatchWizardRadioButtonGroupTests("testSelectDisabled3"));
        suite.addTest((Test)new PatchWizardRadioButtonGroupTests("testSetEnablement"));
        return suite;
    }

    protected void setUp() throws Exception {
        Shell shell = new Shell(Display.getCurrent());
        Composite composite = new Composite((Composite)shell, 0);
        this.group = new MyRadioButtonGroup();
        this.button1 = new Button(composite, 16);
        this.button2 = new Button(composite, 16);
        this.button3 = new Button(composite, 16);
    }

    private Button getButtonForCode(int code) {
        if (code == PatchWizardRadioButtonGroupTests.getFieldValue("FORMAT_UNIFIED")) {
            return this.button1;
        }
        if (code == PatchWizardRadioButtonGroupTests.getFieldValue("FORMAT_CONTEXT")) {
            return this.button2;
        }
        if (code == PatchWizardRadioButtonGroupTests.getFieldValue("FORMAT_STANDARD")) {
            return this.button3;
        }
        PatchWizardRadioButtonGroupTests.fail();
        return null;
    }

    public void testSingleSelection() {
        this.button1.setEnabled(true);
        this.button1.setSelection(true);
        this.group.add(FORMAT_UNIFIED, this.button1);
        this.button2.setEnabled(true);
        this.button2.setSelection(false);
        this.group.add(FORMAT_CONTEXT, this.button2);
        this.button3.setEnabled(true);
        this.button3.setSelection(false);
        this.group.add(FORMAT_STANDARD, this.button3);
        PatchWizardRadioButtonGroupTests.assertEquals((int)this.group.getSelected(), (int)FORMAT_UNIFIED);
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button1.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button3.getSelection());
    }

    public void testMultipleSelection() {
        this.button1.setEnabled(true);
        this.button1.setSelection(true);
        this.group.add(FORMAT_UNIFIED, this.button1);
        this.button2.setEnabled(true);
        this.button2.setSelection(true);
        this.group.add(FORMAT_CONTEXT, this.button2);
        this.button3.setEnabled(true);
        this.button3.setSelection(true);
        this.group.add(FORMAT_STANDARD, this.button3);
        PatchWizardRadioButtonGroupTests.assertEquals((int)FORMAT_STANDARD, (int)this.group.getSelected());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button1.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button3.getSelection());
    }

    public void testSelectDisabled1() {
        this.button1.setEnabled(true);
        this.button1.setSelection(false);
        this.group.add(FORMAT_UNIFIED, this.button1);
        this.button2.setEnabled(false);
        this.button2.setSelection(true);
        this.group.add(FORMAT_CONTEXT, this.button2);
        this.button3.setEnabled(true);
        this.button3.setSelection(false);
        this.group.add(FORMAT_STANDARD, this.button3);
        this.group.selectEnabledOnly();
        PatchWizardRadioButtonGroupTests.assertFalse((this.group.getSelected() == FORMAT_CONTEXT ? 1 : 0) != 0);
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).getSelection());
    }

    public void testSelectDisabled2() {
        this.button1.setSelection(false);
        this.group.add(FORMAT_UNIFIED, this.button1);
        this.button2.setSelection(true);
        this.group.add(FORMAT_CONTEXT, this.button2);
        this.button3.setSelection(false);
        this.group.add(FORMAT_STANDARD, this.button3);
        this.group.setEnablement(false, new int[]{FORMAT_UNIFIED, FORMAT_CONTEXT}, FORMAT_STANDARD);
        PatchWizardRadioButtonGroupTests.assertEquals((int)FORMAT_STANDARD, (int)this.group.getSelected());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button1.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button3.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button1.isEnabled());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.isEnabled());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button3.isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).getSelection());
    }

    public void testSelectDisabled3() {
        this.button1.setSelection(true);
        this.group.add(FORMAT_UNIFIED, this.button1);
        this.button2.setSelection(false);
        this.group.add(FORMAT_CONTEXT, this.button2);
        this.button3.setSelection(false);
        this.group.add(FORMAT_STANDARD, this.button3);
        this.group.setEnablement(false, new int[]{FORMAT_UNIFIED, FORMAT_CONTEXT});
        PatchWizardRadioButtonGroupTests.assertEquals((int)FORMAT_STANDARD, (int)this.group.getSelected());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button1.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button3.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button1.isEnabled());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.isEnabled());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button3.isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).getSelection());
    }

    public void testSetEnablement() {
        this.button1.setSelection(true);
        this.group.add(FORMAT_UNIFIED, this.button1);
        this.button2.setSelection(false);
        this.button2.setEnabled(false);
        this.group.add(FORMAT_CONTEXT, this.button2);
        this.button3.setSelection(false);
        this.button3.setEnabled(false);
        this.group.add(FORMAT_STANDARD, this.button3);
        this.group.setEnablement(true, new int[]{FORMAT_UNIFIED, FORMAT_CONTEXT});
        PatchWizardRadioButtonGroupTests.assertEquals((int)FORMAT_UNIFIED, (int)this.group.getSelected());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button1.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button2.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button3.getSelection());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button1.isEnabled());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)true, (boolean)this.button2.isEnabled());
        PatchWizardRadioButtonGroupTests.assertEquals((boolean)false, (boolean)this.button3.isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).isEnabled());
        PatchWizardRadioButtonGroupTests.assertTrue((boolean)this.getButtonForCode(this.group.getSelected()).getSelection());
    }

    private static int getFieldValue(String fieldName) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard$OptionsPage");
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            return (Integer)field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
            return -1;
        }
    }

    private class MyRadioButtonGroup {
        Object groupObject;
        Class<?> clazz;

        public MyRadioButtonGroup() {
            try {
                GenerateDiffFileWizard wizard = new GenerateDiffFileWizard(null, null, false);
                this.clazz = Class.forName("org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard$RadioButtonGroup");
                Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
                constructors[0].setAccessible(true);
                this.groupObject = constructors[0].newInstance(wizard);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
            }
        }

        public void add(int buttonCode, Button button) {
            try {
                Class[] partypes = new Class[]{Integer.TYPE, Button.class};
                Method method = this.clazz.getMethod("add", partypes);
                method.setAccessible(true);
                Object[] arglist = new Object[]{buttonCode, button};
                method.invoke(this.groupObject, arglist);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
            }
        }

        public int getSelected() {
            try {
                Class[] partypes = new Class[]{};
                Method method = this.clazz.getMethod("getSelected", partypes);
                method.setAccessible(true);
                Object[] arglist = new Object[]{};
                Object retobj = method.invoke(this.groupObject, arglist);
                return (Integer)retobj;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
                return 0;
            }
        }

        public int selectEnabledOnly() {
            try {
                Class[] partypes = new Class[]{};
                Method method = this.clazz.getMethod("selectEnabledOnly", partypes);
                method.setAccessible(true);
                Object[] arglist = new Object[]{};
                Object retobj = method.invoke(this.groupObject, arglist);
                return (Integer)retobj;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
                return 0;
            }
        }

        public void setEnablement(boolean enabled, int[] buttonsToChange, int defaultSelection) {
            try {
                Class[] partypes = new Class[]{Boolean.TYPE, buttonsToChange.getClass(), Integer.TYPE};
                Method method = this.clazz.getMethod("setEnablement", partypes);
                method.setAccessible(true);
                Object[] arglist = new Object[]{enabled, buttonsToChange, defaultSelection};
                method.invoke(this.groupObject, arglist);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
            }
        }

        public void setEnablement(boolean enabled, int[] buttonsToChange) {
            try {
                Class[] partypes = new Class[]{Boolean.TYPE, buttonsToChange.getClass()};
                Method method = this.clazz.getMethod("setEnablement", partypes);
                method.setAccessible(true);
                Object[] arglist = new Object[]{enabled, buttonsToChange};
                method.invoke(this.groupObject, arglist);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                PatchWizardRadioButtonGroupTests.fail((String)e.getMessage());
            }
        }
    }
}

