/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.importing.provisional.IBundleImporter;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProviderType;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSScmUrlImportWizardPage;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.ui.ReflectionUtils;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.PlatformUI;

public class ProjectSetImporterTests
extends EclipseTest {
    private static final String PSF_FILENAME = "temp.psf";
    private static final File PSF_FILE = new File("temp.psf");
    private static final String psf_header_0 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String psf_header_1 = "<psf version=\"2.0\">";
    private static final String psf_header_2 = "<provider id=\"org.eclipse.team.cvs.core.cvsnature\">";
    private static final String psf_0 = "<project reference=\"1.0," + CVSTestSetup.REPOSITORY_LOCATION + ",";
    private static final String psf_1 = ",";
    private static final String psf_2 = "\"/>";
    private static final String psf_footer_0 = "</provider>";
    private static final String psf_footer_1 = "</psf>";

    public ProjectSetImporterTests() {
    }

    public ProjectSetImporterTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ProjectSetImporterTests.class);
        return new CVSTestSetup((Test)suite);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        PSF_FILE.delete();
    }

    public void testImportProject() throws TeamException, CoreException {
        IProject project1 = this.createProject("testImportProject", new String[]{"file.txt", "folder1/", "folder1/a.txt"});
        IProject project2 = this.createProject("testImportProject", new String[]{"file.txt", "folder1/", "folder1/a.txt"});
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(PSF_FILE)), true);
                out.println(psf_header_0);
                out.println(psf_header_1);
                out.println("\t<provider id=\"org.eclipse.team.cvs.core.cvsnature\">");
                out.println("\t\t" + psf_0 + project1.getName() + psf_1 + project1.getName() + psf_2);
                out.println("\t\t" + psf_0 + project2.getName() + psf_1 + project2.getName() + psf_2);
                out.println("\t</provider>");
                out.println(psf_footer_1);
                project1.delete(true, null);
                project2.delete(true, null);
                IProject[] importProjectSet = ProjectSetImporter.importProjectSet((String)PSF_FILENAME, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null);
                ProjectSetImporterTests.assertEquals((int)2, (int)importProjectSet.length);
                this.assertEquals(project1, importProjectSet[0]);
                this.assertEquals(project2, importProjectSet[1]);
            }
            catch (InvocationTargetException e) {
                ProjectSetImporterTests.fail((String)"1.", (Throwable)e.getCause());
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                ProjectSetImporterTests.fail((String)"2.", (Throwable)e);
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void testBug234149_aFewProviders() throws TeamException, CoreException {
        IProject project = this.createProject("testBug234149_aFewProviders", new String[0]);
        IProject project2 = this.createProject("testBug234149_aFewProviders", new String[0]);
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(PSF_FILE)), true);
                out.println(psf_header_0);
                out.println(psf_header_1);
                out.println("\t<provider id=\"org.eclipse.team.cvs.core.cvsnature\">");
                out.println("\t\t" + psf_0 + project.getName() + psf_1 + project.getName() + psf_2);
                out.println("\t</provider>");
                out.println("\t<provider id=\"org.eclipse.team.cvs.core.cvsnature\">");
                out.println("\t\t" + psf_0 + project2.getName() + psf_1 + project2.getName() + psf_2);
                out.println("\t</provider>");
                out.println(psf_footer_1);
                project.delete(true, null);
                project2.delete(true, null);
                IProject[] importProjectSet = null;
                importProjectSet = ProjectSetImporter.importProjectSet((String)PSF_FILENAME, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null);
                this.assertEquals(project, importProjectSet[0]);
                this.assertEquals(project2, importProjectSet[1]);
            }
            catch (InvocationTargetException e) {
                ProjectSetImporterTests.fail((String)"1.", (Throwable)e.getCause());
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                ProjectSetImporterTests.fail((String)"2.", (Throwable)e);
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void testBug298925_noToAll() throws TeamException, CoreException {
        IProject project = this.createProject("testBug298925_noToAll", new String[0]);
        String[] referenceStrings = new String[]{"1.0," + CVSTestSetup.REPOSITORY_LOCATION + psf_1 + project.getName() + psf_1 + project.getName()};
        RepositoryProviderType type = RepositoryProviderType.getProviderType((String)CVSProviderPlugin.getTypeId());
        ProjectSetCapability c = type.getProjectSetCapability();
        c.addToWorkspace(referenceStrings, new ProjectSetSerializationContext(), null);
    }

    public void testScmUrlImport() throws TeamException, CoreException {
        IProject project = this.createProject("testScmUrlImport", new String[0]);
        project.delete(true, true, null);
        this.ensureDoesNotExistInWorkspace((IResource)project);
        IScmUrlImportWizardPage[] pages = TeamUI.getPages((String)"org.eclipse.team.core.cvs.importer");
        ProjectSetImporterTests.assertEquals((int)1, (int)pages.length);
        String s = "scm:cvs:" + CVSTestSetup.REPOSITORY_LOCATION + ":" + project.getName();
        ScmUrlImportDescription d = new ScmUrlImportDescription(s, project.getName());
        ScmUrlImportDescription[] selection = new ScmUrlImportDescription[]{d};
        ProjectSetCapability c = new CVSTeamProviderType().getProjectSetCapability();
        ArrayList<String> references = new ArrayList<String>();
        ScmUrlImportDescription[] scmUrlImportDescriptionArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            ScmUrlImportDescription element = scmUrlImportDescriptionArray[n2];
            references.add(c.asReference(element.getUri(), element.getProject()));
            ++n2;
        }
        c.addToWorkspace(references.toArray(new String[references.size()]), new ProjectSetSerializationContext(), null);
        this.assertExistsInWorkspace((IResource)project);
    }

    public void testScmUrlImportWithName() throws TeamException, CoreException {
        IProject project = this.createProject("testScmUrlImportWithName", new String[0]);
        project.delete(true, true, null);
        this.ensureDoesNotExistInWorkspace((IResource)project);
        IScmUrlImportWizardPage[] pages = TeamUI.getPages((String)"org.eclipse.team.core.cvs.importer");
        ProjectSetImporterTests.assertEquals((int)1, (int)pages.length);
        String s = "scm:cvs:" + CVSTestSetup.REPOSITORY_LOCATION + ":" + project.getName() + ";project=project1";
        ScmUrlImportDescription d = new ScmUrlImportDescription(s, project.getName());
        ScmUrlImportDescription[] selection = new ScmUrlImportDescription[]{d};
        ProjectSetCapability c = new CVSTeamProviderType().getProjectSetCapability();
        ArrayList<String> references = new ArrayList<String>();
        ScmUrlImportDescription[] scmUrlImportDescriptionArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            ScmUrlImportDescription element = scmUrlImportDescriptionArray[n2];
            references.add(c.asReference(element.getUri(), null));
            ++n2;
        }
        c.addToWorkspace(references.toArray(new String[references.size()]), new ProjectSetSerializationContext(), null);
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("project1");
        this.assertExistsInWorkspace((IResource)project1);
    }

    public void testScmUrlImportWithTag() throws TeamException, CoreException, IOException {
        IProject project = this.createProject("testScmUrlImportWithTag", new String[0]);
        this.tagProject(project, new CVSTag("tag", 2), false);
        project.delete(true, true, null);
        this.ensureDoesNotExistInWorkspace((IResource)project);
        final IScmUrlImportWizardPage[] pages = TeamUI.getPages((String)"org.eclipse.team.core.cvs.importer");
        ProjectSetImporterTests.assertEquals((int)1, (int)pages.length);
        String s = "scm:cvs:" + CVSTestSetup.REPOSITORY_LOCATION + ":" + project.getName() + ";tag=tag";
        ScmUrlImportDescription d = new ScmUrlImportDescription(s, project.getName());
        ScmUrlImportDescription[] selection = new ScmUrlImportDescription[]{d};
        pages[0].setSelection(selection);
        ProjectSetImporterTests.assertTrue((boolean)(pages[0] instanceof CVSScmUrlImportWizardPage));
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                pages[0].finish();
                return true;
            }
        };
        wizard.addPage((IWizardPage)pages[0]);
        WizardDialog wizardDialog = new WizardDialog(new Shell(Display.getCurrent()), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(false);
        wizardDialog.open();
        Button useHead = (Button)ReflectionUtils.getField(pages[0], "useHead");
        useHead.setSelection(true);
        wizard.performFinish();
        wizardDialog.close();
        selection = pages[0].getSelection();
        IBundleImporter cvsBundleImporter = ProjectSetImporterTests.getBundleImporter("org.eclipse.team.core.cvs.importer");
        cvsBundleImporter.performImport(selection, null);
        this.assertExistsInWorkspace((IResource)project);
        IProject copy = this.checkoutCopy(project, CVSTag.DEFAULT);
        this.assertEquals(project, copy, false, false);
    }

    public void testCvsBundleImporter() throws TeamException, CoreException {
        IBundleImporter cvsBundleImporter = ProjectSetImporterTests.getBundleImporter("org.eclipse.team.core.cvs.importer");
        ProjectSetImporterTests.assertNotNull((Object)cvsBundleImporter);
        IProject project = this.createProject("testCvsBundleImporter", new String[0]);
        project.delete(true, true, null);
        this.ensureDoesNotExistInWorkspace((IResource)project);
        String s = "scm:cvs:" + CVSTestSetup.REPOSITORY_LOCATION + ":" + project.getName();
        Map[] manifests = new Map[1];
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Eclipse-SourceReferences", s);
        manifests[0] = map;
        ScmUrlImportDescription[] descriptions = cvsBundleImporter.validateImport(manifests);
        ProjectSetImporterTests.assertEquals((int)1, (int)descriptions.length);
        cvsBundleImporter.performImport(descriptions, null);
        this.assertExistsInWorkspace((IResource)project);
    }

    private static IBundleImporter getBundleImporter(String id) {
        IBundleImporter[] importers;
        IBundleImporter[] iBundleImporterArray = importers = Team.getBundleImporters();
        int n = importers.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleImporter importer = iBundleImporterArray[n2];
            if (importer.getId().equals(id)) {
                return importer;
            }
            ++n2;
        }
        return null;
    }
}

