/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui.benchmark;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.zip.ZipException;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkUtils;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class BenchmarkTest
extends EclipseTest {
    private HashMap<String, PerformanceMeter> groups;
    private PerformanceMeter currentMeter;

    protected BenchmarkTest() {
    }

    protected BenchmarkTest(String name) {
        super(name);
    }

    protected IProject createUniqueProject(File zipFile) throws TeamException, CoreException, ZipException, IOException, InterruptedException, InvocationTargetException {
        return this.createAndImportProject(this.getName(), zipFile);
    }

    protected IProject createAndImportProject(String prefix, File zipFile) throws TeamException, CoreException, ZipException, IOException, InterruptedException, InvocationTargetException {
        IProject project = this.getUniqueTestProject(prefix);
        BenchmarkUtils.importZip((IContainer)project, zipFile);
        return project;
    }

    protected void startTask(String string) {
    }

    protected void endTask() {
    }

    protected void setupGroups(String[] performance_groups) {
        this.setupGroups(performance_groups, null, false);
    }

    protected void setupGroups(String[] performance_groups, String globalName, boolean global) {
        this.groups = new HashMap();
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = null;
        if (global) {
            meter = perf.createPerformanceMeter(perf.getDefaultScenarioId((TestCase)this));
            String[] stringArray = performance_groups;
            int n = performance_groups.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                this.groups.put(suffix, meter);
                ++n2;
            }
            perf.tagAsGlobalSummary(meter, globalName, Dimension.ELAPSED_PROCESS);
        } else {
            String[] stringArray = performance_groups;
            int n = performance_groups.length;
            int n3 = 0;
            while (n3 < n) {
                String suffix = stringArray[n3];
                meter = perf.createPerformanceMeter(String.valueOf(perf.getDefaultScenarioId((TestCase)this)) + suffix);
                Performance.getDefault().setComment(meter, 1, "The current setup for the CVS test does not provide reliable timings. Only consistent test failures over time can be considered significant.");
                this.groups.put(suffix, meter);
                ++n3;
            }
        }
    }

    protected void commitGroups(boolean global) {
        for (PerformanceMeter meter : this.groups.values()) {
            meter.commit();
            if (global) break;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        BenchmarkTest.setModelSync(false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.groups != null) {
                perf = Performance.getDefault();
                try {
                    for (PerformanceMeter meter : this.groups.values()) {
                        perf.assertPerformanceInRelativeBand(meter, Dimension.ELAPSED_PROCESS, -100, 20);
                    }
                }
                finally {
                    ** for (meter : this.groups.values())
                }
lbl-1000:
                // 1 sources

                {
                    meter.dispose();
                    continue;
                }
lbl13:
                // 1 sources

                this.groups = null;
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected void startGroup(String key) {
        BenchmarkTest.assertNull((Object)this.currentMeter);
        this.currentMeter = this.groups.get(key);
        this.currentMeter.start();
    }

    protected void endGroup() {
        this.currentMeter.stop();
        this.currentMeter = null;
    }

    protected void disableLog() {
    }

    protected void enableLog() {
    }

    protected void syncResources(SyncInfoSource source, Subscriber subscriber, IResource[] resources) throws TeamException {
        this.startTask("Synchronize with Repository action");
        source.refresh(subscriber, resources);
        this.endTask();
    }

    protected void syncCommitResources(SyncInfoSource source, IResource[] resources, String comment) throws TeamException, CoreException {
        this.startTask("Synchronize outgoing changes");
        this.syncResources(source, source.createWorkspaceSubscriber(), resources);
        this.endTask();
        this.startTask("Commit outgoing changes");
        this.commitResources(resources, 2);
        this.endTask();
    }

    protected void syncUpdateResources(SyncInfoSource source, IResource[] resources) throws TeamException {
        this.startTask("Synchronize incoming changes");
        this.syncResources(source, source.createWorkspaceSubscriber(), resources);
        this.endTask();
        this.startTask("Update incoming changes");
        this.updateResources(resources, false);
        this.endTask();
    }

    protected void openEmptyPerspective() throws WorkbenchException {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand("org.eclipse.ui.window.closeAllPerspectives", null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {}
        PlatformUI.getWorkbench().showPerspective("org.eclipse.team.tests.cvs.ui.perspective1", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }
}

