/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui.benchmark;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.tests.ccvs.ui.ModelParticipantSyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.ParticipantSyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.SubscriberParticipantSyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTest;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTestSetup;

public class Bug152581Test
extends BenchmarkTest {
    private static final String OLD_SYNCHRONIZE_GROUP_SUFFIX = "OldSynchronize";
    private static final String NEW_SYNCHRONIZE_GROUP_SUFFIX = "NewSynchronize";
    private static final String UPDATE_GROUP_SUFFIX = "Update";
    private static final String OLD_SYNCHRONIZE_GROUP_SUFFIX2 = "OldSynchronize2";
    private static final String NEW_SYNCHRONIZE_GROUP_SUFFIX2 = "NewSynchronize2";
    private static final String UPDATE_GROUP_SUFFIX2 = "Update2";
    private static final String[] PERFORMANCE_GROUPS = new String[]{"OldSynchronize", "NewSynchronize", "Update", "OldSynchronize2", "NewSynchronize2", "Update2"};

    public Bug152581Test() {
    }

    public Bug152581Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Bug152581Test.suite(Bug152581Test.class);
    }

    private void populateProject(BufferedReader reader, IProject project) throws IOException {
        String line;
        IContainer currentDir = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Directory")) {
                String path = line.substring(9).trim();
                currentDir = this.ensureFolderExists(project, path);
                continue;
            }
            if (!line.startsWith("Unchanged")) continue;
            String filename = line.substring(9).trim();
            this.ensureFileExists(currentDir, filename);
        }
    }

    private void ensureFileExists(IContainer currentDir, String filename) {
        if (filename.equals(".project") && currentDir.getType() == 4) {
            return;
        }
        this.ensureExistsInWorkspace((IResource)currentDir.getFile((IPath)new Path(null, filename)), true);
    }

    public void ensureExistsInWorkspace(IResource resource, boolean local) {
        block2: {
            IWorkspaceRunnable body = monitor -> this.create(resource, local);
            try {
                Bug152581Test.getWorkspace().run(body, null);
            }
            catch (CoreException e) {
                if (resource.exists()) break block2;
                Bug152581Test.fail((String)("#ensureExistsInWorkspace(IResource): " + resource.getFullPath()), (Throwable)e);
            }
        }
    }

    private IContainer ensureFolderExists(IProject project, String path) {
        if (path.equals(".")) {
            return project;
        }
        IFolder folder = project.getFolder(path);
        this.ensureExistsInWorkspace((IResource)folder, true);
        return folder;
    }

    private IProject createProject(String filename) throws IOException, CoreException {
        File file = BenchmarkTestSetup.getTestFile(String.valueOf(filename) + ".txt");
        try (InputStream content = this.getContents(file, "Could not read seed file " + filename + ".txt");){
            BufferedReader reader = new BufferedReader(new InputStreamReader(content));
            IProject project = this.getUniqueTestProject(filename);
            this.populateProject(reader, project);
            this.shareProject(project);
            this.updateProject(project, null, false);
            IProject iProject = project;
            return iProject;
        }
    }

    public void testCase1() throws IOException, CoreException {
        this.openEmptyPerspective();
        IProject project = this.createProject("bug152581case1");
        IProject project2 = this.createProject("bug152581case2");
        this.setupGroups(PERFORMANCE_GROUPS, "Sync Tests", false);
        System.out.println("Here we go");
        int i = 0;
        while (i < 100) {
            ParticipantSyncInfoSource source = new SubscriberParticipantSyncInfoSource();
            this.startGroup(OLD_SYNCHRONIZE_GROUP_SUFFIX);
            this.syncResources(source, source.createWorkspaceSubscriber(), new IResource[]{project});
            this.endGroup();
            this.startGroup(OLD_SYNCHRONIZE_GROUP_SUFFIX2);
            this.syncResources(source, source.createWorkspaceSubscriber(), new IResource[]{project2});
            this.endGroup();
            source = new ModelParticipantSyncInfoSource();
            this.startGroup(NEW_SYNCHRONIZE_GROUP_SUFFIX);
            this.syncResources(source, source.createWorkspaceSubscriber(), new IResource[]{project});
            this.endGroup();
            this.startGroup(NEW_SYNCHRONIZE_GROUP_SUFFIX2);
            this.syncResources(source, source.createWorkspaceSubscriber(), new IResource[]{project2});
            this.endGroup();
            this.startGroup(UPDATE_GROUP_SUFFIX);
            this.updateResources(new IResource[]{project}, false);
            this.endGroup();
            this.startGroup(UPDATE_GROUP_SUFFIX2);
            this.updateResources(new IResource[]{project2}, false);
            this.endGroup();
            System.out.println(i + 1);
            ++i;
        }
        this.commitGroups(false);
    }
}

