/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.db.SQL;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.SummaryEntry;
import org.eclipse.test.internal.performance.db.TimeSeries;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.performance.Dimension;
import org.junit.Assert;

public class DB {
    private static final boolean DEBUG = false;
    private static final boolean INFO = true;
    private static final boolean AGGREGATE = true;
    private static final String DERBY = "derby";
    private static final String CLOUDSCAPE = "cloudscape";
    private static DB fgDefault;
    private Connection fConnection;
    private SQL fSQL;
    private int fStoredSamples;
    private boolean fStoreCalled;
    private boolean fIsEmbedded;
    private String fDBType;

    private static String findClosest(String[] names, String name) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            if (name2.equals(name)) {
                return name;
            }
            ++n2;
        }
        Pattern pattern = Pattern.compile("20[0-9][0-9][01][0-9][0-3][0-9]");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        int x = Integer.parseInt(name.substring(matcher.start(), matcher.end()));
        int ix = -1;
        int mind = 0;
        int i = 0;
        while (i < names.length) {
            matcher.reset(names[i]);
            if (matcher.find()) {
                int y = Integer.parseInt(names[i].substring(matcher.start(), matcher.end()));
                int d = Math.abs(y - x);
                if (ix < 0 || d < mind) {
                    mind = d;
                    ix = i;
                }
            }
            ++i;
        }
        if (ix >= 0) {
            return names[ix];
        }
        return name;
    }

    public static Connection getConnection() {
        return DB.getDefault().fConnection;
    }

    static synchronized DB getDefault() {
        if (fgDefault == null) {
            fgDefault = new DB();
            fgDefault.connect();
            if (PerformanceTestPlugin.getDefault() == null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        DB.shutdown();
                    }
                });
            }
        }
        return fgDefault;
    }

    public static Scenario getScenarioSeries(String scenarioName, Variations v, String seriesKey, String startBuild, String endBuild, Dim[] dims) {
        v = (Variations)v.clone();
        v.put(seriesKey, new String[]{startBuild, endBuild});
        Scenario.SharedState ss = new Scenario.SharedState(v, scenarioName, seriesKey, dims);
        Scenario scenario = new Scenario(scenarioName, ss);
        TimeSeries ts = scenario.getTimeSeries(dims[0]);
        if (ts.getLength() < 2) {
            v.put(seriesKey, "%");
            String[] names = DB.querySeriesValues(scenarioName, v, seriesKey);
            if (names.length >= 2) {
                String start = DB.findClosest(names, startBuild);
                String end = DB.findClosest(names, endBuild);
                v.put(seriesKey, new String[]{start, end});
                scenario = new Scenario(scenarioName, ss);
            }
        }
        return scenario;
    }

    public static boolean isActive() {
        return fgDefault != null && fgDefault.getSQL() != null;
    }

    public static void markAsFailed(Variations variations, Sample sample, String failMesg) {
        DB.getDefault().internalMarkAsFailed(variations, sample, failMesg);
    }

    @Deprecated
    public static void queryBuildNames(List<String> names, Variations variationPatterns, String scenarioPattern) {
        DB.getDefault().internalQueryDistinctValues(names, "build", variationPatterns, scenarioPattern);
    }

    public static DataPoint[] queryDataPoints(Variations variations, String scenarioName, Set<Dim> dims) {
        return DB.getDefault().internalQueryDataPoints(variations, scenarioName, dims);
    }

    public static void queryDistinctValues(List<String> values, String key, Variations variationPatterns, String scenarioPattern) {
        DB.getDefault().internalQueryDistinctValues(values, key, variationPatterns, scenarioPattern);
    }

    public static Map<String, String> queryFailure(String scenarioPattern, Variations variations) {
        return DB.getDefault().internalQueryFailure(scenarioPattern, variations);
    }

    @Deprecated
    public static Scenario queryScenario(String configName, String[] buildPatterns, String scenarioName) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPatterns);
        return new Scenario(scenarioName, variations, "build", null);
    }

    @Deprecated
    public static Scenario[] queryScenarios(String configName, String buildPattern, String scenarioPattern) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPattern);
        return DB.queryScenarios(variations, scenarioPattern, "build", null);
    }

    @Deprecated
    public static Scenario[] queryScenarios(String configName, String[] buildPatterns, String scenarioPattern, Dim[] dimensions) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPatterns);
        return DB.queryScenarios(variations, scenarioPattern, "build", dimensions);
    }

    public static Scenario[] queryScenarios(Variations variations, String scenarioPattern, String seriesKey, Dim[] dimensions) {
        String[] scenarioNames = DB.getDefault().internalQueryScenarioNames(variations, scenarioPattern);
        if (scenarioNames == null) {
            return new Scenario[0];
        }
        Scenario.SharedState ss = new Scenario.SharedState(variations, scenarioPattern, seriesKey, dimensions);
        Scenario[] tables = new Scenario[scenarioNames.length];
        int i = 0;
        while (i < scenarioNames.length) {
            tables[i] = new Scenario(scenarioNames[i], ss);
            ++i;
        }
        return tables;
    }

    public static String[] querySeriesValues(String scenarioName, Variations v, String seriesKey) {
        return DB.getDefault().internalQuerySeriesValues(v, scenarioName, seriesKey);
    }

    public static SummaryEntry[] querySummaries(Variations variationPatterns, String scenarioPattern) {
        return DB.getDefault().internalQuerySummaries(variationPatterns, scenarioPattern);
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.disconnect();
            fgDefault = null;
        }
    }

    public static boolean store(Variations variations, Sample sample) {
        return DB.getDefault().internalStore(variations, sample);
    }

    private DB() {
    }

    private void connect() {
        if (this.fConnection != null) {
            return;
        }
        String dbloc = PerformanceTestPlugin.getDBLocation();
        if (dbloc == null) {
            return;
        }
        String dbname = PerformanceTestPlugin.getDBName();
        String url = null;
        Properties info = new Properties();
        this.fDBType = DERBY;
        try {
            if (dbloc.startsWith("net://")) {
                this.fIsEmbedded = false;
                System.out.println("Trying to connect over network, with net:// protocol; org.apache.derby.jdbc.ClientDriver ...");
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("retrieveMessagesFromServerOnGetMessage", "true");
                url = String.valueOf(dbloc) + "/" + dbname + ";create=true";
            } else if (dbloc.startsWith("//")) {
                this.fIsEmbedded = false;
                System.out.println("Trying to connect over network with // jdbc protocol;  org.apache.derby.jdbc.ClientDriver to " + dbloc + '/' + dbname + " ...");
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else {
                File f;
                if ("Mac OS X".equals(System.getProperty("os.name"))) {
                    System.setProperty("derby.storage.fileSyncTransactionLog", "true");
                }
                this.fIsEmbedded = true;
                try {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class.forName("com.ihost.cs.jdbc.CloudscapeDriver");
                    this.fDBType = CLOUDSCAPE;
                }
                if (dbloc.length() == 0) {
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) {
                        return;
                    }
                    f = new File(user_home, this.fDBType);
                } else {
                    f = new File(dbloc);
                }
                url = new File(f, dbname).getAbsolutePath();
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
            }
            try {
                this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
            }
            catch (SQLException e) {
                System.out.println("SQLException: " + e);
                if ("08001".equals(e.getSQLState()) && DERBY.equals(this.fDBType)) {
                    this.fDBType = CLOUDSCAPE;
                    this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
                }
                throw e;
            }
            System.out.println("connect succeeded!");
            this.fConnection.setAutoCommit(false);
            this.fSQL = new SQL(this.fConnection);
            this.fConnection.commit();
        }
        catch (SQLException ex) {
            PerformanceTestPlugin.logError(ex.getMessage());
        }
        catch (ClassNotFoundException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    private void disconnect() {
        block13: {
            if (this.fStoreCalled) {
                System.out.println("stored " + this.fStoredSamples + " new datapoints in DB");
            } else {
                System.out.println("no new datapoints in DB");
            }
            System.out.println("disconnecting from DB");
            if (this.fSQL != null) {
                try {
                    this.fSQL.dispose();
                }
                catch (SQLException e1) {
                    PerformanceTestPlugin.log(e1);
                }
                this.fSQL = null;
            }
            if (this.fConnection != null) {
                try {
                    this.fConnection.commit();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                try {
                    this.fConnection.close();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                this.fConnection = null;
            }
            if (this.fIsEmbedded) {
                try {
                    DriverManager.getConnection("jdbc:" + this.fDBType + ":;shutdown=true");
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (message.indexOf("system shutdown.") >= 0) break block13;
                    e.printStackTrace();
                }
            }
        }
    }

    SQL getSQL() {
        return this.fSQL;
    }

    private void internalMarkAsFailed(Variations variations, Sample sample, String failMesg) {
        if (this.fSQL == null) {
            return;
        }
        try {
            int variation_id = this.fSQL.getVariations(variations);
            int scenario_id = this.fSQL.getScenario(sample.getScenarioID());
            this.fSQL.insertFailure(variation_id, scenario_id, failMesg);
            this.fConnection.commit();
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
            try {
                this.fConnection.rollback();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private DataPoint[] internalQueryDataPoints(Variations variations, String scenarioName, Set<Dim> dimSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void internalQueryDistinctValues(List<String> values, String seriesKey, Variations variations, String scenarioPattern) {
        if (this.fSQL == null) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (ResultSet result = this.fSQL.queryVariations(variations.toExactMatchString(), scenarioPattern);){
                while (result.next()) {
                    Variations v = new Variations();
                    v.parseDB(result.getString(1));
                    String build = v.getProperty(seriesKey);
                    if (build == null || values.contains(build)) continue;
                    values.add(build);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> internalQueryFailure(String scenarioPattern, Variations variations) {
        HashMap<String, String> hashMap;
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        Throwable throwable = null;
        Object var6_7 = null;
        ResultSet result = this.fSQL.queryFailure(variations, scenarioPattern);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            while (result.next()) {
                String scenario = result.getString(1);
                String message = result.getString(2);
                map.put(scenario, message);
            }
            hashMap = map;
            if (result == null) return hashMap;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (result == null) throw throwable2;
                    result.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                PerformanceTestPlugin.log(e);
                return null;
            }
        }
        result.close();
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] internalQueryScenarioNames(Variations variations, String scenarioPattern) {
        String[] stringArray;
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        Throwable throwable = null;
        Object var6_7 = null;
        ResultSet result = this.fSQL.queryScenarios(variations, scenarioPattern);
        try {
            ArrayList<String> scenarios = new ArrayList<String>();
            while (result.next()) {
                scenarios.add(result.getString(1));
            }
            stringArray = scenarios.toArray(new String[scenarios.size()]);
            if (result == null) return stringArray;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (result == null) throw throwable2;
                    result.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                PerformanceTestPlugin.log(e);
                return null;
            }
        }
        result.close();
        return stringArray;
    }

    private String[] internalQuerySeriesValues(Variations v, String scenarioName, String seriesKey) {
        boolean isCloned = false;
        String[] seriesPatterns = null;
        Object object = v.get(seriesKey);
        if (object instanceof String[]) {
            seriesPatterns = (String[])object;
        } else if (object instanceof String) {
            seriesPatterns = new String[]{(String)object};
        } else {
            Assert.assertTrue((boolean)false);
        }
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = seriesPatterns;
        int n = seriesPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String seriesPattern = stringArray[n2];
            if (seriesPattern.indexOf(37) >= 0) {
                if (!isCloned) {
                    v = (Variations)v.clone();
                    isCloned = true;
                }
                v.put(seriesKey, seriesPattern);
                this.internalQueryDistinctValues(values, seriesKey, v, scenarioName);
            } else {
                values.add(seriesPattern);
            }
            ++n2;
        }
        String[] names = values.toArray(new String[values.size()]);
        boolean sort = true;
        Pattern pattern = Pattern.compile("20[0-9][3-9][01][0-9][0-3][0-9]");
        Matcher matcher = pattern.matcher("");
        String[] stringArray2 = names;
        int n3 = names.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray2[n4];
            matcher.reset(name);
            if (!matcher.find()) {
                sort = false;
                break;
            }
            ++n4;
        }
        if (sort) {
            Arrays.sort(names, (o1, o2) -> {
                String s1 = o1;
                String s2 = o2;
                matcher.reset(s1);
                if (matcher.find()) {
                    s1 = s1.substring(matcher.start());
                }
                matcher.reset(s2);
                if (matcher.find()) {
                    s2 = s2.substring(matcher.start());
                }
                return s1.compareTo(s2);
            });
        }
        return names;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SummaryEntry[] internalQuerySummaries(Variations variationPatterns, String scenarioPattern) {
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        ResultSet result = null;
        ArrayList<SummaryEntry> fingerprints = new ArrayList<SummaryEntry>();
        result = scenarioPattern != null ? this.fSQL.querySummaryEntries(variationPatterns, scenarioPattern) : this.fSQL.queryGlobalSummaryEntries(variationPatterns);
        while (result.next()) {
            String scenarioName = result.getString(1);
            String shortName = result.getString(2);
            int dim_id = result.getInt(3);
            boolean isGlobal = result.getShort(4) == 1;
            int comment_id = result.getInt(5);
            int commentKind = 0;
            String comment = null;
            if (comment_id != 0) {
                Throwable throwable = null;
                Object var15_16 = null;
                try (ResultSet rs2 = this.fSQL.getComment(comment_id);){
                    if (rs2.next()) {
                        commentKind = rs2.getInt(1);
                        comment = rs2.getString(2);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (dim_id == 0) continue;
            fingerprints.add(new SummaryEntry(scenarioName, shortName, Dim.getDimension(dim_id), isGlobal, commentKind, comment));
        }
        SummaryEntry[] summaryEntryArray = fingerprints.toArray(new SummaryEntry[fingerprints.size()]);
        if (result == null) return summaryEntryArray;
        try {
            result.close();
            return summaryEntryArray;
        }
        catch (SQLException sQLException) {}
        return summaryEntryArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException sQLException) {}
            return null;
        }
    }

    private boolean internalStore(Variations variations, Sample sample) {
        if (this.fSQL == null || sample == null) {
            return false;
        }
        DataPoint[] dataPoints = sample.getDataPoints();
        int n = dataPoints.length;
        if (n <= 0) {
            return false;
        }
        try {
            Dimension dim;
            int n2;
            int n3;
            Dimension[] dimensionArray;
            int variation_id = this.fSQL.getVariations(variations);
            int scenario_id = this.fSQL.getScenario(sample.getScenarioID());
            String comment = sample.getComment();
            if (sample.isSummary()) {
                Dimension[] summaryDimensions;
                boolean isGlobal = sample.isGlobal();
                int commentId = 0;
                int commentKind = sample.getCommentType();
                if (commentKind == 1 && comment != null) {
                    commentId = this.fSQL.getCommentId(commentKind, comment);
                }
                dimensionArray = summaryDimensions = sample.getSummaryDimensions();
                n3 = summaryDimensions.length;
                n2 = 0;
                while (n2 < n3) {
                    Dimension dimension = dimensionArray[n2];
                    if (dimension instanceof Dim) {
                        this.fSQL.createSummaryEntry(variation_id, scenario_id, ((Dim)dimension).getId(), isGlobal, commentId);
                    }
                    ++n2;
                }
                String shortName = sample.getShortname();
                if (shortName != null) {
                    this.fSQL.setScenarioShortName(scenario_id, shortName);
                }
            } else if (comment != null) {
                int commentId = 0;
                int commentKind = sample.getCommentType();
                if (commentKind == 1) {
                    commentId = this.fSQL.getCommentId(commentKind, comment);
                }
                this.fSQL.createSummaryEntry(variation_id, scenario_id, 0, false, commentId);
            }
            int sample_id = this.fSQL.createSample(variation_id, scenario_id, new Timestamp(sample.getStartTime()));
            StatisticsSession stats = new StatisticsSession(dataPoints);
            Dim[] dims = dataPoints[0].getDimensions();
            int datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -3);
            dimensionArray = dims;
            n3 = dims.length;
            n2 = 0;
            while (n2 < n3) {
                dim = dimensionArray[n2];
                this.fSQL.insertScalar(datapoint_id, ((Dim)dim).getId(), (long)stats.getAverage((Dim)dim));
                ++n2;
            }
            datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -5);
            dimensionArray = dims;
            n3 = dims.length;
            n2 = 0;
            while (n2 < n3) {
                dim = dimensionArray[n2];
                long value = Double.doubleToLongBits(stats.getStddev((Dim)dim));
                this.fSQL.insertScalar(datapoint_id, ((Dim)dim).getId(), value);
                ++n2;
            }
            datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -4);
            dimensionArray = dims;
            n3 = dims.length;
            n2 = 0;
            while (n2 < n3) {
                dim = dimensionArray[n2];
                this.fSQL.insertScalar(datapoint_id, ((Dim)dim).getId(), stats.getCount((Dim)dim));
                ++n2;
            }
            this.fConnection.commit();
            ++this.fStoredSamples;
            this.fStoreCalled = true;
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
            try {
                this.fConnection.rollback();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
        }
        return true;
    }
}

