/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.GapTextStore;
import org.junit.Assert;

public class AbstractGapTextTest {
    protected GapText fText;

    private String printGap() {
        return this.printGap(this.fText.getGapStart(), this.fText.getGapEnd());
    }

    private String printGap(int start, int end) {
        return "[" + start + "," + end + "]";
    }

    protected void assertGap(int start, int end) {
        Assert.assertTrue((String)("Invalid gap. Expected: " + this.printGap(start, end) + " actual:" + this.printGap()), (this.fText.getGapStart() == start && this.fText.getGapEnd() == end ? 1 : 0) != 0);
    }

    protected void assertContents(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.fText.get(0, this.fText.getLength()));
    }

    protected static class GapText
    extends GapTextStore {
        @Deprecated
        public GapText(int lowWatermark, int highWatermark) {
            super(lowWatermark, highWatermark);
        }

        public GapText(int min, int max, float maxGapFactor) {
            super(min, max, maxGapFactor);
        }

        String getText() {
            return super.getContentAsString();
        }

        int getGapStart() {
            return super.getGapStartIndex();
        }

        int getGapEnd() {
            return super.getGapEndIndex();
        }

        int getRawLength() {
            return super.getContentAsString().length();
        }
    }
}

