/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;

public class Accessor {
    private Class<?> fClass;
    private Object fInstance;

    public Accessor(Object instance, Class<?> clazz) {
        Assert.isNotNull((Object)instance);
        Assert.isNotNull(clazz);
        this.fInstance = instance;
        this.fClass = clazz;
    }

    public Accessor(Object instance, String className, ClassLoader classLoader) {
        Assert.isNotNull((Object)instance);
        Assert.isNotNull((Object)className);
        Assert.isNotNull((Object)classLoader);
        this.fInstance = instance;
        try {
            this.fClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            this.fail(e);
        }
    }

    public Accessor(String className, ClassLoader classLoader, Object[] constructorArgs) {
        this(className, classLoader, Accessor.getTypes(constructorArgs), constructorArgs);
    }

    public Accessor(String className, ClassLoader classLoader, Class<?>[] constructorTypes, Object[] constructorArgs) {
        try {
            this.fClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            this.fail(e);
        }
        Constructor<?> constructor = null;
        try {
            constructor = this.fClass.getDeclaredConstructor(constructorTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.fail(e);
        }
        Assert.isNotNull(constructor);
        constructor.setAccessible(true);
        try {
            this.fInstance = constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            this.fail(e);
        }
    }

    public Accessor(String className, ClassLoader classLoader) {
        try {
            this.fClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            this.fail(e);
        }
    }

    public Object invoke(String methodName, Object[] arguments) {
        return this.invoke(methodName, Accessor.getTypes(arguments), arguments);
    }

    public Object invoke(String methodName, Class<?>[] types, Object[] arguments) {
        Method method = null;
        try {
            method = this.fClass.getDeclaredMethod(methodName, types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.fail(e);
        }
        Assert.isNotNull((Object)method);
        method.setAccessible(true);
        try {
            return method.invoke(this.fInstance, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.fail(e);
            return null;
        }
    }

    public void set(String fieldName, Object value) {
        Field field = this.getField(fieldName);
        try {
            field.set(this.fInstance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.fail(e);
        }
    }

    public void set(String fieldName, boolean value) {
        Field field = this.getField(fieldName);
        try {
            field.setBoolean(this.fInstance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.fail(e);
        }
    }

    public void set(String fieldName, int value) {
        Field field = this.getField(fieldName);
        try {
            field.setInt(this.fInstance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.fail(e);
        }
    }

    public Object get(String fieldName) {
        Field field = this.getField(fieldName);
        try {
            return field.get(this.fInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.fail(e);
            return null;
        }
    }

    public boolean getBoolean(String fieldName) {
        Field field = this.getField(fieldName);
        try {
            return field.getBoolean(this.fInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.fail(e);
            return false;
        }
    }

    public int getInt(String fieldName) {
        Field field = this.getField(fieldName);
        try {
            return field.getInt(this.fInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.fail(e);
            return 0;
        }
    }

    public Field getField(String fieldName) {
        Field field = null;
        try {
            field = this.fClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            this.fail(e);
        }
        field.setAccessible(true);
        return field;
    }

    private static Class<?>[] getTypes(Object[] objects) {
        if (objects == null) {
            return null;
        }
        int length = objects.length;
        Class[] classes = new Class[length];
        int i = 0;
        while (i < length) {
            Assert.isNotNull((Object)objects[i]);
            classes[i] = objects[i].getClass();
            ++i;
        }
        return classes;
    }

    private void fail(Throwable e) {
        AssertionFailedException afe = new AssertionFailedException(e.getLocalizedMessage());
        afe.initCause(e);
        throw afe;
    }
}

