/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.text.tests.Accessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextEditTests {
    private IDocument fDocument;
    private MultiTextEdit fRoot;

    @Before
    public void setUp() {
        this.fDocument = new Document("0123456789");
        this.fRoot = new MultiTextEdit();
    }

    @After
    public void tearDown() {
        this.fRoot = null;
        this.fRoot = null;
    }

    @Test
    public void testCovers1() throws Exception {
        InsertEdit insert = new InsertEdit(1, "");
        DeleteEdit delete = new DeleteEdit(2, 2);
        Assert.assertFalse((boolean)insert.covers((TextEdit)delete));
    }

    @Test
    public void testCovers2() throws Exception {
        MultiTextEdit multi = new MultiTextEdit(0, 0);
        MultiTextEdit child = new MultiTextEdit(0, 0);
        Assert.assertTrue((boolean)multi.covers((TextEdit)child));
    }

    @Test
    public void testOverlap1() throws Exception {
        this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 2, "01"));
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)new ReplaceEdit(1, 2, "12"));
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap2() throws Exception {
        this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 2, "01"));
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 1, "0"));
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap3() throws Exception {
        this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 2, "01"));
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)new ReplaceEdit(1, 1, "1"));
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap4() throws Exception {
        this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 3, "012"));
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)new ReplaceEdit(1, 1, "1"));
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap5() throws Exception {
        this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 3, "012"));
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)new InsertEdit(1, "xx"));
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap6() throws Exception {
        this.fRoot.addChild((TextEdit)new ReplaceEdit(0, 3, "012"));
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)new InsertEdit(2, "xx"));
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap7() throws Exception {
        MoveSourceEdit source = new MoveSourceEdit(2, 5);
        MoveTargetEdit target = new MoveTargetEdit(3, source);
        this.fRoot.addChild((TextEdit)source);
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)target);
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap8() throws Exception {
        MoveSourceEdit source = new MoveSourceEdit(2, 5);
        MoveTargetEdit target = new MoveTargetEdit(6, source);
        this.fRoot.addChild((TextEdit)source);
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)target);
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testOverlap9() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(3, 1);
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        MoveSourceEdit s2 = new MoveSourceEdit(2, 3);
        MoveTargetEdit t2 = new MoveTargetEdit(8, s2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)s2);
            this.fRoot.addChild((TextEdit)t2);
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testUndefinedMultiEdit1() throws Exception {
        MultiTextEdit m1 = new MultiTextEdit();
        m1.addChild((TextEdit)new InsertEdit(0, ""));
        this.fRoot.addChild((TextEdit)m1);
        MultiTextEdit m2 = new MultiTextEdit();
        m2.addChild((TextEdit)new InsertEdit(2, ""));
        this.fRoot.addChild((TextEdit)m2);
    }

    @Test
    public void testUndefinedMultiEdit2() throws Exception {
        MultiTextEdit m1 = new MultiTextEdit();
        MultiTextEdit m2 = new MultiTextEdit();
        Assert.assertTrue((boolean)m1.covers((TextEdit)m2));
        Assert.assertTrue((boolean)m2.covers((TextEdit)m1));
    }

    @Test
    public void testUndefinedMultiEdit3() throws Exception {
        MultiTextEdit m2 = new MultiTextEdit();
        Assert.assertEquals((long)0L, (long)m2.getOffset());
        Assert.assertEquals((long)0L, (long)m2.getLength());
        m2.addChild((TextEdit)new DeleteEdit(1, 3));
        Assert.assertEquals((long)1L, (long)m2.getOffset());
        Assert.assertEquals((long)3L, (long)m2.getLength());
    }

    @Test
    public void testUndefinedMultiEdit4() throws Exception {
        MultiTextEdit m2 = new MultiTextEdit();
        m2.addChild((TextEdit)new DeleteEdit(1, 3));
        m2.addChild((TextEdit)new DeleteEdit(4, 2));
        Assert.assertEquals((long)1L, (long)m2.getOffset());
        Assert.assertEquals((long)5L, (long)m2.getLength());
    }

    @Test
    public void testUndefinedMultiEdit5() throws Exception {
        MultiTextEdit m2 = new MultiTextEdit();
        m2.addChild((TextEdit)new DeleteEdit(4, 2));
        m2.addChild((TextEdit)new DeleteEdit(1, 3));
        Assert.assertEquals((long)1L, (long)m2.getOffset());
        Assert.assertEquals((long)5L, (long)m2.getLength());
    }

    @Test
    public void testUndefinedMultiEdit6() throws Exception {
        DeleteEdit d1 = new DeleteEdit(1, 3);
        MultiTextEdit m2 = new MultiTextEdit();
        Assert.assertTrue((boolean)d1.covers((TextEdit)m2));
    }

    @Test
    public void testUnconnected1() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(3, 1);
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)s1);
            this.fRoot.apply(this.fDocument);
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testBufferLength() throws Exception {
        MultiTextEdit edit = new MultiTextEdit(0, this.fDocument.getLength() + 1);
        boolean exception = false;
        try {
            this.fRoot.addChild((TextEdit)edit);
            this.fRoot.apply(this.fDocument);
        }
        catch (MalformedTreeException malformedTreeException) {
            exception = true;
            Assert.assertTrue((boolean)exception);
        }
    }

    @Test
    public void testCopy1() throws Exception {
        MultiTextEdit root = new MultiTextEdit();
        InsertEdit e1 = new InsertEdit(2, "yy");
        ReplaceEdit e2 = new ReplaceEdit(2, 3, "3456");
        root.addChild((TextEdit)e1);
        root.addChild((TextEdit)e2);
        List<TextEdit> org = this.flatten((TextEdit)root);
        TextEditCopier copier = new TextEditCopier((TextEdit)root);
        List<TextEdit> copy = this.flatten(copier.perform());
        TextEditTests.compare(org, copy);
    }

    @Test
    public void testCopy2() throws Exception {
        MultiTextEdit root = new MultiTextEdit();
        CopySourceEdit s1 = new CopySourceEdit(5, 2);
        CopyTargetEdit t1 = new CopyTargetEdit(8, s1);
        CopySourceEdit s2 = new CopySourceEdit(5, 2);
        CopyTargetEdit t2 = new CopyTargetEdit(2, s2);
        s1.addChild((TextEdit)s2);
        root.addChild((TextEdit)s1);
        root.addChild((TextEdit)t1);
        root.addChild((TextEdit)t2);
        List<TextEdit> org = this.flatten((TextEdit)root);
        TextEditCopier copier = new TextEditCopier((TextEdit)root);
        List<TextEdit> copy = this.flatten(copier.perform());
        TextEditTests.compare(org, copy);
    }

    private List<TextEdit> flatten(TextEdit edit) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        TextEditTests.flatten(result, edit);
        return result;
    }

    private static void flatten(List<TextEdit> result, TextEdit edit) {
        result.add(edit);
        TextEdit[] children = edit.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEditTests.flatten(result, children[i]);
            ++i;
        }
    }

    private static void compare(List<TextEdit> org, List<TextEdit> copy) {
        Assert.assertTrue((String)"Same length", (org.size() == copy.size() ? 1 : 0) != 0);
        for (TextEdit edit : copy) {
            MoveTargetEdit target;
            MoveSourceEdit source;
            Assert.assertTrue((String)"Original is part of copy list", (!org.contains(edit) ? 1 : 0) != 0);
            if (edit instanceof MoveSourceEdit) {
                source = (MoveSourceEdit)edit;
                Assert.assertTrue((String)"Target edit isn't a copy", (boolean)copy.contains(source.getTargetEdit()));
                Assert.assertTrue((String)"Traget edit is a original", (!org.contains(source.getTargetEdit()) ? 1 : 0) != 0);
                continue;
            }
            if (edit instanceof MoveTargetEdit) {
                target = (MoveTargetEdit)edit;
                Assert.assertTrue((String)"Source edit isn't a copy", (boolean)copy.contains(target.getSourceEdit()));
                Assert.assertTrue((String)"Source edit is a original", (!org.contains(target.getSourceEdit()) ? 1 : 0) != 0);
                continue;
            }
            if (edit instanceof CopySourceEdit) {
                source = (CopySourceEdit)edit;
                Assert.assertTrue((String)"Target edit isn't a copy", (boolean)copy.contains(source.getTargetEdit()));
                Assert.assertTrue((String)"Traget edit is a original", (!org.contains(source.getTargetEdit()) ? 1 : 0) != 0);
                continue;
            }
            if (!(edit instanceof CopyTargetEdit)) continue;
            target = (CopyTargetEdit)edit;
            Assert.assertTrue((String)"Source edit isn't a copy", (boolean)copy.contains(target.getSourceEdit()));
            Assert.assertTrue((String)"Source edit is a original", (!org.contains(target.getSourceEdit()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInsert1() throws Exception {
        InsertEdit e1 = new InsertEdit(2, "yy");
        ReplaceEdit e2 = new ReplaceEdit(2, 3, "3456");
        this.fRoot.addChild((TextEdit)e1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 2, 6);
        this.assertEquals((TextEdit)e1, 2, 2);
        this.assertEquals((TextEdit)e2, 4, 4);
        Assert.assertEquals((String)"Buffer content", (Object)"01yy345656789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "01yy345656789");
    }

    @Test
    public void testInsert2() throws Exception {
        InsertEdit e1 = new InsertEdit(2, "yy");
        InsertEdit e2 = new InsertEdit(2, "xx");
        this.fRoot.addChild((TextEdit)e1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 2, 4);
        this.assertEquals((TextEdit)e1, 2, 2);
        this.assertEquals((TextEdit)e2, 4, 2);
        Assert.assertEquals((String)"Buffer content", (Object)"01yyxx23456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "01yyxx23456789");
    }

    @Test
    public void testInsert3() throws Exception {
        ReplaceEdit e1 = new ReplaceEdit(0, 2, "011");
        InsertEdit e2 = new InsertEdit(2, "xx");
        ReplaceEdit e3 = new ReplaceEdit(2, 2, "2");
        this.fRoot.addChild((TextEdit)e1);
        this.fRoot.addChild((TextEdit)e2);
        this.fRoot.addChild((TextEdit)e3);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 0, 6);
        this.assertEquals((TextEdit)e1, 0, 3);
        this.assertEquals((TextEdit)e2, 3, 2);
        this.assertEquals((TextEdit)e3, 5, 1);
        Assert.assertEquals((String)"Buffer content", (Object)"011xx2456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "011xx2456789");
    }

    @Test
    public void testInsert4() throws Exception {
        InsertEdit e1 = new InsertEdit(0, "xx");
        this.fRoot.addChild((TextEdit)e1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer length", (long)12L, (long)this.fDocument.getLength());
        this.assertEquals((TextEdit)this.fRoot, 0, 2);
        this.assertEquals((TextEdit)e1, 0, 2);
        Assert.assertEquals((String)"Buffer content", (Object)"xx0123456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "xx0123456789");
    }

    @Test
    public void testInsert5() throws Exception {
        InsertEdit e1 = new InsertEdit(10, "xx");
        this.fRoot.addChild((TextEdit)e1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer length", (long)12L, (long)this.fDocument.getLength());
        this.assertEquals((TextEdit)this.fRoot, 10, 2);
        this.assertEquals((TextEdit)e1, 10, 2);
        Assert.assertEquals((String)"Buffer content", (Object)"0123456789xx", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "0123456789xx");
    }

    @Test
    public void testInsertReplace1() throws Exception {
        ReplaceEdit e1 = new ReplaceEdit(2, 1, "y");
        InsertEdit e2 = new InsertEdit(2, "xx");
        this.fRoot.addChild((TextEdit)e1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 2, 3);
        this.assertEquals((TextEdit)e1, 4, 1);
        this.assertEquals((TextEdit)e2, 2, 2);
        Assert.assertEquals((String)"Buffer content", (Object)"01xxy3456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "01xxy3456789");
    }

    @Test
    public void testDelete1() throws Exception {
        DeleteEdit e1 = new DeleteEdit(3, 1);
        this.fRoot.addChild((TextEdit)e1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 3, 0);
        this.assertEquals((TextEdit)e1, 3, 0);
        Assert.assertEquals((String)"Buffer content", (Object)"012456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "012456789");
    }

    @Test
    public void testDelete2() throws Exception {
        DeleteEdit e1 = new DeleteEdit(4, 1);
        DeleteEdit e2 = new DeleteEdit(3, 1);
        DeleteEdit e3 = new DeleteEdit(5, 1);
        this.fRoot.addChild((TextEdit)e1);
        this.fRoot.addChild((TextEdit)e2);
        this.fRoot.addChild((TextEdit)e3);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 3, 0);
        this.assertEquals((TextEdit)e1, 3, 0);
        this.assertEquals((TextEdit)e2, 3, 0);
        this.assertEquals((TextEdit)e3, 3, 0);
        Assert.assertEquals((String)"Buffer content", (Object)"0126789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "0126789");
    }

    @Test
    public void testDelete3() throws Exception {
        InsertEdit e1 = new InsertEdit(3, "x");
        DeleteEdit e2 = new DeleteEdit(3, 1);
        this.fRoot.addChild((TextEdit)e1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)this.fRoot, 3, 1);
        this.assertEquals((TextEdit)e1, 3, 1);
        this.assertEquals((TextEdit)e2, 4, 0);
        Assert.assertEquals((String)"Buffer content", (Object)"012x456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "012x456789");
    }

    @Test
    public void testDeleteWithChildren() throws Exception {
        DeleteEdit e1 = new DeleteEdit(2, 6);
        MultiTextEdit e2 = new MultiTextEdit(3, 3);
        e1.addChild((TextEdit)e2);
        ReplaceEdit e3 = new ReplaceEdit(3, 1, "xx");
        ReplaceEdit e4 = new ReplaceEdit(5, 1, "yy");
        e2.addChild((TextEdit)e3);
        e2.addChild((TextEdit)e4);
        this.fRoot.addChild((TextEdit)e1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0189", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)this.fRoot, 2, 0);
        this.assertEquals((TextEdit)e1, 2, 0);
        Assert.assertTrue((boolean)e2.isDeleted());
        Assert.assertTrue((boolean)e3.isDeleted());
        Assert.assertTrue((boolean)e4.isDeleted());
        this.doUndoRedo(undo, "0189");
    }

    @Test
    public void testTreeUpdate1() throws Exception {
        MultiTextEdit m1 = new MultiTextEdit();
        InsertEdit e1 = new InsertEdit(2, "aa");
        InsertEdit e2 = new InsertEdit(4, "bb");
        m1.addChild((TextEdit)e1);
        m1.addChild((TextEdit)e2);
        MultiTextEdit m2 = new MultiTextEdit();
        InsertEdit e3 = new InsertEdit(6, "cc");
        InsertEdit e4 = new InsertEdit(8, "dd");
        m2.addChild((TextEdit)e3);
        m2.addChild((TextEdit)e4);
        this.fRoot.addChild((TextEdit)m1);
        this.fRoot.addChild((TextEdit)m2);
        this.assertEquals((TextEdit)m1, 2, 2);
        this.assertEquals((TextEdit)m2, 6, 2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"01aa23bb45cc67dd89", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)e1, 2, 2);
        this.assertEquals((TextEdit)e2, 6, 2);
        this.assertEquals((TextEdit)e3, 10, 2);
        this.assertEquals((TextEdit)e4, 14, 2);
        this.assertEquals((TextEdit)m1, 2, 6);
        this.assertEquals((TextEdit)m2, 10, 6);
        this.assertEquals((TextEdit)this.fRoot, 2, 14);
        this.doUndoRedo(undo, "01aa23bb45cc67dd89");
    }

    @Test
    public void testMove1() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(5, s1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0142356789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)t1, 3, 2);
        this.doUndoRedo(undo, "0142356789");
    }

    @Test
    public void testMove2() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(5, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(2, s1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0156234789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 7, 0);
        this.assertEquals((TextEdit)t1, 2, 2);
        this.doUndoRedo(undo, "0156234789");
    }

    @Test
    public void testMove3() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        ReplaceEdit e2 = new ReplaceEdit(4, 1, "x");
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"01x5623789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)t1, 5, 2);
        this.assertEquals((TextEdit)e2, 2, 1);
        this.doUndoRedo(undo, "01x5623789");
    }

    @Test
    public void testMove4() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(7, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(2, s1);
        ReplaceEdit e2 = new ReplaceEdit(5, 1, "x");
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0178234x69", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 9, 0);
        this.assertEquals((TextEdit)t1, 2, 2);
        this.assertEquals((TextEdit)e2, 7, 1);
        this.doUndoRedo(undo, "0178234x69");
    }

    @Test
    public void testMove5() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 1);
        MoveTargetEdit t1 = new MoveTargetEdit(3, s1);
        ReplaceEdit e2 = new ReplaceEdit(2, 1, "x");
        s1.addChild((TextEdit)e2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)t1, 2, 1);
        this.assertEquals((TextEdit)e2, 2, 1);
        Assert.assertEquals((String)"Buffer content", (Object)"01x3456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "01x3456789");
    }

    @Test
    public void testMove6() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 1);
        MoveTargetEdit t1 = new MoveTargetEdit(2, s1);
        ReplaceEdit e2 = new ReplaceEdit(2, 1, "x");
        s1.addChild((TextEdit)e2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 3, 0);
        this.assertEquals((TextEdit)t1, 2, 1);
        this.assertEquals((TextEdit)e2, 2, 1);
        Assert.assertEquals((String)"Buffer content", (Object)"01x3456789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "01x3456789");
    }

    @Test
    public void testMove7() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 3);
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        ReplaceEdit e2 = new ReplaceEdit(3, 1, "x");
        s1.addChild((TextEdit)e2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"01562x4789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)t1, 4, 3);
        this.assertEquals((TextEdit)e2, 5, 1);
        this.doUndoRedo(undo, "01562x4789");
    }

    @Test
    public void testMove8() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(5, 3);
        MoveTargetEdit t1 = new MoveTargetEdit(1, s1);
        ReplaceEdit e2 = new ReplaceEdit(6, 1, "x");
        s1.addChild((TextEdit)e2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"05x7123489", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 8, 0);
        this.assertEquals((TextEdit)t1, 1, 3);
        this.assertEquals((TextEdit)e2, 2, 1);
        this.doUndoRedo(undo, "05x7123489");
    }

    @Test
    public void testMove9() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(1, 3);
        MoveTargetEdit t1 = new MoveTargetEdit(5, s1);
        MoveSourceEdit s2 = new MoveSourceEdit(1, 1);
        MoveTargetEdit t2 = new MoveTargetEdit(3, s2);
        s1.addChild((TextEdit)s2);
        s1.addChild((TextEdit)t2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 0);
        this.assertEquals((TextEdit)t1, 2, 3);
        this.assertEquals((TextEdit)s2, 2, 0);
        this.assertEquals((TextEdit)t2, 3, 1);
        Assert.assertEquals((String)"Buffer content", (Object)"0421356789", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "0421356789");
    }

    @Test
    public void testMove10() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(8, s1);
        MoveSourceEdit s2 = new MoveSourceEdit(5, 2);
        MoveTargetEdit t2 = new MoveTargetEdit(1, s2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)s2);
        this.fRoot.addChild((TextEdit)t2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 4, 0);
        this.assertEquals((TextEdit)t1, 6, 2);
        this.assertEquals((TextEdit)s2, 5, 0);
        this.assertEquals((TextEdit)t2, 1, 2);
        Assert.assertEquals((String)"Buffer content", (Object)"0561472389", (Object)this.fDocument.get());
        this.doUndoRedo(undo, "0561472389");
    }

    @Test
    public void testMoveWithRangeMarker() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(5, s1);
        RangeMarker marker = new RangeMarker(2, 2);
        s1.addChild((TextEdit)marker);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0142356789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)t1, 3, 2);
        this.assertEquals((TextEdit)marker, 3, 2);
        this.doUndoRedo(undo, "0142356789");
    }

    @Test
    public void testMoveWithTargetDelete() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 3);
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        DeleteEdit e2 = new DeleteEdit(6, 2);
        e2.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)e2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"01589", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        Assert.assertTrue((boolean)t1.isDeleted());
        this.assertEquals((TextEdit)e2, 3, 0);
        this.doUndoRedo(undo, "01589");
    }

    @Test
    public void testMoveUpWithSourceDelete() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(5, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(2, s1);
        DeleteEdit d1 = new DeleteEdit(5, 2);
        d1.addChild((TextEdit)s1);
        RangeMarker marker = new RangeMarker(5, 2);
        s1.addChild((TextEdit)marker);
        this.fRoot.addChild((TextEdit)d1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0156234789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)t1, 2, 2);
        this.assertEquals((TextEdit)marker, 2, 2);
        Assert.assertTrue((boolean)s1.isDeleted());
        this.assertEquals((TextEdit)d1, 7, 0);
        this.doUndoRedo(undo, "0156234789");
    }

    @Test
    public void testMoveDown() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        InsertEdit i1 = new InsertEdit(5, "x");
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        DeleteEdit d1 = new DeleteEdit(9, 1);
        RangeMarker m1 = new RangeMarker(2, 2);
        s1.addChild((TextEdit)m1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)i1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)d1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"014x562378", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)i1, 3, 1);
        this.assertEquals((TextEdit)t1, 6, 2);
        this.assertEquals((TextEdit)m1, 6, 2);
        this.assertEquals((TextEdit)d1, 10, 0);
        this.doUndoRedo(undo, "014x562378");
    }

    @Test
    public void testMoveUp() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(7, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(2, s1);
        InsertEdit i1 = new InsertEdit(5, "x");
        DeleteEdit d1 = new DeleteEdit(9, 1);
        RangeMarker m1 = new RangeMarker(7, 2);
        s1.addChild((TextEdit)m1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)i1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)d1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0178234x56", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 10, 0);
        this.assertEquals((TextEdit)i1, 7, 1);
        this.assertEquals((TextEdit)t1, 2, 2);
        this.assertEquals((TextEdit)m1, 2, 2);
        this.assertEquals((TextEdit)d1, 10, 0);
        this.doUndoRedo(undo, "0178234x56");
    }

    @Test
    public void testMoveDownWithSourceDelete() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        DeleteEdit d1 = new DeleteEdit(2, 2);
        d1.addChild((TextEdit)s1);
        RangeMarker m1 = new RangeMarker(2, 2);
        s1.addChild((TextEdit)m1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)d1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0145623789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)d1, 2, 0);
        Assert.assertTrue((boolean)s1.isDeleted());
        this.assertEquals((TextEdit)t1, 5, 2);
        this.assertEquals((TextEdit)m1, 5, 2);
        this.doUndoRedo(undo, "0145623789");
    }

    @Test
    public void testMoveUpWithInnerMark() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(7, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(2, s1);
        ReplaceEdit m = new ReplaceEdit(4, 1, "yy");
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)m);
        this.fRoot.addChild((TextEdit)s1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"017823yy569", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 10, 0);
        this.assertEquals((TextEdit)t1, 2, 2);
        this.assertEquals((TextEdit)m, 6, 2);
        this.doUndoRedo(undo, "017823yy569");
    }

    @Test
    public void testMoveDownWithInnerMark() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(7, s1);
        ReplaceEdit m = new ReplaceEdit(4, 1, "yy");
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)m);
        this.fRoot.addChild((TextEdit)s1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"01yy5623789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)s1, 2, 0);
        this.assertEquals((TextEdit)t1, 6, 2);
        this.assertEquals((TextEdit)m, 2, 2);
        this.doUndoRedo(undo, "01yy5623789");
    }

    @Test
    public void testMoveUpWithParentMark() throws Exception {
        RangeMarker m = new RangeMarker(2, 6);
        MoveSourceEdit s1 = new MoveSourceEdit(4, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(3, s1);
        m.addChild((TextEdit)s1);
        m.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)m);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0124536789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)m, 2, 6);
        this.assertEquals((TextEdit)t1, 3, 2);
        this.assertEquals((TextEdit)s1, 6, 0);
        this.doUndoRedo(undo, "0124536789");
    }

    @Test
    public void testMoveDownWithParentMark() throws Exception {
        RangeMarker m = new RangeMarker(2, 6);
        MoveSourceEdit s1 = new MoveSourceEdit(2, 2);
        MoveTargetEdit t1 = new MoveTargetEdit(5, s1);
        m.addChild((TextEdit)s1);
        m.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)m);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content", (Object)"0142356789", (Object)this.fDocument.get());
        this.assertEquals((TextEdit)m, 2, 6);
        this.assertEquals((TextEdit)t1, 3, 2);
        this.assertEquals((TextEdit)s1, 2, 0);
        this.doUndoRedo(undo, "0142356789");
    }

    @Test
    public void testNestedMoveSource() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(1, 5);
        MoveSourceEdit s2 = new MoveSourceEdit(2, 3);
        MoveSourceEdit s3 = new MoveSourceEdit(3, 1);
        s1.addChild((TextEdit)s2);
        s2.addChild((TextEdit)s3);
        MoveTargetEdit t1 = new MoveTargetEdit(9, s1);
        MoveTargetEdit t2 = new MoveTargetEdit(8, s2);
        MoveTargetEdit t3 = new MoveTargetEdit(7, s3);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)t2);
        this.fRoot.addChild((TextEdit)t3);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 0);
        this.assertEquals((TextEdit)s2, 8, 0);
        this.assertEquals((TextEdit)s3, 5, 0);
        this.assertEquals((TextEdit)t1, 7, 2);
        this.assertEquals((TextEdit)t2, 4, 2);
        this.assertEquals((TextEdit)t3, 2, 1);
        String result = "0637248159";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testNestedMoveSourceWithInsert() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(1, 5);
        MoveSourceEdit s2 = new MoveSourceEdit(2, 3);
        MoveSourceEdit s3 = new MoveSourceEdit(3, 1);
        InsertEdit i1 = new InsertEdit(4, "x");
        s1.addChild((TextEdit)s2);
        s2.addChild((TextEdit)s3);
        s3.addChild((TextEdit)i1);
        MoveTargetEdit t1 = new MoveTargetEdit(9, s1);
        MoveTargetEdit t2 = new MoveTargetEdit(8, s2);
        MoveTargetEdit t3 = new MoveTargetEdit(7, s3);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)t2);
        this.fRoot.addChild((TextEdit)t3);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 0);
        this.assertEquals((TextEdit)s2, 9, 0);
        this.assertEquals((TextEdit)s3, 6, 0);
        this.assertEquals((TextEdit)i1, 3, 1);
        this.assertEquals((TextEdit)t1, 8, 2);
        this.assertEquals((TextEdit)t2, 5, 2);
        this.assertEquals((TextEdit)t3, 2, 2);
        String result = "063x7248159";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testNestedMoveTarget() throws Exception {
        MoveSourceEdit s1 = new MoveSourceEdit(1, 2);
        MoveSourceEdit s2 = new MoveSourceEdit(5, 3);
        MoveTargetEdit t1 = new MoveTargetEdit(6, s1);
        MoveTargetEdit t2 = new MoveTargetEdit(9, s2);
        s2.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)s2);
        this.fRoot.addChild((TextEdit)t2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 0);
        this.assertEquals((TextEdit)s2, 3, 0);
        this.assertEquals((TextEdit)t1, 5, 2);
        this.assertEquals((TextEdit)t2, 4, 5);
        String result = "0348512679";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testCopyDown() throws Exception {
        CopySourceEdit s1 = new CopySourceEdit(2, 3);
        CopyTargetEdit t1 = new CopyTargetEdit(8, s1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 2, 3);
        this.assertEquals((TextEdit)t1, 8, 3);
        String result = "0123456723489";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testCopyUp() throws Exception {
        CopySourceEdit s1 = new CopySourceEdit(7, 2);
        CopyTargetEdit t1 = new CopyTargetEdit(3, s1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 9, 2);
        this.assertEquals((TextEdit)t1, 3, 2);
        String result = "012783456789";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testDoubleCopy() throws Exception {
        CopySourceEdit s1 = new CopySourceEdit(5, 2);
        CopyTargetEdit t1 = new CopyTargetEdit(8, s1);
        CopySourceEdit s2 = new CopySourceEdit(5, 2);
        CopyTargetEdit t2 = new CopyTargetEdit(2, s2);
        s1.addChild((TextEdit)s2);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)t2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 7, 2);
        this.assertEquals((TextEdit)t1, 10, 2);
        this.assertEquals((TextEdit)s2, 7, 2);
        this.assertEquals((TextEdit)t2, 2, 2);
        String result = "01562345675689";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testNestedCopySource() throws Exception {
        CopySourceEdit s1 = new CopySourceEdit(1, 5);
        CopySourceEdit s2 = new CopySourceEdit(2, 3);
        CopySourceEdit s3 = new CopySourceEdit(3, 1);
        s1.addChild((TextEdit)s2);
        s2.addChild((TextEdit)s3);
        CopyTargetEdit t1 = new CopyTargetEdit(9, s1);
        CopyTargetEdit t2 = new CopyTargetEdit(8, s2);
        CopyTargetEdit t3 = new CopyTargetEdit(7, s3);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)t2);
        this.fRoot.addChild((TextEdit)t3);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 5);
        this.assertEquals((TextEdit)s2, 2, 3);
        this.assertEquals((TextEdit)s3, 3, 1);
        this.assertEquals((TextEdit)t1, 13, 5);
        this.assertEquals((TextEdit)t2, 9, 3);
        this.assertEquals((TextEdit)t3, 7, 1);
        String result = "0123456372348123459";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testNestedCopySourceWithInsert() throws Exception {
        CopySourceEdit s1 = new CopySourceEdit(1, 5);
        CopySourceEdit s2 = new CopySourceEdit(2, 3);
        CopySourceEdit s3 = new CopySourceEdit(3, 1);
        InsertEdit i1 = new InsertEdit(4, "x");
        s1.addChild((TextEdit)s2);
        s2.addChild((TextEdit)s3);
        s3.addChild((TextEdit)i1);
        CopyTargetEdit t1 = new CopyTargetEdit(9, s1);
        CopyTargetEdit t2 = new CopyTargetEdit(8, s2);
        CopyTargetEdit t3 = new CopyTargetEdit(7, s3);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)t2);
        this.fRoot.addChild((TextEdit)t3);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 6);
        this.assertEquals((TextEdit)s2, 2, 4);
        this.assertEquals((TextEdit)s3, 3, 2);
        this.assertEquals((TextEdit)i1, 4, 1);
        this.assertEquals((TextEdit)t1, 16, 6);
        this.assertEquals((TextEdit)t2, 11, 4);
        this.assertEquals((TextEdit)t3, 8, 2);
        String result = "0123x4563x723x48123x459";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testNestedCopyTarget() throws Exception {
        CopySourceEdit s1 = new CopySourceEdit(1, 2);
        CopySourceEdit s2 = new CopySourceEdit(5, 3);
        CopyTargetEdit t1 = new CopyTargetEdit(6, s1);
        CopyTargetEdit t2 = new CopyTargetEdit(9, s2);
        s2.addChild((TextEdit)t1);
        this.fRoot.addChild((TextEdit)s1);
        this.fRoot.addChild((TextEdit)s2);
        this.fRoot.addChild((TextEdit)t2);
        UndoEdit undo = this.fRoot.apply(this.fDocument);
        this.assertEquals((TextEdit)s1, 1, 2);
        this.assertEquals((TextEdit)s2, 5, 5);
        this.assertEquals((TextEdit)t1, 6, 2);
        this.assertEquals((TextEdit)t2, 11, 5);
        String result = "01234512678512679";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.doUndoRedo(undo, result);
    }

    @Test
    public void testSwap1() throws Exception {
        Document document = new Document("foo(1, 2), 3");
        MultiTextEdit root = new MultiTextEdit();
        CopySourceEdit innerRoot = new CopySourceEdit(0, 9);
        ReplaceEdit e1 = new ReplaceEdit(0, 9, "");
        e1.addChild((TextEdit)innerRoot);
        CopyTargetEdit t1 = new CopyTargetEdit(11, innerRoot);
        ReplaceEdit e2 = new ReplaceEdit(11, 1, "");
        CopySourceEdit s2 = new CopySourceEdit(11, 1);
        e2.addChild((TextEdit)s2);
        CopyTargetEdit t2 = new CopyTargetEdit(0, s2);
        root.addChild((TextEdit)e1);
        root.addChild((TextEdit)t2);
        root.addChild((TextEdit)e2);
        root.addChild((TextEdit)t1);
        root.apply((IDocument)document);
        String result = "3, foo(1, 2)";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)document.get());
    }

    @Test
    public void testSwap2() throws Exception {
        Document document = new Document("foo(1, 2), 3");
        MultiTextEdit root = new MultiTextEdit();
        ReplaceEdit e1 = new ReplaceEdit(4, 1, "");
        CopySourceEdit s1 = new CopySourceEdit(4, 1);
        e1.addChild((TextEdit)s1);
        CopyTargetEdit t1 = new CopyTargetEdit(7, s1);
        ReplaceEdit e2 = new ReplaceEdit(7, 1, "");
        CopySourceEdit s2 = new CopySourceEdit(7, 1);
        e2.addChild((TextEdit)s2);
        CopyTargetEdit t2 = new CopyTargetEdit(4, s2);
        root.addChild((TextEdit)e1);
        root.addChild((TextEdit)t2);
        root.addChild((TextEdit)e2);
        root.addChild((TextEdit)t1);
        root.apply((IDocument)document);
        String result = "foo(2, 1), 3";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)document.get());
    }

    @Test
    public void testSwap2InSwap1() throws Exception {
        Document document = new Document("foo(1, 2), 3");
        CopySourceEdit innerRoot = new CopySourceEdit(0, 9);
        ReplaceEdit e1 = new ReplaceEdit(4, 1, "");
        CopySourceEdit s1 = new CopySourceEdit(4, 1);
        e1.addChild((TextEdit)s1);
        CopyTargetEdit t1 = new CopyTargetEdit(7, s1);
        ReplaceEdit e2 = new ReplaceEdit(7, 1, "");
        CopySourceEdit s2 = new CopySourceEdit(7, 1);
        e2.addChild((TextEdit)s2);
        CopyTargetEdit t2 = new CopyTargetEdit(4, s2);
        innerRoot.addChild((TextEdit)e1);
        innerRoot.addChild((TextEdit)t2);
        innerRoot.addChild((TextEdit)e2);
        innerRoot.addChild((TextEdit)t1);
        MultiTextEdit root = new MultiTextEdit();
        ReplaceEdit e12 = new ReplaceEdit(0, 9, "");
        e12.addChild((TextEdit)innerRoot);
        t1 = new CopyTargetEdit(11, innerRoot);
        e2 = new ReplaceEdit(11, 1, "");
        s2 = new CopySourceEdit(11, 1);
        e2.addChild((TextEdit)s2);
        t2 = new CopyTargetEdit(0, s2);
        root.addChild((TextEdit)e12);
        root.addChild((TextEdit)t2);
        root.addChild((TextEdit)e2);
        root.addChild((TextEdit)t1);
        root.apply((IDocument)document);
        String result = "3, foo(2, 1)";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)document.get());
    }

    @Test
    public void testMoveTree1() {
        MultiTextEdit root = new MultiTextEdit();
        ReplaceEdit e1 = new ReplaceEdit(0, 1, "");
        root.addChild((TextEdit)e1);
        ReplaceEdit e2 = new ReplaceEdit(2, 2, "");
        root.addChild((TextEdit)e2);
        root.moveTree(3);
        Assert.assertEquals((long)3L, (long)root.getOffset());
        Assert.assertEquals((long)4L, (long)root.getLength());
        Assert.assertEquals((long)3L, (long)e1.getOffset());
        Assert.assertEquals((long)1L, (long)e1.getLength());
        Assert.assertEquals((long)5L, (long)e2.getOffset());
        Assert.assertEquals((long)2L, (long)e2.getLength());
    }

    @Test
    public void testMoveTree2() {
        MultiTextEdit root = new MultiTextEdit();
        ReplaceEdit e1 = new ReplaceEdit(3, 1, "");
        root.addChild((TextEdit)e1);
        ReplaceEdit e2 = new ReplaceEdit(5, 2, "");
        root.addChild((TextEdit)e2);
        root.moveTree(-3);
        Assert.assertEquals((long)0L, (long)root.getOffset());
        Assert.assertEquals((long)4L, (long)root.getLength());
        Assert.assertEquals((long)0L, (long)e1.getOffset());
        Assert.assertEquals((long)1L, (long)e1.getLength());
        Assert.assertEquals((long)2L, (long)e2.getOffset());
        Assert.assertEquals((long)2L, (long)e2.getLength());
    }

    @Test
    public void testMoveTree3() {
        boolean exception = false;
        try {
            ReplaceEdit root = new ReplaceEdit(0, 1, "");
            root.moveTree(-1);
        }
        catch (Exception exception2) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testMoveTree4() {
        boolean exception = false;
        try {
            MultiTextEdit root = new MultiTextEdit();
            ReplaceEdit e1 = new ReplaceEdit(0, 1, "");
            root.addChild((TextEdit)e1);
            e1.moveTree(1);
        }
        catch (Exception exception2) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testComparator() throws Exception {
        DeleteEdit d1 = new DeleteEdit(1, 3);
        Accessor accessor = new Accessor(d1, TextEdit.class);
        Comparator comparator = (Comparator)accessor.get("INSERTION_COMPARATOR");
        InsertEdit edit1 = new InsertEdit(1, "test");
        InsertEdit edit2 = new InsertEdit(1, "test");
        InsertEdit edit3 = new InsertEdit(57, "test3");
        Assert.assertTrue((boolean)edit1.equals((Object)edit1));
        Assert.assertEquals((long)0L, (long)comparator.compare(edit1, edit1));
        Assert.assertEquals((long)0L, (long)comparator.compare(edit1, edit2));
        Assert.assertEquals((long)0L, (long)comparator.compare(edit2, edit1));
        Assert.assertTrue((comparator.compare(edit1, edit3) == -comparator.compare(edit3, edit1) ? 1 : 0) != 0);
    }

    @Test
    public void testSourceTransformationIncludes() throws Exception {
        MoveSourceEdit ms = new MoveSourceEdit(2, 4);
        MoveTargetEdit mt = new MoveTargetEdit(9, ms);
        this.fRoot.addChild((TextEdit)ms);
        this.fRoot.addChild((TextEdit)mt);
        RangeMarker r1 = new RangeMarker(3, 2);
        ms.addChild((TextEdit)r1);
        ms.setSourceModifier(new ISourceModifier(){

            public ISourceModifier copy() {
                return this;
            }

            public ReplaceEdit[] getModifications(String source) {
                return new ReplaceEdit[]{new ReplaceEdit(1, 1, "aa")};
            }
        });
        this.fRoot.apply(this.fDocument);
        String result = "016782aa459";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.assertEquals((TextEdit)r1, 6, 3);
    }

    @Test
    public void testSourceTranformationMultipleCovers() throws Exception {
        MoveSourceEdit ms = new MoveSourceEdit(2, 4);
        MoveTargetEdit mt = new MoveTargetEdit(9, ms);
        this.fRoot.addChild((TextEdit)ms);
        this.fRoot.addChild((TextEdit)mt);
        RangeMarker r1 = new RangeMarker(3, 0);
        ms.addChild((TextEdit)r1);
        RangeMarker r2 = new RangeMarker(3, 0);
        ms.addChild((TextEdit)r2);
        RangeMarker r3 = new RangeMarker(4, 2);
        ms.addChild((TextEdit)r3);
        ms.setSourceModifier(new ISourceModifier(){

            public ISourceModifier copy() {
                return this;
            }

            public ReplaceEdit[] getModifications(String source) {
                return new ReplaceEdit[]{new ReplaceEdit(0, 2, "aa")};
            }
        });
        this.fRoot.apply(this.fDocument);
        String result = "01678aa459";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        Assert.assertTrue((boolean)r1.isDeleted());
        Assert.assertTrue((boolean)r2.isDeleted());
        this.assertEquals((TextEdit)r3, 7, 2);
    }

    @Test
    public void testSourceTranformationSplit1() throws Exception {
        MoveSourceEdit ms = new MoveSourceEdit(2, 4);
        MoveTargetEdit mt = new MoveTargetEdit(9, ms);
        this.fRoot.addChild((TextEdit)ms);
        this.fRoot.addChild((TextEdit)mt);
        RangeMarker r1 = new RangeMarker(3, 2);
        ms.addChild((TextEdit)r1);
        ms.setSourceModifier(new ISourceModifier(){

            public ISourceModifier copy() {
                return this;
            }

            public ReplaceEdit[] getModifications(String source) {
                return new ReplaceEdit[]{new ReplaceEdit(0, 2, "aa")};
            }
        });
        this.fRoot.apply(this.fDocument);
        String result = "01678aa459";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.assertEquals((TextEdit)r1, 7, 1);
    }

    @Test
    public void testSourceTranformationSplit2() throws Exception {
        MoveSourceEdit ms = new MoveSourceEdit(2, 4);
        MoveTargetEdit mt = new MoveTargetEdit(9, ms);
        this.fRoot.addChild((TextEdit)ms);
        this.fRoot.addChild((TextEdit)mt);
        RangeMarker r1 = new RangeMarker(3, 2);
        ms.addChild((TextEdit)r1);
        ms.setSourceModifier(new ISourceModifier(){

            public ISourceModifier copy() {
                return this;
            }

            public ReplaceEdit[] getModifications(String source) {
                return new ReplaceEdit[]{new ReplaceEdit(2, 2, "aa")};
            }
        });
        this.fRoot.apply(this.fDocument);
        String result = "0167823aa9";
        Assert.assertEquals((String)"Buffer content", (Object)result, (Object)this.fDocument.get());
        this.assertEquals((TextEdit)r1, 6, 3);
    }

    @Test
    public void testIntersect() throws Exception {
        IRegion result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(0, 1), (TextEdit)new RangeMarker(2, 1));
        Assert.assertNull((Object)result);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(2, 1), (TextEdit)new RangeMarker(0, 1));
        Assert.assertNull((Object)result);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(0, 1), (TextEdit)new RangeMarker(1, 1));
        Assert.assertNull((Object)result);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(1, 1), (TextEdit)new RangeMarker(0, 1));
        Assert.assertNull((Object)result);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(0, 2), (TextEdit)new RangeMarker(1, 2));
        Assert.assertNotNull((Object)result);
        this.assertEquals(result, 1, 1);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(1, 2), (TextEdit)new RangeMarker(0, 2));
        Assert.assertNotNull((Object)result);
        this.assertEquals(result, 1, 1);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(1, 2), (TextEdit)new RangeMarker(2, 2));
        Assert.assertNotNull((Object)result);
        this.assertEquals(result, 2, 1);
        result = MoveSourceEdit.intersect((TextEdit)new RangeMarker(2, 2), (TextEdit)new RangeMarker(1, 2));
        Assert.assertNotNull((Object)result);
        this.assertEquals(result, 2, 1);
    }

    private void doUndoRedo(UndoEdit undo, String redoResult) throws Exception {
        UndoEdit redo = undo.apply(this.fDocument);
        this.assertBufferContent();
        undo = redo.apply(this.fDocument);
        Assert.assertEquals((String)"Buffer content redo", (Object)redoResult, (Object)this.fDocument.get());
        undo.apply(this.fDocument);
        this.assertBufferContent();
    }

    private void assertEquals(TextEdit edit, int offset, int length) {
        Assert.assertEquals((String)"Offset", (long)offset, (long)edit.getOffset());
        Assert.assertEquals((String)"Length", (long)length, (long)edit.getLength());
    }

    private void assertEquals(IRegion region, int offset, int length) {
        Assert.assertEquals((String)"Offset", (long)offset, (long)region.getOffset());
        Assert.assertEquals((String)"Length", (long)length, (long)region.getLength());
    }

    private void assertBufferContent() {
        Assert.assertEquals((String)"Buffer content restored", (Object)"0123456789", (Object)this.fDocument.get());
    }
}

