/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TextStoreTest {
    private ITextStore fTextStore;
    private ILineTracker fTracker;

    @Before
    public void setUp() {
        this.fTextStore = this.createTextStore();
        this.fTracker = this.createTracker();
        this.set("x\nx\nx\nx\nx\n");
    }

    protected ILineTracker createTracker() {
        return new ConfigurableLineTracker(new String[]{"\n"});
    }

    protected final void replace(int offset, int length, String text) throws BadLocationException {
        this.fTextStore.replace(offset, length, text);
        this.fTracker.replace(offset, length, text);
    }

    protected final void set(String text) {
        this.fTextStore.set(text);
        this.fTracker.set(text);
    }

    protected abstract ITextStore createTextStore();

    @After
    public void tearDown() {
        this.fTextStore = null;
        this.fTracker = null;
    }

    @Test
    public void testGet1() throws Exception {
        this.set("xxxxx");
        String[] expected = new String[]{"xyxxxx", "xyxyxxx", "xyxyxyxx", "xyxyxyxyx", "xyxyxyxyxy"};
        int i = 1;
        while (i < 5) {
            this.replace(2 * i - 1, 0, "y");
            String txt = this.fTextStore.get(0, this.fTextStore.getLength());
            Assert.assertEquals((Object)expected[i - 1], (Object)txt);
            ++i;
        }
    }

    @Test
    public void testGet2() throws Exception {
        this.set("xxxxx");
        String[] expected = new String[]{"yxxxxx", "yxyxxxx", "yxyxyxxx", "yxyxyxyxx", "yxyxyxyxyx"};
        int i = 1;
        while (i < 5) {
            this.replace(2 * (i - 1), 0, "y");
            String txt = this.fTextStore.get(0, this.fTextStore.getLength());
            Assert.assertEquals((Object)expected[i - 1], (Object)txt);
            ++i;
        }
    }

    @Test
    public void testEditScript1() throws Exception {
        this.replace(0, this.fTextStore.getLength(), "x");
        this.assertTextStoreContents("x");
        this.replace(1, 0, "y");
        this.assertTextStoreContents("xy");
        this.replace(2, 0, "z");
        this.assertTextStoreContents("xyz");
        this.replace(3, 0, "\n");
        this.assertTextStoreContents("xyz\n");
        this.replace(4, 0, "x");
        this.assertTextStoreContents("xyz\nx");
    }

    private void assertTextStoreContents(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.fTextStore.get(0, this.fTextStore.getLength()));
        int i = 0;
        while (i < this.fTextStore.getLength()) {
            Assert.assertEquals((long)expected.charAt(i), (long)this.fTextStore.get(i));
            ++i;
        }
        try {
            this.fTextStore.get(this.fTextStore.getLength());
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    @Test
    public void testEmptyLines() throws Exception {
        this.replace(0, 10, null);
        this.assertTextStoreContents("");
        this.replace(0, 0, "\n\n\n\n\n");
        this.assertTextStoreContents("\n\n\n\n\n");
    }

    @Test
    public void testInsert1() throws Exception {
        this.replace(3, 0, "yyyy");
        this.assertTextStoreContents("x\nxyyyy\nx\nx\nx\n");
        this.replace(9, 0, "y\n");
        this.assertTextStoreContents("x\nxyyyy\nxy\n\nx\nx\n");
        this.replace(11, 0, "y\n");
        this.assertTextStoreContents("x\nxyyyy\nxy\ny\n\nx\nx\n");
        this.replace(13, 0, "y");
        this.assertTextStoreContents("x\nxyyyy\nxy\ny\ny\nx\nx\n");
        this.replace(11, 5, "y\nxyz");
        this.assertTextStoreContents("x\nxyyyy\nxy\ny\nxyz\nx\n");
    }

    @Test
    public void testInsert2() throws Exception {
        this.replace(3, 0, "yyyy");
        this.assertTextStoreContents("x\nxyyyy\nx\nx\nx\n");
        this.replace(9, 0, "y\ny\ny");
        this.assertTextStoreContents("x\nxyyyy\nxy\ny\ny\nx\nx\n");
    }

    @Test
    public void testLinesNumbers() throws Exception {
        this.replace(0, 10, "\na\nbb\nccc\ndddd\neeeee\n");
        this.assertTextStoreContents("\na\nbb\nccc\ndddd\neeeee\n");
        int offset = 0;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < i) {
                int no = this.fTracker.getLineNumberOfOffset(offset + j);
                Assert.assertTrue((String)("invalid line number " + no + " reported instead of " + i), (no == i ? 1 : 0) != 0);
                ++j;
            }
            offset += i + 1;
            ++i;
        }
    }

    @Test
    public void testOffsets() throws Exception {
        int i = 0;
        while (i < 5) {
            IRegion line = this.fTracker.getLineInformation(i);
            int pos = line.getOffset() + line.getLength();
            int offset = 2 * i + 1;
            Assert.assertTrue((String)("invalid line end offset " + pos + " for line " + i + " should be " + offset), (offset == pos ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            int offset = 2 * i;
            Assert.assertTrue((String)("invalid line start offset " + pos + " for line " + i + " should be " + offset), (pos == offset ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 10) {
            int line = this.fTracker.getLineNumberOfOffset(i);
            double l = Math.floor(i / 2);
            Assert.assertTrue((String)("invalid line number " + line + " for position " + i + " should be " + l), (l == (double)line ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testRemove() throws Exception {
        this.replace(3, 1, null);
        this.assertTextStoreContents("x\nxx\nx\nx\n");
        this.replace(6, 1, null);
        this.assertTextStoreContents("x\nxx\nxx\n");
        this.replace(3, 5, null);
        this.assertTextStoreContents("x\nx");
        this.replace(0, 3, null);
        this.assertTextStoreContents("");
    }

    @Test
    public void testReplace() throws Exception {
        this.replace(0, this.fTextStore.getLength(), "\tx\n\tx\n\tx\n\tx\n\tx\n");
        this.assertTextStoreContents("\tx\n\tx\n\tx\n\tx\n\tx\n");
    }

    @Test
    public void testReplace2() throws Exception {
        this.replace(0, this.fTextStore.getLength(), "x");
        this.assertTextStoreContents("x");
        this.replace(0, this.fTextStore.getLength(), "x\nx\nx\n");
        this.assertTextStoreContents("x\nx\nx\n");
    }

    @Test
    public void testReplace3() throws Exception {
        this.replace(1, 1, "\n");
        this.assertTextStoreContents("x\nx\nx\nx\nx\n");
    }

    @Test
    public void testReplace4() throws Exception {
        int lines = this.fTracker.getNumberOfLines();
        IRegion previous = this.fTracker.getLineInformation(0);
        int i = 1;
        while (i < lines) {
            int lastLineEnd = previous.getOffset() + previous.getLength();
            int lineStart = this.fTracker.getLineInformation(i).getOffset();
            this.replace(lastLineEnd, lineStart - lastLineEnd, "\n");
            this.assertTextStoreContents("x\nx\nx\nx\nx\n");
            previous = this.fTracker.getLineInformation(i);
            ++i;
        }
    }

    @Test
    public void testShiftLeft() throws Exception {
        this.replace(0, this.fTextStore.getLength(), "\tx\n\tx\n\tx\n\tx\n\tx\n");
        this.assertTextStoreContents("\tx\n\tx\n\tx\n\tx\n\tx\n");
        int i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            this.replace(pos, 1, null);
            ++i;
        }
        this.assertTextStoreContents("x\nx\nx\nx\nx\n");
    }

    @Test
    public void testShiftRight() throws Exception {
        int i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            this.replace(pos, 0, "\t");
            ++i;
        }
        this.assertTextStoreContents("\tx\n\tx\n\tx\n\tx\n\tx\n");
    }

    @Test
    public void testDeleteEmptyLine() throws Exception {
        this.set("x\nx\n\nx\n\n");
        this.assertTextStoreContents("x\nx\n\nx\n\n");
        String[] expected = new String[]{"", "x\n", "x\nx\n", "x\nx\n\n", "x\nx\n\nx\n", "x\nx\n\nx\n\n"};
        int line = this.fTracker.getNumberOfLines() - 1;
        while (line >= 0) {
            int offset = this.fTracker.getLineOffset(line);
            int length = this.fTracker.getLineLength(line);
            this.replace(offset, length, null);
            this.assertTextStoreContents(expected[line]);
            --line;
        }
    }

    @Test
    public void testDeleteLines() throws Exception {
        int length;
        int offset;
        int line;
        int lines;
        String expected;
        StringBuilder content = new StringBuilder();
        int i = 0;
        while (i < 50) {
            content.append("x\nx\n\nx\n\n");
            this.set(content.toString());
            expected = content.toString();
            lines = this.fTracker.getNumberOfLines();
            line = 0;
            while (line < lines) {
                offset = this.fTracker.getLineOffset(0);
                length = this.fTracker.getLineLength(0);
                this.replace(offset, length, null);
                expected = expected.substring(length);
                this.assertTextStoreContents(expected);
                ++line;
            }
            ++i;
        }
        content = new StringBuilder();
        i = 0;
        while (i < 50) {
            content.append("x\nx\n\nx\n\n");
            this.set(content.toString());
            expected = content.toString();
            lines = this.fTracker.getNumberOfLines();
            line = lines - 1;
            while (line >= 0) {
                offset = this.fTracker.getLineOffset(line);
                length = this.fTracker.getLineLength(line);
                this.replace(offset, length, null);
                expected = expected.substring(0, expected.length() - length);
                this.assertTextStoreContents(expected);
                --line;
            }
            ++i;
        }
    }

    @Test
    public void testDeleteLines2() throws Exception {
        int length;
        int offset;
        int line;
        int lines;
        String expected;
        StringBuilder content = new StringBuilder();
        int i = 0;
        while (i < 50) {
            content.append("xxxxxxxxxxxxxx");
            this.set(content.toString());
            expected = content.toString();
            lines = this.fTracker.getNumberOfLines();
            line = 0;
            while (line < lines) {
                offset = this.fTracker.getLineOffset(0);
                length = this.fTracker.getLineLength(0);
                this.replace(offset, length, null);
                expected = expected.substring(length);
                this.assertTextStoreContents(expected);
                ++line;
            }
            ++i;
        }
        content = new StringBuilder();
        i = 0;
        while (i < 50) {
            content.append("xxxxxxxxxxxxxx");
            this.set(content.toString());
            expected = content.toString();
            lines = this.fTracker.getNumberOfLines();
            line = lines - 1;
            while (line >= 0) {
                offset = this.fTracker.getLineOffset(line);
                length = this.fTracker.getLineLength(line);
                this.replace(offset, length, null);
                expected = expected.substring(0, expected.length() - length);
                this.assertTextStoreContents(expected);
                --line;
            }
            ++i;
        }
    }

    @Test
    public void testSet() throws Exception {
        StringBuilder content = new StringBuilder();
        int i = 0;
        while (i < 35) {
            int[] lenghts = new int[i + 1];
            int j = 0;
            while (j < i + 1) {
                lenghts[j] = j;
                ++j;
            }
            j = 0;
            while (j < i) {
                content.append("x");
                ++j;
            }
            this.set(content.toString());
            this.assertTextStoreContents(content.toString());
            content.append('\n');
            ++i;
        }
    }

    @Test
    public void testFunnyLastLineCompatibility() throws Exception {
        IRegion line;
        this.set("x\n");
        this.assertTextStoreContents("x\n");
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] offsets = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        int[] lengths = nArray2;
        Assert.assertEquals((String)"invalid number of lines, ", (long)lengths.length, (long)this.fTracker.getNumberOfLines());
        Assert.assertEquals((String)"invalid number of lines, ", (long)lengths.length, (long)this.fTracker.getNumberOfLines(0, this.fTextStore.getLength()));
        int i = 0;
        while (i < lengths.length) {
            line = this.fTracker.getLineInformation(i);
            Assert.assertEquals((String)("line: " + i), (long)lengths[i], (long)line.getLength());
            Assert.assertEquals((String)("line: " + i), (long)offsets[i], (long)line.getOffset());
            ++i;
        }
        try {
            this.fTracker.getLineInformation(lengths.length);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.fTracker.getLineInformationOfOffset(offsets[offsets.length] + 1);
            Assert.fail();
        }
        catch (Exception exception) {}
        this.set("x\nx");
        this.assertTextStoreContents("x\nx");
        int[] nArray3 = new int[3];
        nArray3[1] = 2;
        nArray3[2] = 3;
        offsets = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArray4[1] = 1;
        lengths = nArray4;
        Assert.assertEquals((String)"invalid number of lines, ", (long)(lengths.length - 1), (long)this.fTracker.getNumberOfLines());
        Assert.assertEquals((String)"invalid number of lines, ", (long)(lengths.length - 1), (long)this.fTracker.getNumberOfLines(0, this.fTextStore.getLength()));
        i = 0;
        while (i < lengths.length) {
            line = this.fTracker.getLineInformation(i);
            int len = lengths[i];
            int offset = offsets[i];
            Assert.assertEquals((String)("length of line: " + i), (long)len, (long)line.getLength());
            Assert.assertEquals((String)("offset of line: " + i), (long)offset, (long)line.getOffset());
            line = this.fTracker.getLineInformationOfOffset(offset);
            if (i == lengths.length - 1) {
                len = lengths[i - 1];
                offset = offsets[i - 1];
            }
            Assert.assertEquals((String)("length of line: " + i), (long)len, (long)line.getLength());
            Assert.assertEquals((String)("offset of line: " + i), (long)offset, (long)line.getOffset());
            ++i;
        }
        try {
            this.fTracker.getLineInformation(lengths.length);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.fTracker.getLineInformationOfOffset(offsets[offsets.length] + 1);
            Assert.fail();
        }
        catch (Exception exception) {}
    }
}

