/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.templates;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalTemplateVariablesDateTest {
    private TemplateTranslator fTranslator;
    private DocumentTemplateContext fContext;
    private TemplateContextType fType;

    @Before
    public void setUp() {
        this.fTranslator = new TemplateTranslator();
        this.fType = new TemplateContextType();
        this.fType.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.fContext = new DocumentTemplateContext(this.fType, (IDocument)new Document(), 0, 0);
    }

    @Test
    public void testWithoutParameter() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("Today is ${date}!");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("Today is ");
        expected.append(DateFormat.getDateInstance().format(new Date()));
        expected.append("!");
        GlobalTemplateVariablesDateTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    @Test
    public void testOneParameter() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("This format ${d:date('dd MMM YYYY')} and not ${p:date('YYYY-MM-dd')}");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("This format ");
        expected.append(new SimpleDateFormat("dd MMM YYYY").format(new Date()));
        expected.append(" and not ");
        expected.append(new SimpleDateFormat("YYYY-MM-dd").format(new Date()));
        GlobalTemplateVariablesDateTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    @Test
    public void testSimpleLocale() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("From ${d:date('dd MMM YYYY', 'fr')} to ${d}");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("From ");
        expected.append(new SimpleDateFormat("dd MMM YYYY", ULocale.FRENCH).format(new Date()));
        expected.append(" to ");
        expected.append(new SimpleDateFormat("dd MMM YYYY", ULocale.FRENCH).format(new Date()));
        GlobalTemplateVariablesDateTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    @Test
    public void testComplexLocale() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("France ${d:date('EEEE dd MMMM YYYY', 'fr_FR')} and Germany ${p:date('EEEE dd. MMMM YYYY', 'de_DE')}");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("France ");
        expected.append(new SimpleDateFormat("EEEE dd MMMM YYYY", ULocale.FRANCE).format(new Date()));
        expected.append(" and Germany ");
        expected.append(new SimpleDateFormat("EEEE dd. MMMM YYYY", ULocale.GERMANY).format(new Date()));
        GlobalTemplateVariablesDateTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    @Test
    public void testInvalidDateFormat() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("Today is ${d:date('invalid')}!");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("Today is ");
        expected.append(DateFormat.getDateInstance().format(new Date()));
        expected.append("!");
        GlobalTemplateVariablesDateTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    @Test
    public void testInvalidLocale() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("Today is ${d:date('YYYY-MM-dd', 'this_invalid_locale')}!");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("Today is ");
        expected.append(new SimpleDateFormat("YYYY-MM-dd", new ULocale("this_invalid_locale")).format(new Date()));
        expected.append("!");
        GlobalTemplateVariablesDateTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    private static void assertBufferStringAndVariables(String expected, TemplateBuffer buffer) {
        Assert.assertEquals((Object)expected, (Object)buffer.getString());
        TemplateVariable[] templateVariableArray = buffer.getVariables();
        int n = templateVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable v = templateVariableArray[n2];
            Assert.assertTrue((boolean)v.isResolved());
            Assert.assertTrue((boolean)v.isUnambiguous());
            ++n2;
        }
    }
}

