/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmeContentOutlineDragListener;
import org.eclipse.ui.examples.readmetool.ReadmeModelFactory;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ReadmeContentOutlinePage
extends ContentOutlinePage {
    protected IFile input;

    public ReadmeContentOutlinePage(IFile input) {
        this.input = input;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.examples.readmetool.content_outline_page_context");
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setInput((Object)this.getContentOutline((IAdaptable)this.input));
        this.initDragAndDrop();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.add((IContributionItem)new Separator("additions-end"));
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.ui.examples.readmetool.outline", menuMgr, (ISelectionProvider)viewer);
        this.getSite().getActionBars().setGlobalActionHandler("org.eclipse.ui.examples.readmetool.retarget2", (IAction)new OutlineAction(MessageUtil.getString("Outline_Action2")));
        OutlineAction action = new OutlineAction(MessageUtil.getString("Outline_Action3"));
        action.setToolTipText(MessageUtil.getString("Readme_Outline_Action3"));
        this.getSite().getActionBars().setGlobalActionHandler("org.eclipse.ui.examples.readmetool.labelretarget3", (IAction)action);
        action = new OutlineAction(MessageUtil.getString("Outline_Action4"));
        this.getSite().getActionBars().setGlobalActionHandler("org_eclipse_ui_examples_readmetool_readmeRetargetAction", (IAction)action);
        action = new OutlineAction(MessageUtil.getString("Outline_Action5"));
        action.setToolTipText(MessageUtil.getString("Readme_Outline_Action5"));
        this.getSite().getActionBars().setGlobalActionHandler("org_eclipse_ui_examples_readmetool_readmeRelabelRetargetAction", (IAction)action);
    }

    private IAdaptable getContentOutline(IAdaptable input) {
        return ReadmeModelFactory.getInstance().getContentOutline(input);
    }

    private void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), PluginTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new ReadmeContentOutlineDragListener(this));
    }

    public void update() {
        this.getControl().setRedraw(false);
        this.getTreeViewer().setInput((Object)this.getContentOutline((IAdaptable)this.input));
        this.getTreeViewer().expandAll();
        this.getControl().setRedraw(true);
    }

    class OutlineAction
    extends Action {
        private Shell shell;

        public OutlineAction(String label) {
            super(label);
            ReadmeContentOutlinePage.this.getTreeViewer().addSelectionChangedListener(event -> this.setEnabled(!event.getSelection().isEmpty()));
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }

        public void run() {
            MessageDialog.openInformation((Shell)this.shell, (String)MessageUtil.getString("Readme_Outline"), (String)MessageUtil.getString("ReadmeOutlineActionExecuted"));
        }
    }
}

