/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.examples.readmetool.AddReadmeMarkerAction;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmeContentOutlinePage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ReadmeEditor
extends TextEditor {
    protected ReadmeContentOutlinePage page;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        StyledText tw = this.getSourceViewer().getTextWidget();
        int ops = 17;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        DropTargetListener editorListener = new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String text = (String)event.data;
                    ReadmeEditor.this.getSourceViewer().getTextWidget().insert(text);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        };
        IDragAndDropService dtSvc = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        dtSvc.addMergedDropTarget((Control)tw, ops, transfers, editorListener);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.page != null) {
            this.page.update();
        }
    }

    public <T> T getAdapter(Class<T> key) {
        IEditorInput input;
        if (key.equals(IContentOutlinePage.class) && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            this.page = new ReadmeContentOutlinePage(((IFileEditorInput)input).getFile());
            return (T)((Object)this.page);
        }
        return (T)super.getAdapter(key);
    }

    protected void editorContextMenuAboutToShow(IMenuManager parentMenu) {
        super.editorContextMenuAboutToShow(parentMenu);
        parentMenu.add((IContributionItem)new Separator());
        MenuManager subMenu = new MenuManager(MessageUtil.getString("Add"));
        parentMenu.add((IContributionItem)subMenu);
        if (subMenu != null) {
            Object[][] att = new Object[][]{{"org.eclipse.ui.examples.readmetool.id", 1234}};
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "1", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " id=1234"));
            att = new Object[][]{{"org.eclipse.ui.examples.readmetool.level", 7}};
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "2", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " level=7"));
            att = new Object[][]{{"org.eclipse.ui.examples.readmetool.level", 7}, {"org.eclipse.ui.examples.readmetool.department", "infra"}};
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "3", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " level=7, department=infra"));
            att = new Object[][]{{"org.eclipse.ui.examples.readmetool.code", "red"}};
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "4", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " code=red"));
            att = new Object[][]{{"org.eclipse.ui.examples.readmetool.language", "english"}};
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "5", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " language=english"));
            att = new Object[][]{{"org.eclipse.ui.examples.readmetool.id", 1234}, {"org.eclipse.ui.examples.readmetool.level", 7}, {"org.eclipse.ui.examples.readmetool.department", "infra"}, {"org.eclipse.ui.examples.readmetool.code", "red"}, {"org.eclipse.ui.examples.readmetool.language", "english"}};
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "6", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " id=1234, level=7, department=infra, code=red, language=english"));
            att = new Object[0][0];
            subMenu.add((IAction)new AddReadmeMarkerAction((ITextEditor)this, String.valueOf(MessageUtil.getString("Add_readme_marker_action_label")) + "7", att, String.valueOf(MessageUtil.getString("Readme_marker_message_example")) + " No attributes specified"));
        }
    }
}

