/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.examples.readmetool.DirtyStateContribution;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmeImages;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;

public class ReadmeEditorActionBarContributor
extends BasicTextEditorActionContributor {
    private EditorAction action1 = new EditorAction(MessageUtil.getString("Editor_Action1"));
    private RetargetAction action2;
    private LabelRetargetAction action3;
    private EditorAction handler2;
    private EditorAction handler3;
    private EditorAction handler4;
    private EditorAction handler5;
    private DirtyStateContribution dirtyStateContribution;

    public ReadmeEditorActionBarContributor() {
        this.action1.setToolTipText(MessageUtil.getString("Readme_Editor_Action1"));
        this.action1.setDisabledImageDescriptor(ReadmeImages.EDITOR_ACTION1_IMAGE_DISABLE);
        this.action1.setImageDescriptor(ReadmeImages.EDITOR_ACTION1_IMAGE_ENABLE);
        this.action1.setHoverImageDescriptor(ReadmeImages.EDITOR_ACTION1_IMAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.action1, "org.eclipse.ui.examples.readmetool.editor_action1_context");
        this.action2 = new RetargetAction("org.eclipse.ui.examples.readmetool.retarget2", MessageUtil.getString("Editor_Action2"));
        this.action2.setToolTipText(MessageUtil.getString("Readme_Editor_Action2"));
        this.action2.setDisabledImageDescriptor(ReadmeImages.EDITOR_ACTION2_IMAGE_DISABLE);
        this.action2.setImageDescriptor(ReadmeImages.EDITOR_ACTION2_IMAGE_ENABLE);
        this.action2.setHoverImageDescriptor(ReadmeImages.EDITOR_ACTION2_IMAGE);
        this.action3 = new LabelRetargetAction("org.eclipse.ui.examples.readmetool.labelretarget3", MessageUtil.getString("Editor_Action3"));
        this.action3.setDisabledImageDescriptor(ReadmeImages.EDITOR_ACTION3_IMAGE_DISABLE);
        this.action3.setImageDescriptor(ReadmeImages.EDITOR_ACTION3_IMAGE_ENABLE);
        this.action3.setHoverImageDescriptor(ReadmeImages.EDITOR_ACTION3_IMAGE);
        this.handler2 = new EditorAction(MessageUtil.getString("Editor_Action2"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.action2, "org.eclipse.ui.examples.readmetool.editor_action2_context");
        this.handler3 = new EditorAction(MessageUtil.getString("Editor_Action3"));
        this.handler3.setToolTipText(MessageUtil.getString("Readme_Editor_Action3"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.action3, "org.eclipse.ui.examples.readmetool.editor_action3_context");
        this.handler4 = new EditorAction(MessageUtil.getString("Editor_Action4"));
        this.handler5 = new EditorAction(MessageUtil.getString("Editor_Action5"));
        this.handler5.setToolTipText(MessageUtil.getString("Readme_Editor_Action5"));
        this.dirtyStateContribution = new DirtyStateContribution();
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager readmeMenu = new MenuManager(MessageUtil.getString("Readme_Menu"));
        menuManager.insertAfter("additions", (IContributionItem)readmeMenu);
        readmeMenu.add((IAction)this.action1);
        readmeMenu.add((IAction)this.action2);
        readmeMenu.add((IAction)this.action3);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        statusLineManager.setMessage(MessageUtil.getString("Editor_is_active"));
        statusLineManager.add((IContributionItem)this.dirtyStateContribution);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("ReadmeEditor"));
        toolBarManager.add((IAction)this.action1);
        toolBarManager.add((IAction)this.action2);
        toolBarManager.add((IAction)this.action3);
    }

    public void dispose() {
        this.getPage().removePartListener((IPartListener)this.action2);
        this.getPage().removePartListener((IPartListener)this.action3);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.examples.readmetool.retarget2", (IAction)this.handler2);
        bars.setGlobalActionHandler("org.eclipse.ui.examples.readmetool.labelretarget3", (IAction)this.handler3);
        bars.setGlobalActionHandler("org_eclipse_ui_examples_readmetool_readmeRetargetAction", (IAction)this.handler4);
        bars.setGlobalActionHandler("org_eclipse_ui_examples_readmetool_readmeRelabelRetargetAction", (IAction)this.handler5);
        page.addPartListener((IPartListener)this.action2);
        page.addPartListener((IPartListener)this.action3);
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart != null) {
            this.action2.partActivated(activePart);
            this.action3.partActivated(activePart);
        }
    }

    public void setActiveEditor(IEditorPart editor) {
        super.setActiveEditor(editor);
        this.action1.setActiveEditor(editor);
        this.handler2.setActiveEditor(editor);
        this.handler3.setActiveEditor(editor);
        this.handler4.setActiveEditor(editor);
        this.handler5.setActiveEditor(editor);
        this.dirtyStateContribution.editorChanged(editor);
    }

    class EditorAction
    extends Action {
        private Shell shell;
        private IEditorPart activeEditor;

        public EditorAction(String label) {
            super(label);
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }

        public void run() {
            String editorName = MessageUtil.getString("Empty_Editor_Name");
            if (this.activeEditor != null) {
                editorName = this.activeEditor.getTitle();
            }
            MessageDialog.openInformation((Shell)this.shell, (String)MessageUtil.getString("Readme_Editor"), (String)MessageUtil.format("ReadmeEditorActionExecuted", new Object[]{this.getText(), editorName}));
        }

        public void setActiveEditor(IEditorPart part) {
            this.activeEditor = part;
        }
    }
}

