/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.examples.readmetool.ReadmePlugin;

public class ReadmePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    private Button radioButton1;
    private Button radioButton2;
    private Button radioButton3;
    private Button checkBox1;
    private Button checkBox2;
    private Button checkBox3;
    private Text textField;

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.examples.readmetool.preference_page_context");
        Composite composite_textField = this.createComposite(parent, 2);
        this.createLabel(composite_textField, MessageUtil.getString("Text_Field"));
        this.textField = this.createTextField(composite_textField);
        this.createPushButton(composite_textField, MessageUtil.getString("Change"));
        Composite composite_tab = this.createComposite(parent, 2);
        this.createLabel(composite_tab, MessageUtil.getString("Radio_Button_Options"));
        this.tabForward(composite_tab);
        Composite composite_radioButton = this.createComposite(composite_tab, 1);
        this.radioButton1 = this.createRadioButton(composite_radioButton, MessageUtil.getString("Radio_button_1"));
        this.radioButton2 = this.createRadioButton(composite_radioButton, MessageUtil.getString("Radio_button_2"));
        this.radioButton3 = this.createRadioButton(composite_radioButton, MessageUtil.getString("Radio_button_3"));
        Composite composite_tab2 = this.createComposite(parent, 2);
        this.createLabel(composite_tab2, MessageUtil.getString("Check_Box_Options"));
        this.tabForward(composite_tab2);
        Composite composite_checkBox = this.createComposite(composite_tab2, 1);
        this.checkBox1 = this.createCheckBox(composite_checkBox, MessageUtil.getString("Check_box_1"));
        this.checkBox2 = this.createCheckBox(composite_checkBox, MessageUtil.getString("Check_box_2"));
        this.checkBox3 = this.createCheckBox(composite_checkBox, MessageUtil.getString("Check_box_3"));
        this.initializeValues();
        return new Composite(parent, 0);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        button.addSelectionListener((SelectionListener)this);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        text.addModifyListener((ModifyListener)this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ReadmePlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.checkBox1.setSelection(store.getDefaultBoolean("org.eclipse.ui.examples.readmetool.check1"));
        this.checkBox2.setSelection(store.getDefaultBoolean("org.eclipse.ui.examples.readmetool.check2"));
        this.checkBox3.setSelection(store.getDefaultBoolean("org.eclipse.ui.examples.readmetool.check3"));
        this.radioButton1.setSelection(false);
        this.radioButton2.setSelection(false);
        this.radioButton3.setSelection(false);
        int choice = store.getDefaultInt("org.eclipse.ui.examples.readmetool.radio_choice");
        switch (choice) {
            case 1: {
                this.radioButton1.setSelection(true);
                break;
            }
            case 2: {
                this.radioButton2.setSelection(true);
                break;
            }
            case 3: {
                this.radioButton3.setSelection(true);
            }
        }
        this.textField.setText(store.getDefaultString("org.eclipse.ui.examples.readmetool.text"));
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.checkBox1.setSelection(store.getBoolean("org.eclipse.ui.examples.readmetool.check1"));
        this.checkBox2.setSelection(store.getBoolean("org.eclipse.ui.examples.readmetool.check2"));
        this.checkBox3.setSelection(store.getBoolean("org.eclipse.ui.examples.readmetool.check3"));
        int choice = store.getInt("org.eclipse.ui.examples.readmetool.radio_choice");
        switch (choice) {
            case 1: {
                this.radioButton1.setSelection(true);
                break;
            }
            case 2: {
                this.radioButton2.setSelection(true);
                break;
            }
            case 3: {
                this.radioButton3.setSelection(true);
            }
        }
        this.textField.setText(store.getString("org.eclipse.ui.examples.readmetool.text"));
    }

    public void modifyText(ModifyEvent event) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        ReadmePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.ui.examples.readmetool.check1", this.checkBox1.getSelection());
        store.setValue("org.eclipse.ui.examples.readmetool.check2", this.checkBox2.getSelection());
        store.setValue("org.eclipse.ui.examples.readmetool.check3", this.checkBox3.getSelection());
        int choice = 1;
        if (this.radioButton2.getSelection()) {
            choice = 2;
        } else if (this.radioButton3.getSelection()) {
            choice = 3;
        }
        store.setValue("org.eclipse.ui.examples.readmetool.radio_choice", choice);
        store.setValue("org.eclipse.ui.examples.readmetool.text", this.textField.getText());
    }

    private void tabForward(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }
}

