/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.undo.views;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.examples.undo.UndoExampleMessages;
import org.eclipse.ui.examples.undo.UndoPlugin;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ViewPart;

public class UndoHistoryView
extends ViewPart
implements ISelectionChangedListener {
    private TableViewer viewer;
    private Action filterAction;
    private Action doubleClickAction;
    private Action selectiveUndoAction;
    private Action refreshListAction;
    private IOperationHistory history = OperationHistoryFactory.getOperationHistory();
    private IUndoContext fContext = IOperationHistory.GLOBAL_UNDO_CONTEXT;
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private boolean showDebug = UndoPlugin.getDefault().getPreferenceStore().getBoolean("prefShowDebug");
    private IPropertyChangeListener propertyChangeListener;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.addListeners();
        this.createGlobalActionHandlers();
    }

    private void addListeners() {
        this.propertyChangeListener = event -> {
            if (event.getProperty() == "prefShowDebug") {
                this.showDebug = UndoPlugin.getDefault().getPreferenceStore().getBoolean("prefShowDebug");
                this.viewer.refresh();
            }
        };
        UndoPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        this.viewer.getControl().addDisposeListener(event -> this.removeListeners());
    }

    private void removeListeners() {
        UndoPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    private void createGlobalActionHandlers() {
        this.undoAction = new UndoActionHandler(this.getSite(), this.fContext);
        this.redoAction = new RedoActionHandler(this.getSite(), this.fContext);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    private IUndoContext selectContext() {
        IUndoableOperation[] operations;
        ArrayList<IUndoContext> input = new ArrayList<IUndoContext>();
        IUndoableOperation[] iUndoableOperationArray = operations = this.history.getUndoHistory(IOperationHistory.GLOBAL_UNDO_CONTEXT);
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoContext[] contexts;
            IUndoableOperation operation = iUndoableOperationArray[n2];
            IUndoContext[] iUndoContextArray = contexts = operation.getContexts();
            int n3 = contexts.length;
            int n4 = 0;
            while (n4 < n3) {
                IUndoContext context = iUndoContextArray[n4];
                if (!input.contains(context)) {
                    input.add(context);
                }
                ++n4;
            }
            ++n2;
        }
        input.add(IOperationHistory.GLOBAL_UNDO_CONTEXT);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((IUndoContext)element).getLabel();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getSite().getShell(), (ILabelProvider)labelProvider);
        dialog.setMultipleSelection(false);
        dialog.setTitle(UndoExampleMessages.UndoHistoryView_ContextFilterDialog);
        dialog.setMessage(UndoExampleMessages.UndoHistoryView_ChooseContextMessage);
        dialog.setElements(input.toArray());
        dialog.setInitialSelections(new Object[]{this.fContext});
        if (dialog.open() == 0) {
            Object[] contexts = dialog.getResult();
            if (contexts[0] instanceof IUndoContext) {
                return (IUndoContext)contexts[0];
            }
            return null;
        }
        return null;
    }

    public void setContext(IUndoContext context) {
        this.fContext = context;
        this.redoAction.setContext(context);
        this.undoAction.setContext(context);
        this.viewer.refresh(false);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.undoAction.update();
        this.redoAction.update();
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.selectiveUndoAction);
        manager.add((IAction)this.filterAction);
        manager.add((IAction)this.refreshListAction);
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            IUndoableOperation operation = (IUndoableOperation)selection.getFirstElement();
            this.selectiveUndoAction.setEnabled(operation.canUndo());
        } else {
            this.selectiveUndoAction.setEnabled(false);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.filterAction = new Action(){

            public void run() {
                IUndoContext context = UndoHistoryView.this.selectContext();
                if (UndoHistoryView.this.fContext != context && context != null) {
                    UndoHistoryView.this.setContext(context);
                }
            }
        };
        this.filterAction.setText(UndoExampleMessages.UndoHistoryView_FilterText);
        this.filterAction.setToolTipText(UndoExampleMessages.UndoHistoryView_FilterToolTipText);
        this.filterAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.selectiveUndoAction = new Action(){

            public void run() {
                IUndoableOperation operation = (IUndoableOperation)UndoHistoryView.this.viewer.getStructuredSelection().getFirstElement();
                if (operation.canUndo()) {
                    try {
                        UndoHistoryView.this.history.undoOperation(operation, null, (IAdaptable)UndoHistoryView.this.undoAction);
                    }
                    catch (ExecutionException executionException) {
                        UndoHistoryView.this.showMessage(UndoExampleMessages.UndoHistoryView_OperationException);
                    }
                } else {
                    UndoHistoryView.this.showMessage(UndoExampleMessages.UndoHistoryView_OperationInvalid);
                }
            }
        };
        this.selectiveUndoAction.setText(UndoExampleMessages.UndoHistoryView_UndoSelected);
        this.selectiveUndoAction.setToolTipText(UndoExampleMessages.UndoHistoryView_UndoSelectedToolTipText);
        this.selectiveUndoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
        this.refreshListAction = new Action(){

            public void run() {
                if (!UndoHistoryView.this.viewer.getTable().isDisposed()) {
                    UndoHistoryView.this.viewer.refresh(true);
                }
            }
        };
        this.refreshListAction.setText(UndoExampleMessages.UndoHistoryView_RefreshList);
        this.refreshListAction.setToolTipText(UndoExampleMessages.UndoHistoryView_RefreshListToolTipText);
        this.doubleClickAction = new Action(){

            public void run() {
                IUndoableOperation operation = (IUndoableOperation)UndoHistoryView.this.viewer.getStructuredSelection().getFirstElement();
                StringBuilder buf = new StringBuilder(operation.getLabel());
                buf.append("\n");
                buf.append("Enabled=");
                buf.append(Boolean.valueOf(operation.canUndo()).toString());
                buf.append("\n");
                buf.append(operation.getClass().toString());
                UndoHistoryView.this.showMessage(buf.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(event -> this.doubleClickAction.run());
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)UndoExampleMessages.UndoHistoryView_InfoDialogTitle, (String)message);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        boolean enabled = !selection.isEmpty();
        this.selectiveUndoAction.setEnabled(enabled);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    IOperationHistoryListener {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            UndoHistoryView.this.history.addOperationHistoryListener((IOperationHistoryListener)this);
        }

        public void dispose() {
            UndoHistoryView.this.history.removeOperationHistoryListener((IOperationHistoryListener)this);
        }

        public Object[] getElements(Object input) {
            return UndoHistoryView.this.history.getUndoHistory(UndoHistoryView.this.fContext);
        }

        public void historyNotification(OperationHistoryEvent event) {
            if (UndoHistoryView.this.viewer.getTable().isDisposed()) {
                return;
            }
            Display display = UndoHistoryView.this.viewer.getTable().getDisplay();
            switch (event.getEventType()) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    if (!event.getOperation().hasContext(UndoHistoryView.this.fContext) || display == null) break;
                    display.syncExec(() -> {
                        if (!UndoHistoryView.this.viewer.getTable().isDisposed()) {
                            UndoHistoryView.this.viewer.refresh(true);
                        }
                    });
                }
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public String getText(Object obj) {
            if (!UndoHistoryView.this.showDebug && obj instanceof IUndoableOperation) {
                return ((IUndoableOperation)obj).getLabel();
            }
            return obj.toString();
        }
    }
}

