/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.compare.examples.xml.IdMap;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLComparePreferencePage;
import org.eclipse.compare.examples.xml.ui.StatusDialog;
import org.eclipse.compare.examples.xml.ui.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XMLCompareAddIdMapDialog
extends StatusDialog {
    private IdMap fIdMap;
    private HashMap fIdMaps;
    private HashMap fIdMapsInternal;
    private HashMap fIdExtensionToName;
    private boolean fEdit;
    private Text fIdMapText;
    private Text fIdMapExtText;

    public XMLCompareAddIdMapDialog(Shell parent, IdMap idmap, HashMap idmaps, HashMap idmapsInternal, HashMap idextensiontoname, boolean edit) {
        super(parent);
        this.fEdit = edit;
        if (this.fEdit) {
            this.setTitle(XMLCompareMessages.XMLCompareAddIdMapDialog_editTitle);
        } else {
            this.setTitle(XMLCompareMessages.XMLCompareAddIdMapDialog_newTitle);
        }
        this.fIdMap = idmap;
        this.fIdMaps = idmaps;
        this.fIdMapsInternal = idmapsInternal;
        this.fIdExtensionToName = idextensiontoname;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite composite = (Composite)super.createDialogArea(ancestor);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        Label label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareAddIdMapDialog_label);
        label.setLayoutData((Object)new GridData());
        this.fIdMapText = new Text(inner, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        this.fIdMapText.setLayoutData((Object)data);
        this.fIdMapText.setText(this.fIdMap.getName());
        this.fIdMapText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLCompareAddIdMapDialog.this.doValidation();
            }
        });
        label = new Label(inner, 0);
        label.setText(XMLCompareMessages.XMLCompareAddIdMapDialog_extlabel);
        label.setLayoutData((Object)new GridData());
        this.fIdMapExtText = new Text(inner, 2048);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        this.fIdMapExtText.setLayoutData((Object)data);
        this.fIdMapExtText.setText(this.fIdMap.getExtension());
        this.fIdMapExtText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLCompareAddIdMapDialog.this.doValidation();
            }
        });
        this.fIdMapText.setFocus();
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fIdMapText.getText();
        if (newText.length() == 0) {
            status.setError(XMLCompareMessages.XMLCompareAddIdMapDialog_error_noname);
        } else if (XMLComparePreferencePage.containsInvalidCharacters(newText)) {
            status.setError(XMLCompareMessages.XMLCompareAddIdMapDialog_error_invalidname);
        } else if (!this.fEdit && (this.fIdMaps.containsKey(newText) || this.fIdMapsInternal.containsKey(newText)) || this.fEdit && !newText.equals(this.fIdMap.getName()) && (this.fIdMaps.containsKey(newText) || this.fIdMapsInternal.containsKey(newText))) {
            status.setError(XMLCompareMessages.XMLCompareAddIdMapDialog_error_idmapExists);
        }
        newText = this.fIdMapExtText.getText().toLowerCase();
        if (newText.length() > 0) {
            if (newText.indexOf(".") > -1) {
                status.setError(XMLCompareMessages.XMLCompareAddIdMapDialog_error_extfullstop);
            } else if (this.fIdExtensionToName.containsKey(newText) && !this.fIdExtensionToName.get(newText).equals(this.fIdMap.getName())) {
                status.setError(MessageFormat.format("{0} {1}", XMLCompareMessages.XMLCompareAddIdMapDialog_error_extExists, (String)this.fIdExtensionToName.get(newText)));
            }
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        this.fIdMap.setName(this.fIdMapText.getText());
        this.fIdMap.setExtension(this.fIdMapExtText.getText().toLowerCase());
        super.okPressed();
    }
}

