/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.compare.internal.WorkQueue;
import org.eclipse.compare.internal.Worker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AsyncExecTests
extends TestCase {
    public AsyncExecTests() {
    }

    public AsyncExecTests(String name) {
        super(name);
    }

    public void testQueueAdd() {
        WorkQueue q = new WorkQueue();
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            }
        };
        IRunnableWithProgress r2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            }
        };
        q.add(r);
        AsyncExecTests.assertTrue((q.size() == 1 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        AsyncExecTests.assertTrue((q.remove() == r ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
        q.add(r);
        q.add(r);
        AsyncExecTests.assertTrue((q.size() == 1 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        q.add(r2);
        AsyncExecTests.assertTrue((q.size() == 2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        AsyncExecTests.assertTrue((boolean)q.contains(r2));
        AsyncExecTests.assertTrue((q.remove() == r ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((q.size() == 1 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((q.remove() == r2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
        q.add(r);
        q.add(r2);
        q.add(r);
        AsyncExecTests.assertTrue((q.size() == 2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        AsyncExecTests.assertTrue((boolean)q.contains(r2));
        AsyncExecTests.assertTrue((q.remove() == r2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((q.size() == 1 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((q.remove() == r ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
    }

    public void testWorker() throws InvocationTargetException, InterruptedException {
        final Worker w = new Worker("");
        final ArrayList worked = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        IRunnableWithProgress r2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertTrue((boolean)worked.isEmpty());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertTrue((worked.size() == 1 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(0) == r ? 1 : 0) != 0);
        worked.clear();
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r2);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertTrue((worked.size() == 2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(0) == r ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(1) == r2 ? 1 : 0) != 0);
        worked.clear();
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r2);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertTrue((worked.size() == 2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(1) == r ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(0) == r2 ? 1 : 0) != 0);
    }

    public void testCancelOnRequeue() throws InvocationTargetException, InterruptedException {
        final Worker w = new Worker("");
        final ArrayList worked = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (worked.isEmpty()) {
                    worked.add(this);
                    w.add((IRunnableWithProgress)this);
                    AsyncExecTests.assertTrue((boolean)monitor.isCanceled());
                    throw new OperationCanceledException();
                }
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        IRunnableWithProgress r2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        worked.clear();
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r2);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertTrue((worked.size() == 3 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(0) == r ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(1) == r2 ? 1 : 0) != 0);
        AsyncExecTests.assertTrue((worked.get(2) == r ? 1 : 0) != 0);
    }
}

