/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class DocLineComparatorTest
extends TestCase {
    public DocLineComparatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRangesEqual() {
        Document doc1 = new Document();
        doc1.set("if (s.strip))");
        Document doc2 = new Document();
        doc2.set("if (s.strip)");
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc1, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc2, null, true);
        Assert.assertFalse((boolean)comp1.rangesEqual(0, (IRangeComparator)comp2, 0));
    }

    public void testWhitespaceAtEnd() {
        Document doc1 = new Document();
        doc1.set("if (s.strip))");
        Document doc2 = new Document();
        doc2.set("if (s.strip))   ");
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc1, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc2, null, true);
        Assert.assertTrue((boolean)comp1.rangesEqual(0, (IRangeComparator)comp2, 0));
    }

    public void testOneCompareFilter() {
        Document doc1 = new Document();
        doc1.set("if (s.strip))");
        Document doc2 = new Document();
        doc2.set("IF (S.stRIp))");
        Document doc3 = new Document();
        doc3.set("IF (S.stRIp))   ");
        ICompareFilter filter = new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                return new IRegion[]{new Region(0, 2), new Region(4, 1), new Region(8, 2)};
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return false;
            }
        };
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc1, null, false, new ICompareFilter[]{filter}, 'L');
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc2, null, false, new ICompareFilter[]{filter}, 'R');
        Assert.assertTrue((boolean)comp1.rangesEqual(0, (IRangeComparator)comp2, 0));
        DocLineComparator comp3 = new DocLineComparator((IDocument)doc1, null, true, new ICompareFilter[]{filter}, 'L');
        DocLineComparator comp4 = new DocLineComparator((IDocument)doc3, null, true, new ICompareFilter[]{filter}, 'R');
        Assert.assertTrue((boolean)comp3.rangesEqual(0, (IRangeComparator)comp4, 0));
        DocLineComparator comp5 = new DocLineComparator((IDocument)doc1, null, false, new ICompareFilter[]{filter}, 'L');
        DocLineComparator comp6 = new DocLineComparator((IDocument)doc3, null, false, new ICompareFilter[]{filter}, 'R');
        Assert.assertFalse((boolean)comp5.rangesEqual(0, (IRangeComparator)comp6, 0));
    }

    public void testMultipleCompareFilters() {
        Document doc1 = new Document();
        doc1.set("if (s.strip))");
        Document doc2 = new Document();
        doc2.set("IF (S.stRIp))");
        ICompareFilter filter1 = new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                return new IRegion[]{new Region(0, 2)};
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return false;
            }
        };
        ICompareFilter filter2 = new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                return new IRegion[]{new Region(4, 1)};
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return false;
            }
        };
        ICompareFilter filter3 = new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                return new IRegion[]{new Region(8, 2)};
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return false;
            }
        };
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc1, null, false, new ICompareFilter[]{filter1, filter2, filter3}, 'L');
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc2, null, false, new ICompareFilter[]{filter1, filter2, filter3}, 'R');
        Assert.assertTrue((boolean)comp1.rangesEqual(0, (IRangeComparator)comp2, 0));
        DocLineComparator comp3 = new DocLineComparator((IDocument)doc1, null, false, new ICompareFilter[]{filter2, filter3}, 'L');
        DocLineComparator comp4 = new DocLineComparator((IDocument)doc2, null, false, new ICompareFilter[]{filter2, filter3}, 'R');
        Assert.assertFalse((boolean)comp3.rangesEqual(0, (IRangeComparator)comp4, 0));
    }

    public void testWhitespace() {
        IDocument[] docs = new IDocument[]{new Document(), new Document(), new Document(), new Document(), new Document(), new Document()};
        docs[0].set("if (s.strip))\r\n");
        docs[1].set("if (s.strip))\n");
        docs[2].set("if (s .strip))\n");
        docs[3].set("if (s.str ip))\r");
        docs[4].set("if (s.strip))");
        docs[5].set("if (s.stri p))");
        ICompareFilter[][] filters = new ICompareFilter[][]{null, {new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                return new IRegion[]{new Region(0, 2)};
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return true;
            }
        }}, {new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                return new IRegion[]{new Region(0, 2)};
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return false;
            }
        }}};
        int i = 0;
        while (i < docs.length) {
            int j = i + 1;
            while (j < docs.length) {
                int k = 0;
                while (k < filters.length) {
                    DocLineComparator l = new DocLineComparator(docs[i], null, false, filters[k], 'L');
                    DocLineComparator r = new DocLineComparator(docs[j], null, false, filters[k], 'R');
                    Assert.assertFalse((boolean)l.rangesEqual(0, (IRangeComparator)r, 0));
                    l = new DocLineComparator(docs[i], null, true, filters[k], 'L');
                    r = new DocLineComparator(docs[j], null, true, filters[k], 'R');
                    Assert.assertTrue((boolean)l.rangesEqual(0, (IRangeComparator)r, 0));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void testEmpty() {
        Document doc1 = new Document();
        doc1.set("");
        Document doc2 = new Document();
        doc2.set("    ");
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc1, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc2, null, true);
        Assert.assertTrue((boolean)comp1.rangesEqual(0, (IRangeComparator)comp2, 0));
    }

    public void testNoContent() {
        Document doc = new Document();
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc, (IRegion)new Region(0, doc.getLength()), true);
        Assert.assertTrue((boolean)comp1.rangesEqual(0, (IRangeComparator)comp2, 0));
        Assert.assertEquals((int)comp1.getRangeCount(), (int)comp2.getRangeCount());
        Assert.assertEquals((int)1, (int)comp2.getRangeCount());
    }

    public void testOneLine() {
        Document doc = new Document();
        doc.set("line1");
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc, (IRegion)new Region(0, doc.getLength()), true);
        Assert.assertEquals((int)comp1.getRangeCount(), (int)comp2.getRangeCount());
        Assert.assertEquals((int)1, (int)comp2.getRangeCount());
    }

    public void testTwoLines() {
        Document doc = new Document();
        doc.set("line1\nline2");
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc, (IRegion)new Region(0, doc.getLength()), true);
        Assert.assertEquals((int)comp1.getRangeCount(), (int)comp2.getRangeCount());
        Assert.assertEquals((int)2, (int)comp2.getRangeCount());
        DocLineComparator comp3 = new DocLineComparator((IDocument)doc, (IRegion)new Region(0, "line1".length()), true);
        Assert.assertEquals((int)1, (int)comp3.getRangeCount());
        comp3 = new DocLineComparator((IDocument)doc, (IRegion)new Region(0, "line1".length() + 1), true);
        Assert.assertEquals((int)2, (int)comp3.getRangeCount());
    }

    public void testBug259422() {
        Document doc = new Document();
        doc.set("");
        DocLineComparator comp1 = new DocLineComparator((IDocument)doc, null, true);
        DocLineComparator comp2 = new DocLineComparator((IDocument)doc, (IRegion)new Region(0, doc.getLength()), true);
        Assert.assertEquals((int)comp1.getRangeCount(), (int)comp2.getRangeCount());
    }
}

