/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.compare.internal.CompareResourceFilter;

public class FilterTest
extends TestCase {
    CompareResourceFilter fFilter;

    public FilterTest(String name) {
        super(name);
    }

    public void testFilterFile() {
        CompareResourceFilter f = new CompareResourceFilter();
        f.setFilters("*.class");
        Assert.assertTrue((String)"file foo.class should be filtered", (boolean)f.filter("foo.class", false, false));
        Assert.assertFalse((String)"file foo.java shouldn't be filtered", (boolean)f.filter("foo.java", false, false));
    }

    public void testFilterDotFile() {
        CompareResourceFilter f = new CompareResourceFilter();
        f.setFilters(".cvsignore");
        Assert.assertTrue((String)"file .cvsignore should be filtered", (boolean)f.filter(".cvsignore", false, false));
        Assert.assertFalse((String)"file foo.cvsignore shouldn't be filtered", (boolean)f.filter("foo.cvsignore", false, false));
    }

    public void testFilterFolder() {
        CompareResourceFilter f = new CompareResourceFilter();
        f.setFilters("bin/");
        Assert.assertTrue((String)"folder bin should be filtered", (boolean)f.filter("bin", true, false));
        Assert.assertFalse((String)"file bin shouldn't be filtered", (boolean)f.filter("bin", false, false));
    }

    public void testMultiFilter() {
        CompareResourceFilter f = new CompareResourceFilter();
        f.setFilters("*.class, .cvsignore, bin/, src/");
        Assert.assertTrue((String)"file foo.class should be filtered", (boolean)f.filter("foo.class", false, false));
        Assert.assertFalse((String)"file foo.java shouldn't be filtered", (boolean)f.filter("foo.java", false, false));
        Assert.assertTrue((String)"file .cvsignore should be filtered", (boolean)f.filter(".cvsignore", false, false));
        Assert.assertFalse((String)"file foo.cvsignore shouldn't be filtered", (boolean)f.filter("foo.cvsignore", false, false));
        Assert.assertTrue((String)"folder bin should be filtered", (boolean)f.filter("bin", true, false));
        Assert.assertFalse((String)"file bin shouldn't be filtered", (boolean)f.filter("bin", false, false));
        Assert.assertTrue((String)"folder src should be filtered", (boolean)f.filter("src", true, false));
        Assert.assertFalse((String)"file src shouldn't be filtered", (boolean)f.filter("src", false, false));
    }

    public void testVerify() {
    }
}

