/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.LineReader;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.IHunkFilter;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.tests.PatchUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class PatchTest
extends TestCase {
    private static final String PATCH_CONFIGURATION = "patchConfiguration.properties";
    Properties defaultPatchProperties;
    private List failures = new ArrayList();

    public PatchTest(String name) {
        super(name);
        this.defaultPatchProperties = new Properties();
        this.defaultPatchProperties.setProperty("patchFile", "patch.txt");
        this.defaultPatchProperties.setProperty("contextFile", "context.txt");
        this.defaultPatchProperties.setProperty("expectedResultFile", "exp_context.txt");
        this.defaultPatchProperties.setProperty("fuzzFactor", "-1");
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreatePatch() throws CoreException, IOException {
        this.patch("addition.txt", "patch_addition.txt", "exp_addition.txt");
    }

    public void testUnterminatedCreatePatch() throws CoreException, IOException {
        this.patch("addition.txt", "patch_addition2.txt", "exp_addition2.txt");
    }

    public void testContext0Patch() throws CoreException, IOException {
        this.patch("context.txt", "patch_context0.txt", "exp_context.txt");
    }

    public void testContext1Patch() throws CoreException, IOException {
        this.patch("context.txt", "patch_context1.txt", "exp_context.txt");
    }

    public void testContext3Patch() throws CoreException, IOException {
        this.patch("context.txt", "patch_context3.txt", "exp_context.txt");
    }

    public void testHunkFilter() throws CoreException, IOException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_hunkFilter.txt");
        PatchUtils.StringStorage expStorage = new PatchUtils.StringStorage("context.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchTest.assertEquals((int)1, (int)patches.length);
        IHunk[] hunks = patches[0].getHunks();
        PatchTest.assertEquals((int)5, (int)hunks.length);
        PatchConfiguration pc = new PatchConfiguration();
        final IHunk toFilterOut = hunks[3];
        pc.addHunkFilter(new IHunkFilter(){

            public boolean select(IHunk hunk) {
                return hunk != toFilterOut;
            }
        });
        IFilePatchResult result = patches[0].apply((IStorage)expStorage, pc, (IProgressMonitor)new NullProgressMonitor());
        IHunk[] rejects = result.getRejects();
        PatchTest.assertEquals((int)2, (int)rejects.length);
        boolean aFiltered = pc.getHunkFilters()[0].select(rejects[0]);
        boolean bFiltered = pc.getHunkFilters()[0].select(rejects[1]);
        PatchTest.assertTrue((aFiltered && !bFiltered || !aFiltered && bFiltered ? 1 : 0) != 0);
        InputStream actual = result.getPatchedContents();
        LineReader lr = new LineReader(PatchUtils.getReader("exp_hunkFilter.txt"));
        List inLines = lr.readLines();
        String expected = LineReader.createString((boolean)false, (List)inLines);
        PatchTest.assertEquals((String)expected, (String)PatchUtils.asString(actual));
    }

    public void testContext3PatchWithHeader() throws CoreException, IOException {
        this.patch("context.txt", "patch_context3_header.txt", "exp_context.txt");
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_context3_header.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        String header = patches[0].getHeader();
        LineReader reader = new LineReader(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(header.getBytes()))));
        List lines = reader.readLines();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Index: old.txt\n");
        expected.add("UID: 42\n");
        PatchTest.assertEquals((String)LineReader.createString((boolean)false, expected), (String)LineReader.createString((boolean)false, (List)lines));
    }

    public void testDateUnknown() throws CoreException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_dateunknown.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchTest.assertEquals((long)0L, (long)patches[0].getBeforeDate());
        PatchTest.assertEquals((long)0L, (long)patches[0].getAfterDate());
    }

    public void testDateError() throws CoreException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_dateerror.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchTest.assertEquals((long)0L, (long)patches[0].getBeforeDate());
        PatchTest.assertEquals((long)0L, (long)patches[0].getAfterDate());
    }

    public void testDateKnown() throws CoreException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_datevalid.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchTest.assertFalse((0L == patches[0].getBeforeDate() ? 1 : 0) != 0);
        PatchTest.assertFalse((0L == patches[0].getAfterDate() ? 1 : 0) != 0);
    }

    public void testWorkspacePatch_Create() {
        this.patchWorkspace(new String[]{"addition.txt", "addition.txt"}, "patch_workspacePatchAddition.txt", new String[]{"exp_workspacePatchAddition2.txt", "exp_workspacePatchAddition.txt"}, false, 0);
    }

    public void testWorkspacePatch_Create_Reverse() {
        this.patchWorkspace(new String[]{"exp_workspacePatchAddition2.txt", "exp_workspacePatchAddition.txt"}, "patch_workspacePatchAddition.txt", new String[]{"addition.txt", "addition.txt"}, true, 0);
    }

    public void testWorkspacePatch_Modify() {
        this.patchWorkspace(new String[]{"exp_workspacePatchAddition2.txt", "exp_workspacePatchAddition.txt", "addition.txt"}, "patch_workspacePatchMod.txt", new String[]{"exp_workspacePatchMod1.txt", "exp_workspacePatchMod2.txt", "exp_workspacePatchMod3.txt"}, false, 0);
    }

    public void testWorkspacePatch_Modify_Reverse() {
        this.patchWorkspace(new String[]{"exp_workspacePatchMod1.txt", "exp_workspacePatchMod2.txt", "exp_workspacePatchMod3.txt"}, "patch_workspacePatchMod.txt", new String[]{"exp_workspacePatchAddition2.txt", "exp_workspacePatchAddition.txt", "addition.txt"}, true, 0);
    }

    public void testWorkspacePatch_Delete() {
        this.patchWorkspace(new String[]{"exp_workspacePatchMod2.txt", "addition.txt", "exp_workspacePatchMod1.txt", "addition.txt"}, "patch_workspacePatchDelete.txt", new String[]{"addition.txt", "exp_workspacePatchDelete2.txt", "addition.txt", "exp_workspacePatchDelete1.txt"}, false, 0);
    }

    public void testWorkspacePatch_Delete_Reverse() {
        this.patchWorkspace(new String[]{"addition.txt", "exp_workspacePatchDelete2.txt", "addition.txt", "exp_workspacePatchDelete1.txt"}, "patch_workspacePatchDelete.txt", new String[]{"exp_workspacePatchMod2.txt", "addition.txt", "exp_workspacePatchMod1.txt", "addition.txt"}, true, 0);
    }

    public void testPatchdataSubfolders() throws IOException, CoreException {
        URL patchdataUrl = new URL(PatchUtils.getBundle().getEntry("/"), new Path("patchdata").toString());
        patchdataUrl = FileLocator.resolve((URL)patchdataUrl);
        Map map = null;
        if (patchdataUrl.getProtocol().equals("file")) {
            map = this.extractNamesForFileProtocol(patchdataUrl);
        } else if (patchdataUrl.getProtocol().equals("jar")) {
            map = this.extractNamesForJarProtocol(patchdataUrl);
        } else {
            PatchTest.fail((String)"Unknown protocol");
        }
        PatchTest.assertNotNull((Object)map);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String sf = (String)iterator.next();
            PatchUtils.PatchTestConfiguration ptc = (PatchUtils.PatchTestConfiguration)map.get(sf);
            String[] originalFiles = ptc.originalFileNames;
            String patch = ptc.patchFileName;
            String[] expectedFiles = ptc.expectedFileNames;
            String[] actualFiles = ptc.actualFileNames;
            PatchConfiguration pc = ptc.pc;
            String msg = "Test for subfolder [patchdata/" + sf + "] failed.";
            try {
                this.patchWorkspace(msg, originalFiles, patch, expectedFiles, pc);
            }
            catch (AssertionFailedError e) {
                this.failures.add(e);
            }
            if (actualFiles == null) continue;
            try {
                this.patchWorkspace(msg, originalFiles, patch, actualFiles, pc);
            }
            catch (AssertionFailedError assertionFailedError) {
                continue;
            }
            this.failures.add(new AssertionFailedError("\npatchWorkspace should fail for folder [patchdata/" + sf + "]."));
        }
        if (this.failures.isEmpty()) {
            return;
        }
        if (this.failures.size() == 1) {
            throw (AssertionFailedError)((Object)this.failures.get(0));
        }
        StringBuffer sb = new StringBuffer("Failures occured while testing data from patchdata subfolder (Please check log for further details):");
        Iterator iterator2 = this.failures.iterator();
        while (iterator2.hasNext()) {
            AssertionFailedError error = (AssertionFailedError)((Object)iterator2.next());
            this.log("org.eclipse.compare.tests", error);
            sb.append("\n" + error.getMessage());
        }
        throw new AssertionFailedError(sb.toString());
    }

    private void log(String pluginID, IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)pluginID)).log(status);
    }

    private void log(String pluginID, Throwable e) {
        this.log(pluginID, (IStatus)new Status(4, pluginID, 4, "Error", e));
    }

    private Map extractNamesForJarProtocol(URL patchdataUrl) throws IOException, CoreException {
        JarFile jarFile = ((JarURLConnection)patchdataUrl.openConnection()).getJarFile();
        String patchdataName = null;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith("/patchdata/")) continue;
            patchdataName = entryName;
            break;
        }
        if (patchdataName == null) {
            return null;
        }
        HashMap result = new HashMap();
        entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entry.isDirectory() || entryName.equals(patchdataName) || !entryName.startsWith(patchdataName)) continue;
            ZipEntry patchConf = jarFile.getEntry(String.valueOf(entryName) + "/" + PATCH_CONFIGURATION);
            if (patchConf != null) {
                PatchUtils.JarEntryStorage jes = new PatchUtils.JarEntryStorage(entry, jarFile);
                Properties properties = new Properties();
                try {
                    properties.load(jes.getContents());
                }
                catch (IOException iOException) {
                    PatchTest.fail((String)("IOException occured while loading the Patch Configuration file for " + entryName.toString()));
                }
                this.processProperties(result, properties, entryName);
                continue;
            }
            this.processProperties(result, this.defaultPatchProperties, entryName);
        }
        return result;
    }

    private Map extractNamesForFileProtocol(URL patchdataUrl) throws CoreException {
        HashMap result = new HashMap();
        Path patchdataFolderPath = new Path(patchdataUrl.getPath());
        File patchdataFolderFile = patchdataFolderPath.toFile();
        PatchTest.assertTrue((boolean)patchdataFolderFile.isDirectory());
        File[] listOfSubfolders = patchdataFolderFile.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int i = 0;
        while (i < listOfSubfolders.length) {
            File subfolder = listOfSubfolders[i];
            Path pcPath = new Path(String.valueOf(subfolder.getPath()) + "/" + PATCH_CONFIGURATION);
            File pcFile = pcPath.toFile();
            if (!subfolder.getName().equals("CVS")) {
                if (pcFile.exists()) {
                    Properties properties = new Properties();
                    try {
                        properties.load(new FileInputStream(pcFile));
                    }
                    catch (IOException iOException) {
                        PatchTest.fail((String)("IOException occured while loading the Patch Configuration file for " + subfolder.toString()));
                    }
                    this.processProperties(result, properties, subfolder.getName());
                } else {
                    this.processProperties(result, this.defaultPatchProperties, subfolder.getName());
                }
            }
            ++i;
        }
        return result;
    }

    private void processProperties(Map result, Properties p, String subfolderName) {
        boolean skipTest = Boolean.valueOf(p.getProperty("skipTest", "false"));
        if (skipTest) {
            return;
        }
        String pf = p.getProperty("patchFile", "patch.txt");
        String[] cf = p.getProperty("contextFile", "context.txt").split(",");
        String[] erf = p.getProperty("expectedResultFile", "exp_context").split(",");
        String[] arf = null;
        String arfp = p.getProperty("actualResultFile", null);
        if (arfp != null) {
            arf = arfp.split(",");
        }
        int fuzzFactor = Integer.parseInt(p.getProperty("fuzzFactor", "0"));
        boolean ignoreWhitespace = Boolean.valueOf(p.getProperty("ignoreWhitespace", "false"));
        int prefixSegmentStrip = Integer.parseInt(p.getProperty("prefixSegmentStrip", "0"));
        boolean reversed = Boolean.valueOf(p.getProperty("reversed", "false"));
        PatchConfiguration pc = new PatchConfiguration();
        pc.setFuzz(fuzzFactor);
        pc.setIgnoreWhitespace(ignoreWhitespace);
        pc.setPrefixSegmentStripCount(prefixSegmentStrip);
        pc.setReversed(reversed);
        pf = String.valueOf(subfolderName) + "/" + pf;
        int i = 0;
        while (i < cf.length) {
            cf[i] = String.valueOf(subfolderName) + "/" + cf[i];
            ++i;
        }
        i = 0;
        while (i < erf.length) {
            erf[i] = String.valueOf(subfolderName) + "/" + erf[i];
            ++i;
        }
        if (arf != null) {
            i = 0;
            while (i < arf.length) {
                arf[i] = String.valueOf(subfolderName) + "/" + arf[i];
                ++i;
            }
        }
        PatchUtils.PatchTestConfiguration tpc = new PatchUtils.PatchTestConfiguration();
        tpc.originalFileNames = cf;
        tpc.patchFileName = pf;
        tpc.subfolderName = subfolderName;
        tpc.expectedFileNames = erf;
        tpc.actualFileNames = arf;
        tpc.pc = pc;
        result.put(subfolderName, tpc);
    }

    private void patch(String old, String patch, String expt) throws CoreException, IOException {
        this.patcherPatch(old, patch, expt);
        this.filePatch(old, patch, expt);
    }

    private void filePatch(String old, String patch, String expt) throws CoreException, IOException {
        LineReader lr = new LineReader(PatchUtils.getReader(expt));
        List inLines = lr.readLines();
        String expected = LineReader.createString((boolean)false, (List)inLines);
        PatchUtils.StringStorage oldStorage = new PatchUtils.StringStorage(old);
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage(patch);
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchTest.assertTrue((patches.length == 1 ? 1 : 0) != 0);
        IFilePatchResult result = patches[0].apply((IStorage)oldStorage, new PatchConfiguration(), null);
        PatchTest.assertTrue((boolean)result.hasMatches());
        PatchTest.assertFalse((boolean)result.hasRejects());
        InputStream actualStream = result.getPatchedContents();
        String actual = PatchUtils.asString(actualStream);
        PatchTest.assertEquals((String)expected, (String)actual);
    }

    private void patcherPatch(String old, String patch, String expt) {
        LineReader lr = new LineReader(PatchUtils.getReader(old));
        List inLines = lr.readLines();
        WorkspacePatcher patcher = new WorkspacePatcher();
        try {
            patcher.parse(PatchUtils.getReader(patch));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FilePatch2[] diffs = patcher.getDiffs();
        Assert.assertEquals((int)diffs.length, (int)1);
        FileDiffResult diffResult = patcher.getDiffResult(diffs[0]);
        diffResult.patch(inLines, null);
        LineReader expectedContents = new LineReader(PatchUtils.getReader(expt));
        List expectedLines = expectedContents.readLines();
        Object[] expected = expectedLines.toArray();
        Object[] result = inLines.toArray();
        Assert.assertEquals((int)expected.length, (int)result.length);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((Object)expected[i], (Object)result[i]);
            ++i;
        }
    }

    private void patchWorkspace(String[] originalFiles, String patch, String[] expectedOutcomeFiles, boolean reverse, int fuzzFactor) {
        PatchConfiguration pc = new PatchConfiguration();
        pc.setReversed(reverse);
        pc.setFuzz(fuzzFactor);
        this.patchWorkspace(null, originalFiles, patch, expectedOutcomeFiles, pc);
    }

    private void patchWorkspace(String msg, String[] originalFiles, String patch, String[] expectedOutcomeFiles, PatchConfiguration patchConfiguration) {
        Assert.assertEquals((int)originalFiles.length, (int)expectedOutcomeFiles.length);
        WorkspacePatcher patcher = new WorkspacePatcher();
        try {
            patcher.getConfiguration().setFuzz(patchConfiguration.getFuzz());
            patcher.getConfiguration().setIgnoreWhitespace(patchConfiguration.isIgnoreWhitespace());
            patcher.getConfiguration().setPrefixSegmentStripCount(patchConfiguration.getPrefixSegmentStripCount());
            patcher.parse(PatchUtils.getReader(patch));
            patcher.setReversed(patchConfiguration.isReversed());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FilePatch2[] diffs = patcher.getDiffs();
        int i = 0;
        while (i < originalFiles.length) {
            LineReader lr = new LineReader(PatchUtils.getReader(originalFiles[i]));
            List inLines = lr.readLines();
            FileDiffResult diffResult = patcher.getDiffResult(diffs[i]);
            diffResult.patch(inLines, null);
            LineReader expectedContents = new LineReader(PatchUtils.getReader(expectedOutcomeFiles[i]));
            List expectedLines = expectedContents.readLines();
            Object[] expected = expectedLines.toArray();
            String resultString = LineReader.createString((boolean)patcher.isPreserveLineDelimeters(), (List)inLines);
            LineReader resultReader = new LineReader(new BufferedReader(new StringReader(resultString)));
            Object[] result = resultReader.readLines().toArray();
            Assert.assertEquals((String)msg, (int)expected.length, (int)result.length);
            int j = 0;
            while (j < expected.length) {
                Assert.assertEquals((String)msg, (Object)expected[j], (Object)result[j]);
                ++j;
            }
            ++i;
        }
    }
}

