/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import junit.framework.TestCase;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class RangeDifferencerThreeWayDiffTest
extends TestCase {
    static final String S = System.getProperty("line.separator");

    public RangeDifferencerThreeWayDiffTest(String name) {
        super(name);
    }

    public void testInsertConflict() {
        String a = "A" + S + "B" + S + "C" + S + "D";
        String l = "A" + S + "B" + S + "x" + S + "C" + S + "D";
        String r = "A" + S + "B" + S + "y" + S + "C" + S + "D";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)1, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[2].kind());
    }

    public void testChangeConflict() {
        String a = "A" + S + "B" + S + "C" + S + "D";
        String l = "A" + S + "b1" + S + "C" + S + "D";
        String r = "A" + S + "b2" + S + "C" + S + "D";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)1, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[2].kind());
    }

    public void testDeleteAndChangeConflict() {
        String a = "A" + S + "B" + S + "C";
        String l = "A" + S + "C";
        String r = "A" + S + "b1" + S + "C";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)1, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[2].kind());
    }

    public void testInsertWithinMultilineChangeConflict() {
        String a = "A" + S + "B" + S + "C" + S + "D";
        String l = "A" + S + "B" + S + "x" + S + "C" + S + "D";
        String r = "A" + S + "x" + S + "y" + S + "D";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)1, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[2].kind());
    }

    public void testAdjoiningChangesNoConflict() {
        String a = "A" + S + "B" + S + "C" + S + "D";
        String l = "A" + S + "b1" + S + "C" + S + "D";
        String r = "A" + S + "B" + S + "c1" + S + "D";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)4, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)2, (int)diffs[2].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[3].kind());
    }

    public void testAdjoiningInsertAndChangeNoConflict() {
        String a = "A" + S + "B" + S + "C" + S + "D";
        String l = "A" + S + "B" + S + "x" + S + "C" + S + "D";
        String r = "A" + S + "B" + S + "c1" + S + "D";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)4, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)2, (int)diffs[2].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[3].kind());
    }

    public void testAdjoiningMultilineChangeNoConflict() {
        String a = "A" + S + "B" + S + "C" + S + "D";
        String l = "A" + S + "x" + S + "y" + S + "D";
        String r = "A" + S + "B" + S + "C" + S + "d1";
        RangeDifference[] diffs = this.findRange(a, l, r);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs.length);
        RangeDifferencerThreeWayDiffTest.assertEquals((int)0, (int)diffs[0].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)3, (int)diffs[1].kind());
        RangeDifferencerThreeWayDiffTest.assertEquals((int)2, (int)diffs[2].kind());
    }

    private RangeDifference[] findRange(String a, String l, String r) {
        DocLineComparator ancestor = new DocLineComparator((IDocument)new Document(a), null, false);
        DocLineComparator left = new DocLineComparator((IDocument)new Document(l), null, false);
        DocLineComparator right = new DocLineComparator((IDocument)new Document(r), null, false);
        return RangeDifferencer.findRanges((IProgressMonitor)new NullProgressMonitor(), (IRangeComparator)ancestor, (IRangeComparator)left, (IRangeComparator)right);
    }
}

