/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class StructureCreatorTest
extends TestCase {
    public StructureCreatorTest() {
    }

    public StructureCreatorTest(String name) {
        super(name);
    }

    public void testIgnoreWhitespace() {
        IDocument[] docs = new IDocument[]{new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document(), new Document()};
        docs[0].set("ABCDEF");
        docs[1].set("ABC DEF");
        docs[2].set("ABC\r\nDEF");
        docs[3].set("ABC\r\nDEF  ");
        docs[4].set("\r\nABC\r\nDEF");
        docs[5].set("   \r\nABC\r\nDEF");
        docs[6].set("\r\nABC\r\nDEF\r\n");
        docs[7].set("\r\nA BC\r\nDE F\r\n");
        docs[8].set("ABC\r\n\r\nDEF");
        docs[9].set("ABC\nDEF");
        docs[10].set("ABC\nDEF   ");
        docs[11].set("ABC\nDEF\n");
        docs[12].set("\nABCDEF");
        docs[13].set(" \nAB CD EF");
        docs[14].set("\nABC\nDEF\n");
        ICompareFilter[][] filters = new ICompareFilter[][]{null, {new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                String line = lineComparison.get("THIS_LINE").toString();
                int index = line.indexOf("A");
                if (index > -1) {
                    return new IRegion[]{new Region(index, 1)};
                }
                return null;
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return true;
            }
        }}, {new ICompareFilter(){

            public void setInput(Object input, Object ancestor, Object left, Object right) {
            }

            public IRegion[] getFilteredRegions(HashMap lineComparison) {
                String line = lineComparison.get("THIS_LINE").toString();
                int index = line.indexOf("E");
                if (index > -1) {
                    return new IRegion[]{new Region(index, 1)};
                }
                return null;
            }

            public boolean isEnabledInitially() {
                return false;
            }

            public boolean canCacheFilteredRegions() {
                return false;
            }
        }}};
        StructureCreator creator = new StructureCreator(){
            private Pattern whitespace = Pattern.compile("\\s+");
            private Matcher matcher = null;

            public String getName() {
                return "NAME";
            }

            public String getContents(Object node, boolean ignoreWhitespace) {
                DocumentRangeNode drn = (DocumentRangeNode)node;
                String retval = null;
                try {
                    retval = drn.getDocument().get(drn.getRange().getOffset(), drn.getRange().getLength());
                    if (ignoreWhitespace) {
                        if (this.matcher == null) {
                            this.matcher = this.whitespace.matcher(retval);
                        } else {
                            this.matcher.reset(retval);
                        }
                        retval = this.matcher.replaceAll("");
                    }
                }
                catch (BadLocationException ble) {
                    StructureCreatorTest.assertNull((Object)((Object)ble));
                }
                return retval;
            }

            protected IStructureComparator createStructureComparator(Object element, IDocument document, ISharedDocumentAdapter sharedDocumentAdapter, IProgressMonitor monitor) throws CoreException {
                return new DocumentRangeNode(1, "ID", document, 0, document.getLength());
            }
        };
        int i = 0;
        while (i < docs.length) {
            int j = i + 1;
            while (j < docs.length) {
                int k = 0;
                while (k < filters.length) {
                    DocumentRangeNode l = new DocumentRangeNode(1, "ID", docs[i], 0, docs[i].getLength());
                    DocumentRangeNode r = new DocumentRangeNode(1, "ID", docs[j], 0, docs[j].getLength());
                    creator.contentsEquals((Object)l, 'L', (Object)r, 'R', true, filters[k]);
                    Assert.assertFalse((boolean)creator.contentsEquals((Object)l, 'L', (Object)r, 'R', false, filters[k]));
                    Assert.assertTrue((boolean)creator.contentsEquals((Object)l, 'L', (Object)r, 'R', true, filters[k]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

