/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTest;

public class WorkspaceTest
extends ResourceTest {
    protected static IProgressMonitor DEFAULT_MONITOR = new NullProgressMonitor();
    protected static final IProgressMonitor DEFAULT_PROGRESS_MONITOR = new NullProgressMonitor();
    static /* synthetic */ Class class$0;

    public static Test suite(Class c) {
        String testName = System.getProperty("eclipse.team.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(c);
            return suite;
        }
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            return (Test)c.getConstructor(classArray).newInstance(testName);
        }
        catch (Exception e) {
            WorkspaceTest.fail((String)e.getMessage());
            return null;
        }
    }

    public WorkspaceTest() {
    }

    public WorkspaceTest(String name) {
        super(name);
    }

    protected IProject getNamedTestProject(String name) throws CoreException {
        IProject target = WorkspaceTest.getWorkspace().getRoot().getProject(name);
        if (!target.exists()) {
            target.create(null);
            target.open(null);
        }
        this.assertExistsInFileSystem((IResource)target);
        return target;
    }

    protected IProject getUniqueTestProject(String prefix) throws CoreException {
        return this.getNamedTestProject(String.valueOf(prefix) + "-" + Long.toString(System.currentTimeMillis()));
    }

    protected IProject createProject(String prefix, String[] resources) throws CoreException {
        IProject project = this.getUniqueTestProject(prefix);
        this.buildResources((IContainer)project, resources, true);
        return project;
    }

    protected IProject createProject(String[] resources) throws CoreException {
        return this.createProject(this.getName(), resources);
    }

    protected IStatus getTeamTestStatus(int severity) {
        return new Status(severity, "org.eclipse.team.tests.core", 0, "team status", null);
    }

    public IResource[] buildResources(IContainer container, String[] hierarchy, boolean includeContainer) throws CoreException {
        ArrayList<Object> resources = new ArrayList<Object>(hierarchy.length + 1);
        if (includeContainer) {
            resources.add(container);
        }
        resources.addAll(Arrays.asList(this.buildResources(container, hierarchy)));
        IResource[] result = resources.toArray(new IResource[resources.size()]);
        this.ensureExistsInWorkspace(result, true);
        int i = 0;
        while (i < result.length) {
            if (result[i].getType() == 1) {
                ((IFile)result[i]).setContents(WorkspaceTest.getRandomContents(100), true, false, null);
            }
            ++i;
        }
        return result;
    }

    public IResource[] buildEmptyResources(IContainer container, String[] hierarchy, boolean includeContainer) throws CoreException {
        ArrayList<Object> resources = new ArrayList<Object>(hierarchy.length + 1);
        resources.addAll(Arrays.asList(this.buildResources(container, hierarchy)));
        if (includeContainer) {
            resources.add(container);
        }
        IResource[] result = resources.toArray(new IResource[resources.size()]);
        this.ensureExistsInWorkspace(result, true);
        return result;
    }

    protected static InputStream getRandomContents(int sizeAtLeast) {
        StringBuffer randomStuff = new StringBuffer(sizeAtLeast + 100);
        while (randomStuff.length() < sizeAtLeast) {
            randomStuff.append(WorkspaceTest.getRandomSnippet());
        }
        return new ByteArrayInputStream(randomStuff.toString().getBytes());
    }

    public static String getRandomSnippet() {
        switch ((int)Math.round(Math.random() * 10.0)) {
            case 0: {
                return "este e' o meu conteudo (portuguese)";
            }
            case 1: {
                return "Dann brauchen wir aber auch einen deutschen Satz!";
            }
            case 2: {
                return "I'll be back";
            }
            case 3: {
                return "don't worry, be happy";
            }
            case 4: {
                return "there is no imagination for more sentences";
            }
            case 5: {
                return "customize yours";
            }
            case 6: {
                return "foo";
            }
            case 7: {
                return "bar";
            }
            case 8: {
                return "foobar";
            }
            case 9: {
                return "case 9";
            }
        }
        return "these are my contents";
    }

    public void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Testing was rudely interrupted.");
        }
    }

    public void appendText(IResource resource, String text, boolean prepend) throws CoreException, IOException {
        IFile file = (IFile)resource;
        InputStream in = file.getContents();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int i;
            if (prepend) {
                bos.write(text.getBytes());
            }
            while ((i = in.read()) != -1) {
                bos.write(i);
            }
            if (!prepend) {
                bos.write(text.getBytes());
            }
        }
        finally {
            in.close();
        }
        file.setContents((InputStream)new ByteArrayInputStream(bos.toByteArray()), false, false, DEFAULT_MONITOR);
    }

    public IResource[] getResources(IContainer container, String[] hierarchy) throws CoreException {
        IResource[] resources = new IResource[hierarchy.length];
        int i = 0;
        while (i < resources.length) {
            resources[i] = container.findMember(hierarchy[i]);
            if (resources[i] == null) {
                resources[i] = this.buildResources(container, new String[]{hierarchy[i]})[0];
            }
            ++i;
        }
        return resources;
    }

    protected void assertEquals(IContainer container1, IContainer container2) throws CoreException {
        WorkspaceTest.assertEquals((String)container1.getName(), (String)container2.getName());
        ArrayList<IResource> members1 = new ArrayList<IResource>();
        members1.addAll(Arrays.asList(container1.members()));
        ArrayList<IResource> members2 = new ArrayList<IResource>();
        members2.addAll(Arrays.asList(container2.members()));
        WorkspaceTest.assertTrue((members1.size() == members2.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < members1.size()) {
            IResource member1 = (IResource)members1.get(i);
            IResource member2 = container2.findMember(member1.getName());
            WorkspaceTest.assertNotNull((Object)member2);
            this.assertEquals(member1, member2);
            ++i;
        }
    }

    protected void assertEquals(IFile file1, IFile file2) throws CoreException {
        WorkspaceTest.assertEquals((String)file1.getName(), (String)file2.getName());
        WorkspaceTest.assertTrue((boolean)this.compareContent(file1.getContents(), file2.getContents()));
    }

    protected void assertEquals(IProject container1, IProject container2) throws CoreException {
        ArrayList<IResource> members1 = new ArrayList<IResource>();
        members1.addAll(Arrays.asList(container1.members()));
        members1.remove(container1.findMember(".project"));
        ArrayList<IResource> members2 = new ArrayList<IResource>();
        members2.addAll(Arrays.asList(container2.members()));
        members2.remove(container2.findMember(".project"));
        WorkspaceTest.assertTrue((String)("Number of children differs for " + container1.getFullPath()), (members1.size() == members2.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < members1.size()) {
            IResource member1 = (IResource)members1.get(i);
            IResource member2 = container2.findMember(member1.getName());
            WorkspaceTest.assertNotNull((Object)member2);
            this.assertEquals(member1, member2);
            ++i;
        }
    }

    protected void assertEquals(IResource resource1, IResource resource2) throws CoreException {
        WorkspaceTest.assertEquals((int)resource1.getType(), (int)resource2.getType());
        if (resource1.getType() == 1) {
            this.assertEquals((IFile)resource1, (IFile)resource2);
        } else {
            this.assertEquals((IContainer)resource1, (IContainer)resource2);
        }
    }
}

