/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractFileBufferDocCreationTests
extends TestCase {
    protected ITextFileBufferManager fManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public void testCreateDocumentPartipants_FileExt() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP3");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.assertParticipantsInvoked("anything.111foo", classArray);
    }

    public void testCreateDocumentPartipants_Name() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP3");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.assertParticipantsInvoked("111fooname", classArray);
    }

    public void testCreateDocumentPartipants_FileExt_Name() {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP3");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        this.assertParticipantsInvoked("111fooname.111foo", classArray);
    }

    public void testCreateDocumentPartipants_FileExt_Extension() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP4");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP6");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.assertParticipantsInvoked("anything.222foo", classArray);
    }

    public void testCreateDocumentPartipants_Name_Extension() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP5");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP6");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.assertParticipantsInvoked("222fooname", classArray);
    }

    public void testCreateDocumentPartipants_FileExt_Name_Extension() {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP4");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP5");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants$TestDSP6");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        this.assertParticipantsInvoked("222fooname.222foo", classArray);
    }

    public void testDocumentSetupParticipantExtension_1() {
        this.assertDocumentContent("emanoof333/p/", "/p/333fooname", LocationKind.IFILE);
        this.assertDocumentContent("oof333.emanoof333/p/", "/p/333fooname.333foo", LocationKind.IFILE);
        this.assertDocumentContent("oof333.gnihtyna/p/", "/p/anything.333foo", LocationKind.IFILE);
        this.assertDocumentContent("", "333fooname", LocationKind.LOCATION);
        this.assertDocumentContent("", "333fooname.333foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "anything.333foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "333fooname", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "333fooname.333foo", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "anything.333foo", LocationKind.NORMALIZE);
    }

    public void testDocumentSetupParticipantExtension_2() {
        this.assertDocumentContent("", "/p/444fooname", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/444fooname.444foo", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/anything.444foo", LocationKind.IFILE);
        this.assertDocumentContent("emanoof444", "444fooname", LocationKind.LOCATION);
        this.assertDocumentContent("oof444.emanoof444", "444fooname.444foo", LocationKind.LOCATION);
        this.assertDocumentContent("oof444.gnihtyna", "anything.444foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "444fooname", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "444fooname.444foo", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "anything.444foo", LocationKind.NORMALIZE);
    }

    public void testDocumentSetupParticipantExtension_3() {
        this.assertDocumentContent("", "/p/555fooname", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/555fooname.555foo", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/anything.555foo", LocationKind.IFILE);
        this.assertDocumentContent("", "555fooname", LocationKind.LOCATION);
        this.assertDocumentContent("", "555fooname.555foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "anything.555foo", LocationKind.LOCATION);
        this.assertDocumentContent("emanoof555", "555fooname", LocationKind.NORMALIZE);
        this.assertDocumentContent("oof555.emanoof555", "555fooname.555foo", LocationKind.NORMALIZE);
        this.assertDocumentContent("oof555.gnihtyna", "anything.555foo", LocationKind.NORMALIZE);
    }

    private void assertParticipantsInvoked(String path, Class[] expectedDSPsArray) {
        LocationKind[] lks = this.getSupportLocationKinds();
        int i = 0;
        while (i < lks.length) {
            IDocument document = this.fManager.createEmptyDocument((IPath)new Path(path), lks[i]);
            String content = document.get();
            HashSet<String> expectedDSPs = new HashSet<String>(Arrays.asList(AbstractFileBufferDocCreationTests.toString(expectedDSPsArray)));
            HashSet<String> actualDSPs = new HashSet<String>(Arrays.asList(content.split("\n")));
            AbstractFileBufferDocCreationTests.assertEquals(expectedDSPs, actualDSPs);
            ++i;
        }
    }

    protected abstract LocationKind[] getSupportLocationKinds();

    protected void assertDocumentContent(String expectedContent, String path, LocationKind locKind) {
        AbstractFileBufferDocCreationTests.assertEquals((String)expectedContent, (String)this.fManager.createEmptyDocument((IPath)new Path(path), locKind).get());
    }

    private static String[] toString(Class[] clss) {
        String[] result = new String[clss.length];
        int i = 0;
        while (i < result.length) {
            String s = null;
            if (clss[i] != null) {
                s = clss[i].toString();
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(clss[i])) {
                    s = String.valueOf(s) + "%%EXTENSION";
                }
            }
            result[i] = s;
            ++i;
        }
        return result;
    }
}

