/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileBufferListener;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;

public abstract class FileBufferFunctions
extends TestCase {
    private IProject fProject;
    protected ITextFileBufferManager fManager;
    private IPath fPath;

    protected abstract IPath createPath(IProject var1) throws Exception;

    protected abstract void setReadOnly(boolean var1) throws Exception;

    protected abstract boolean modifyUnderlyingFile() throws Exception;

    protected abstract boolean deleteUnderlyingFile() throws Exception;

    protected abstract IPath moveUnderlyingFile() throws Exception;

    protected abstract boolean isStateValidationSupported();

    protected abstract Class getAnnotationModelClass() throws Exception;

    protected void setUp() throws Exception {
        this.fManager = FileBuffers.getTextFileBufferManager();
        this.fProject = ResourceHelper.createProject("project");
        this.fPath = this.createPath(this.fProject);
        ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
        FileBufferFunctions.assertTrue((buffer == null ? 1 : 0) != 0);
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected void tearDown() throws Exception {
        ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
        FileBufferFunctions.assertTrue((buffer == null ? 1 : 0) != 0);
        ResourceHelper.deleteProject("project");
    }

    protected IPath getPath() {
        return this.fPath;
    }

    public void test1() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertEquals((Object)this.fPath, (Object)buffer.getLocation());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test2() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.fPath);
            IFileInfo fileInfo = fileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            FileBufferFunctions.assertTrue(((lastModified = fileStore.fetchInfo().getLastModified()) == 0L || !fileBuffer.isSynchronized() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test3() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isDirty());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test4() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer1 = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertFalse((boolean)fileBuffer1.isShared());
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                ITextFileBuffer fileBuffer2 = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                FileBufferFunctions.assertTrue((boolean)fileBuffer1.isShared());
                FileBufferFunctions.assertTrue((boolean)fileBuffer2.isShared());
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
            FileBufferFunctions.assertFalse((boolean)fileBuffer1.isShared());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test5() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            long modificationStamp = fileBuffer.getModificationStamp();
            IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.fPath);
            IFileInfo fileInfo = fileStore.fetchInfo();
            FileBufferFunctions.assertEquals((modificationStamp != -1L ? 1 : 0) != 0, (boolean)fileInfo.exists());
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            FileBufferFunctions.assertTrue(((lastModified = fileStore.fetchInfo().getLastModified()) == 0L || modificationStamp != fileBuffer.getModificationStamp() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test6() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            IDocument document = fileBuffer.getDocument();
            String originalContent = document.get();
            document.replace(document.getLength(), 0, "appendix");
            IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.fPath);
            IFileInfo fileInfo = fileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            fileBuffer.revert(null);
            FileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
            FileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test7() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            String originalContent = document.get();
            fileBuffer.commit(null, true);
            FileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
            FileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            fileBuffer.revert(null);
            FileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
            FileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                document = fileBuffer.getDocument();
                FileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
                FileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
                FileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test8_1() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test8_2() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            FileBufferFunctions.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test9_1() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                FileBufferFunctions.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test9_2() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                FileBufferFunctions.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test10() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void bufferCreated(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }

            public void bufferDisposed(IFileBuffer buf) {
                --this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
            FileBufferFunctions.assertNotNull((Object)listener.buffer);
            IFileBuffer fileBuffer = this.fManager.getFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            FileBufferFunctions.assertTrue((listener.count == 0 ? 1 : 0) != 0);
            FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
        }
        finally {
            try {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
            finally {
                this.fManager.removeFileBufferListener((IFileBufferListener)listener);
            }
        }
    }

    public void test11_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((boolean)listener.isDirty);
                fileBuffer.commit(null, true);
                FileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileBufferFunctions.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test11_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((boolean)listener.isDirty);
                fileBuffer.revert(null);
                FileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileBufferFunctions.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test12_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                FileBufferFunctions.assertTrue((listener.preCount == 1 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.preBuffer == fileBuffer ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.postCount == 1 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.postBuffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test12_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.modifyUnderlyingFile()) {
                    FileBufferFunctions.assertTrue((listener.preCount == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.preBuffer == fileBuffer ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.postCount == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.postBuffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    FileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileBufferFunctions.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_4() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    FileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileBufferFunctions.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test14() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void underlyingFileDeleted(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.deleteUnderlyingFile()) {
                    FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test15() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public IPath newLocation;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void underlyingFileMoved(IFileBuffer buf, IPath location) {
                ++this.count;
                this.buffer = buf;
                this.newLocation = location;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IPath newLocation = this.moveUnderlyingFile();
                if (!(newLocation == null || listener.count == 1 && listener.buffer == fileBuffer && newLocation.equals((Object)listener.newLocation))) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Wrong listener notifcation in " + ((Object)((Object)this)).getClass().getName() + ":\n");
                    buf.append("listener.count: " + listener.count + " (expected: 1)\n");
                    if (newLocation.equals((Object)listener.newLocation)) {
                        buf.append("newLocation identical: true\n");
                    } else {
                        buf.append("listener.newLocation: " + listener.newLocation + "\n");
                        buf.append("newLocation: " + newLocation + "\n");
                    }
                    buf.append("buffers identical: " + new Boolean(listener.buffer == fileBuffer));
                    FileBufferFunctions.fail((String)buf.toString());
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test16_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.modifyUnderlyingFile()) {
                    FileBufferFunctions.assertSame((Object)listener.buffer, (Object)fileBuffer);
                    FileBufferFunctions.assertEquals((int)1, (int)listener.count);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test16_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.deleteUnderlyingFile()) {
                    FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test16_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.moveUnderlyingFile() != null) {
                    FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test17_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test17_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test17_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileBufferFunctions this$0;

            Listener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.commit(null, true);
                FileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test18() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertNotNull((Object)buffer);
            Class clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                FileBufferFunctions.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void test19() throws Exception {
        class NotifiedListener
        extends FileBufferListener {
            int notifyCount;
            final /* synthetic */ FileBufferFunctions this$0;

            NotifiedListener(FileBufferFunctions fileBufferFunctions) {
                this.this$0 = fileBufferFunctions;
                this.notifyCount = 0;
            }

            public void bufferCreated(IFileBuffer buffer) {
                ++this.notifyCount;
            }

            public void bufferDisposed(IFileBuffer buffer) {
                ++this.notifyCount;
            }
        }
        NotifiedListener notifyCounter1 = new NotifiedListener(this);
        NotifiedListener notifyCounter2 = new NotifiedListener(this);
        FileBufferListener failingListener = new FileBufferListener(){

            public void bufferCreated(IFileBuffer buffer) {
                class ForcedException
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    ForcedException() {
                    }

                    public void printStackTrace(PrintStream s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }

                    public void printStackTrace(PrintWriter s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }
                }
                throw new ForcedException();
            }

            public void bufferDisposed(IFileBuffer buffer) {
                throw new ForcedException();
            }
        };
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter1);
        this.fManager.addFileBufferListener((IFileBufferListener)failingListener);
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter2);
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertNotNull((Object)buffer);
            Class clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                FileBufferFunctions.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter1);
            this.fManager.removeFileBufferListener((IFileBufferListener)failingListener);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter2);
        }
        FileBufferFunctions.assertEquals((int)2, (int)notifyCounter1.notifyCount);
        FileBufferFunctions.assertEquals((int)2, (int)notifyCounter2.notifyCount);
    }

    public void testGetBufferForDocument() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertNotNull((Object)buffer);
            IDocument document = buffer.getDocument();
            FileBufferFunctions.assertNotNull((Object)document);
            FileBufferFunctions.assertSame((Object)buffer, (Object)this.fManager.getTextFileBuffer(document));
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public void testGetFileStoreAnnotationModel() throws Exception {
        IFileStore fileStore = EFS.getNullFileSystem().getStore((IPath)new Path("/dev/null"));
        FileBufferFunctions.assertNotNull((Object)fileStore);
        this.fManager.connectFileStore(fileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(fileStore);
            IAnnotationModel model = fileBuffer.getAnnotationModel();
            Class clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                FileBufferFunctions.assertTrue((boolean)clazz.isInstance(model));
            } else {
                FileBufferFunctions.assertNotNull((Object)model);
            }
        }
        finally {
            this.fManager.disconnectFileStore(fileStore, null);
        }
    }

    public void testGetFileBuffers() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            FileBufferFunctions.assertNotNull((Object)buffer);
            IFileBuffer[] fileBuffers = this.fManager.getFileBuffers();
            FileBufferFunctions.assertNotNull((Object)fileBuffers);
            FileBufferFunctions.assertEquals((int)1, (int)fileBuffers.length);
            FileBufferFunctions.assertSame((Object)buffer, (Object)fileBuffers[0]);
            fileBuffers = this.fManager.getFileStoreFileBuffers();
            FileBufferFunctions.assertNotNull((Object)fileBuffers);
            FileBufferFunctions.assertEquals((int)0, (int)fileBuffers.length);
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }
}

