/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileBuffersTestPlugin;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FileBuffersForLinkedFiles
extends FileBufferFunctions {
    private File fExternalFile;
    static /* synthetic */ Class class$0;

    protected void tearDown() throws Exception {
        FileTool.delete(this.fExternalFile);
        FileTool.delete(this.fExternalFile.getParentFile());
        super.tearDown();
    }

    protected IPath createPath(IProject project) throws Exception {
        File sourceFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("testResources/LinkedFileTarget"));
        this.fExternalFile = FileTool.createTempFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("externalResources/LinkedFileTarget"));
        FileTool.copy(sourceFile, this.fExternalFile);
        IFile file = ResourceHelper.createLinkedFile((IContainer)project, (IPath)new Path("LinkedFile"), this.fExternalFile);
        return file.getFullPath();
    }

    protected void setReadOnly(boolean state) throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(state);
        file.setResourceAttributes(attributes);
    }

    protected boolean isStateValidationSupported() {
        return true;
    }

    protected boolean deleteUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        file.delete(true, false, null);
        return file.exists();
    }

    protected IPath moveUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceHelper.createFolder("project/folderA");
        Path path = new Path("/project/folderA/MovedLinkedFile");
        file.move((IPath)path, true, false, null);
        file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (file != null && file.exists()) {
            return path;
        }
        return null;
    }

    protected boolean modifyUnderlyingFile() throws Exception {
        FileTool.write(this.fExternalFile.getAbsolutePath(), new StringBuffer("Changed content of linked file"));
        this.fExternalFile.setLastModified(1000L);
        IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        iFile.refreshLocal(2, null);
        return true;
    }

    protected Class getAnnotationModelClass() throws Exception {
        Class<?> clazz;
        block3: {
            block2: {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.editors");
                if (bundle == null) break block2;
                clazz = class$0;
                if (clazz != null) break block3;
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.source.IAnnotationModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block3;
            }
            clazz = null;
        }
        return clazz;
    }
}

