/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class FileBuffersForNonAccessibleWorkspaceFiles
extends FileBufferFunctions {
    protected void setUp() throws Exception {
        super.setUp();
        this.getProject().close(null);
    }

    protected IPath createPath(IProject project) throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "WorkspaceFile", "content");
        return file.getFullPath();
    }

    protected void tearDown() throws Exception {
        FileTool.delete(this.getPath());
        super.tearDown();
    }

    protected void setReadOnly(boolean state) throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        FileBuffersForNonAccessibleWorkspaceFiles.assertNotNull((Object)fileStore);
        fileStore.fetchInfo().setAttribute(2, state);
    }

    protected boolean isStateValidationSupported() {
        return false;
    }

    protected boolean deleteUnderlyingFile() throws Exception {
        return false;
    }

    protected IPath moveUnderlyingFile() throws Exception {
        return null;
    }

    protected boolean modifyUnderlyingFile() throws Exception {
        return false;
    }

    protected Class getAnnotationModelClass() throws Exception {
        return null;
    }

    public void test7() throws Exception {
    }

    public void test11_1() throws Exception {
    }

    public void test17_3() throws Exception {
    }
}

