/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class FileBuffersForWorkspaceFiles
extends FileBufferFunctions {
    static /* synthetic */ Class class$0;

    protected IPath createPath(IProject project) throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "WorkspaceFile", "content");
        return file.getFullPath();
    }

    protected void setReadOnly(boolean state) throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(state);
        file.setResourceAttributes(attributes);
    }

    protected boolean isStateValidationSupported() {
        return true;
    }

    protected boolean deleteUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        file.delete(true, false, null);
        return file.exists();
    }

    protected IPath moveUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceHelper.createFolder("project/folderA/folderB/folderC");
        Path path = new Path("/project/folderA/folderB/folderC/MovedWorkspaceFile");
        file.move((IPath)path, true, false, null);
        file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (file != null && file.exists()) {
            return path;
        }
        return null;
    }

    protected boolean modifyUnderlyingFile() throws Exception {
        IFileStore fileStore;
        block5: {
            fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
            FileBuffersForWorkspaceFiles.assertTrue((boolean)fileStore.fetchInfo().exists());
            OutputStream out = fileStore.openOutputStream(0, null);
            try {
                try {
                    out.write(new String("Changed content of workspace file").getBytes());
                    out.flush();
                }
                catch (IOException iOException) {
                    FileBuffersForWorkspaceFiles.fail();
                    out.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                out.close();
                throw throwable;
            }
            out.close();
        }
        IFileInfo fileInfo = fileStore.fetchInfo();
        fileInfo.setLastModified(1000L);
        fileStore.putInfo(fileInfo, 2048, null);
        IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        FileBuffersForWorkspaceFiles.assertTrue((iFile.exists() && iFile.getFullPath().equals((Object)this.getPath()) ? 1 : 0) != 0);
        iFile.refreshLocal(2, null);
        return true;
    }

    protected Class getAnnotationModelClass() throws Exception {
        Class<?> clazz;
        block3: {
            block2: {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.editors");
                if (bundle == null) break block2;
                clazz = class$0;
                if (clazz != null) break block3;
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.source.IAnnotationModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block3;
            }
            clazz = null;
        }
        return clazz;
    }
}

