/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import junit.framework.TestCase;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.tests.FileBufferListener;
import org.eclipse.core.filebuffers.tests.FileStoreFileBufferFunctions;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;

public abstract class FileStoreFileBufferFunctions
extends TestCase {
    private IProject fProject;
    protected ITextFileBufferManager fManager;
    private IFileStore fFileStore;

    protected abstract IPath createPath(IProject var1) throws Exception;

    protected abstract void setReadOnly(boolean var1) throws Exception;

    protected abstract boolean modifyUnderlyingFile() throws Exception;

    protected abstract boolean deleteUnderlyingFile() throws Exception;

    protected abstract IPath moveUnderlyingFile() throws Exception;

    protected abstract boolean isStateValidationSupported();

    protected abstract Class getAnnotationModelClass() throws Exception;

    protected void setUp() throws Exception {
        this.fManager = FileBuffers.getTextFileBufferManager();
        this.fProject = ResourceHelper.createProject("project");
        this.fFileStore = EFS.getLocalFileSystem().getStore(this.createPath(this.fProject));
        ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
        FileStoreFileBufferFunctions.assertTrue((buffer == null ? 1 : 0) != 0);
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected void tearDown() throws Exception {
        ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
        FileStoreFileBufferFunctions.assertTrue((buffer == null ? 1 : 0) != 0);
        ResourceHelper.deleteProject("project");
    }

    protected IPath getPath() {
        return URIUtil.toPath((URI)this.fFileStore.toURI());
    }

    public void test1() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertEquals((Object)this.fFileStore, (Object)buffer.getFileStore());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test2() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            IFileStore fileStore = this.fFileStore;
            IFileInfo fileInfo = fileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            FileStoreFileBufferFunctions.assertTrue(((lastModified = fileStore.fetchInfo().getLastModified()) == 0L || !fileBuffer.isSynchronized() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test3() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isDirty());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test4() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer1 = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer1.isShared());
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                ITextFileBuffer fileBuffer2 = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer1.isShared());
                FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer2.isShared());
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
            FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer1.isShared());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test5() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            long modificationStamp = fileBuffer.getModificationStamp();
            IFileInfo fileInfo = this.fFileStore.fetchInfo();
            FileStoreFileBufferFunctions.assertEquals((modificationStamp != -1L ? 1 : 0) != 0, (boolean)fileInfo.exists());
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                this.fFileStore.putInfo(fileInfo, 2048, null);
            }
            FileStoreFileBufferFunctions.assertTrue(((lastModified = this.fFileStore.fetchInfo().getLastModified()) == 0L || modificationStamp != fileBuffer.getModificationStamp() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test6() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            IDocument document = fileBuffer.getDocument();
            String originalContent = document.get();
            document.replace(document.getLength(), 0, "appendix");
            IFileInfo fileInfo = this.fFileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                this.fFileStore.putInfo(fileInfo, 2048, null);
            }
            fileBuffer.revert(null);
            FileStoreFileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
            FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test7() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            String originalContent = document.get();
            fileBuffer.commit(null, true);
            FileStoreFileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
            FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            fileBuffer.revert(null);
            FileStoreFileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
            FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            this.fManager.disconnectFileStore(this.fFileStore, null);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                document = fileBuffer.getDocument();
                FileStoreFileBufferFunctions.assertEquals((String)originalContent, (String)document.get());
                FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isDirty());
                FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isSynchronized());
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test8_1() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test8_2() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            FileStoreFileBufferFunctions.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test9_1() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test9_2() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                FileStoreFileBufferFunctions.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test10() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void bufferCreated(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }

            public void bufferDisposed(IFileBuffer buf) {
                --this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            this.fManager.connectFileStore(this.fFileStore, null);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
            FileStoreFileBufferFunctions.assertNotNull((Object)listener.buffer);
            IFileBuffer fileBuffer = this.fManager.getFileStoreFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            this.fManager.disconnectFileStore(this.fFileStore, null);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 ? 1 : 0) != 0);
            FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
        }
        finally {
            try {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
            finally {
                this.fManager.removeFileBufferListener((IFileBufferListener)listener);
            }
        }
    }

    public void test11_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((boolean)listener.isDirty);
                fileBuffer.commit(null, true);
                FileStoreFileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test11_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((boolean)listener.isDirty);
                fileBuffer.revert(null);
                FileStoreFileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test12_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                FileStoreFileBufferFunctions.assertTrue((listener.preCount == 1 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.preBuffer == fileBuffer ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.postCount == 1 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.postBuffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test12_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.modifyUnderlyingFile()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.preCount == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.preBuffer == fileBuffer ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.postCount == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.postBuffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test13_4() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test14() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void underlyingFileDeleted(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.deleteUnderlyingFile()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test15() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public IPath newLocation;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void underlyingFileMoved(IFileBuffer buf, IPath location) {
                ++this.count;
                this.buffer = buf;
                this.newLocation = location;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IPath newLocation = this.moveUnderlyingFile();
                if (newLocation != null) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertEquals((Object)listener.newLocation, (Object)newLocation);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test16_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.modifyUnderlyingFile()) {
                    FileStoreFileBufferFunctions.assertSame((Object)listener.buffer, (Object)fileBuffer);
                    FileStoreFileBufferFunctions.assertEquals((int)1, (int)listener.count);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test16_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.deleteUnderlyingFile()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test16_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.moveUnderlyingFile() != null) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test17_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test17_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test17_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            Listener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
            }

            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener(this);
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.commit(null, true);
                FileStoreFileBufferFunctions.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                FileStoreFileBufferFunctions.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    public void test18() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertNotNull((Object)buffer);
            Class clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                FileStoreFileBufferFunctions.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void test19() throws Exception {
        class NotifiedListener
        extends FileBufferListener {
            int notifyCount;
            final /* synthetic */ FileStoreFileBufferFunctions this$0;

            NotifiedListener(FileStoreFileBufferFunctions fileStoreFileBufferFunctions) {
                this.this$0 = fileStoreFileBufferFunctions;
                this.notifyCount = 0;
            }

            public void bufferCreated(IFileBuffer buffer) {
                ++this.notifyCount;
            }

            public void bufferDisposed(IFileBuffer buffer) {
                ++this.notifyCount;
            }
        }
        NotifiedListener notifyCounter1 = new NotifiedListener(this);
        NotifiedListener notifyCounter2 = new NotifiedListener(this);
        FileBufferListener failingListener = new FileBufferListener(){

            public void bufferCreated(IFileBuffer buffer) {
                class ForcedException
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    ForcedException() {
                    }

                    public void printStackTrace(PrintStream s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }

                    public void printStackTrace(PrintWriter s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }
                }
                throw new ForcedException();
            }

            public void bufferDisposed(IFileBuffer buffer) {
                throw new ForcedException();
            }
        };
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter1);
        this.fManager.addFileBufferListener((IFileBufferListener)failingListener);
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter2);
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertNotNull((Object)buffer);
            Class clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                FileStoreFileBufferFunctions.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter1);
            this.fManager.removeFileBufferListener((IFileBufferListener)failingListener);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter2);
        }
        FileStoreFileBufferFunctions.assertEquals((int)2, (int)notifyCounter1.notifyCount);
        FileStoreFileBufferFunctions.assertEquals((int)2, (int)notifyCounter2.notifyCount);
    }

    public void testGetBufferForDocument() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertNotNull((Object)buffer);
            IDocument document = buffer.getDocument();
            FileStoreFileBufferFunctions.assertNotNull((Object)document);
            FileStoreFileBufferFunctions.assertSame((Object)buffer, (Object)this.fManager.getTextFileBuffer(document));
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    public void testGetFileStoreFileBuffers() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            FileStoreFileBufferFunctions.assertNotNull((Object)buffer);
            IFileBuffer[] fileBuffers = this.fManager.getFileStoreFileBuffers();
            FileStoreFileBufferFunctions.assertNotNull((Object)fileBuffers);
            FileStoreFileBufferFunctions.assertEquals((int)1, (int)fileBuffers.length);
            FileStoreFileBufferFunctions.assertSame((Object)buffer, (Object)fileBuffers[0]);
            fileBuffers = this.fManager.getFileBuffers();
            FileStoreFileBufferFunctions.assertNotNull((Object)fileBuffers);
            FileStoreFileBufferFunctions.assertEquals((int)0, (int)fileBuffers.length);
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }
}

