/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBuffersTestPlugin;
import org.eclipse.core.filebuffers.tests.FileStoreFileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileStoreFileBuffersForExternalFiles
extends FileStoreFileBufferFunctions {
    protected void tearDown() throws Exception {
        FileTool.delete(this.getPath());
        FileTool.delete(FileBuffers.getSystemFileAtLocation((IPath)this.getPath()).getParentFile());
        super.tearDown();
    }

    protected IPath createPath(IProject project) throws Exception {
        File sourceFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("testResources/ExternalFile"));
        File externalFile = FileTool.createTempFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("externalResources/ExternalFile"));
        FileTool.copy(sourceFile, externalFile);
        return new Path(externalFile.getAbsolutePath());
    }

    protected void setReadOnly(boolean state) throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        FileStoreFileBuffersForExternalFiles.assertNotNull((Object)fileStore);
        fileStore.fetchInfo().setAttribute(2, state);
    }

    protected boolean isStateValidationSupported() {
        return false;
    }

    protected boolean deleteUnderlyingFile() throws Exception {
        return false;
    }

    protected IPath moveUnderlyingFile() throws Exception {
        return null;
    }

    protected boolean modifyUnderlyingFile() throws Exception {
        return false;
    }

    protected Class getAnnotationModelClass() throws Exception {
        return null;
    }
}

