/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.FileStoreFileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class FileStoreFileBuffersForNonExistingWorkspaceFiles
extends FileStoreFileBufferFunctions {
    protected void tearDown() throws Exception {
        FileTool.delete(this.getPath());
        super.tearDown();
    }

    protected IPath createPath(IProject project) throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IPath filePath = folder.getLocation().append("NonExistingWorkspaceFile");
        return filePath.makeAbsolute();
    }

    public void testBug118199() throws Exception {
        IFile file = this.getProject().getWorkspace().getRoot().getFile(this.getPath());
        FileStoreFileBuffersForNonExistingWorkspaceFiles.assertFalse((boolean)file.exists());
        this.fManager.connect(this.getPath(), LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.getPath(), LocationKind.NORMALIZE);
            buffer.getDocument().set("test");
            buffer.commit(null, false);
        }
        finally {
            this.fManager.disconnect(this.getPath(), LocationKind.NORMALIZE, null);
        }
        FileStoreFileBuffersForNonExistingWorkspaceFiles.assertFalse((boolean)file.exists());
    }

    public void testBug118199_fixed() throws Exception {
        IFile file = this.getProject().getWorkspace().getRoot().getFileForLocation(this.getPath());
        IPath path = file.getFullPath();
        FileStoreFileBuffersForNonExistingWorkspaceFiles.assertFalse((boolean)file.exists());
        this.fManager.connect(path, LocationKind.IFILE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(path, LocationKind.IFILE);
            buffer.getDocument().set("test");
            buffer.commit(null, false);
        }
        finally {
            this.fManager.disconnect(path, LocationKind.IFILE, null);
        }
        FileStoreFileBuffersForNonExistingWorkspaceFiles.assertTrue((boolean)file.exists());
    }

    protected void setReadOnly(boolean state) throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        FileStoreFileBuffersForNonExistingWorkspaceFiles.assertNotNull((Object)fileStore);
        fileStore.fetchInfo().setAttribute(2, state);
    }

    protected boolean isStateValidationSupported() {
        return false;
    }

    protected boolean deleteUnderlyingFile() throws Exception {
        return false;
    }

    protected IPath moveUnderlyingFile() throws Exception {
        return null;
    }

    protected boolean modifyUnderlyingFile() throws Exception {
        return false;
    }

    protected Class getAnnotationModelClass() throws Exception {
        return null;
    }
}

