/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyType;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.net.Activator;

public class NetTest
extends TestCase {
    private static final boolean BUG_338097 = true;
    private boolean isSetEnabled;
    private boolean isProxiesDefault;
    private boolean isSystemProxiesDefault;
    private Map dataCache = new HashMap();
    static /* synthetic */ Class class$0;

    public NetTest() {
    }

    public NetTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.net.NetTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.isSystemProxiesDefault = this.isSystemProxiesEnabled();
        this.setSystemProxiesEnabled(false);
        this.isProxiesDefault = this.isProxiesEnabled();
        this.setProxiesEnabled(true);
        this.isSetEnabled = true;
        this.dataCache.clear();
        ProxyType.socksSystemPropertySetting = 1;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.setProxiesEnabled(this.isProxiesDefault);
        this.setSystemProxiesEnabled(this.isSystemProxiesDefault);
        IProxyData[] data = this.getProxyManager().getProxyData();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            proxyData.disable();
            ++i;
        }
        this.getProxyManager().setProxyData(data);
    }

    private IProxyService getProxyManager() {
        return Activator.getDefault().getProxyService();
    }

    private void assertProxyDataEqual(IProxyData expected) {
        ProxyData expectedData = (ProxyData)expected;
        ProxyData data = (ProxyData)this.getProxyManager().getProxyData(expectedData.getType());
        NetTest.assertEquals((String)expectedData.getType(), (String)data.getType());
        NetTest.assertEquals((String)expectedData.getHost(), (String)data.getHost());
        NetTest.assertEquals((int)expectedData.getPort(), (int)data.getPort());
        NetTest.assertEquals((String)expectedData.getUserId(), (String)data.getUserId());
        NetTest.assertEquals((String)expectedData.getPassword(), (String)data.getPassword());
        NetTest.assertEquals((boolean)expectedData.isRequiresAuthentication(), (boolean)data.isRequiresAuthentication());
        NetTest.assertEquals((String)expectedData.getSource(), (String)data.getSource());
        this.assertSystemPropertiesMatch((IProxyData)data);
    }

    public void assertSystemPropertiesMatch(IProxyData proxyData) {
        if (proxyData.getType().equals("HTTP")) {
            this.assertHttpSystemProperties(proxyData, "http");
        } else if (proxyData.getType().equals("HTTPS")) {
            this.assertHttpSystemProperties(proxyData, "https");
        } else if (proxyData.getType().equals("SOCKS")) {
            this.assertSocksSystemProperties(proxyData);
        }
    }

    private void assertHttpSystemProperties(IProxyData proxyData, String keyPrefix) {
        Properties sysProps = System.getProperties();
        if (this.getProxyManager().isProxiesEnabled()) {
            boolean isSet = Boolean.getBoolean(String.valueOf(keyPrefix) + ".proxySet");
            NetTest.assertEquals((proxyData.getHost() != null ? 1 : 0) != 0, (boolean)isSet);
            NetTest.assertEquals((Object)proxyData.getHost(), (Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyHost"));
            String portString = (String)sysProps.get(String.valueOf(keyPrefix) + ".proxyPort");
            int port = -1;
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            NetTest.assertEquals((int)proxyData.getPort(), (int)port);
            if (isSet) {
                NetTest.assertEquals((Object)ProxyType.convertHostsToPropertyString((String[])this.getProxyManager().getNonProxiedHosts()), (Object)sysProps.get(String.valueOf(keyPrefix) + ".nonProxyHosts"));
            } else {
                NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".nonProxyHosts"));
            }
            NetTest.assertEquals((Object)proxyData.getUserId(), (Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyUser"));
            NetTest.assertEquals((Object)proxyData.getUserId(), (Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyUserName"));
            NetTest.assertEquals((Object)proxyData.getPassword(), (Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyPassword"));
        } else {
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".proxySet"));
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyHost"));
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyPort"));
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".nonProxyHosts"));
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyUser"));
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyUserName"));
            NetTest.assertNull((Object)sysProps.get(String.valueOf(keyPrefix) + ".proxyPassword"));
        }
    }

    private void assertSocksSystemProperties(IProxyData proxyData) {
        Properties sysProps = System.getProperties();
        if (this.getProxyManager().isProxiesEnabled()) {
            NetTest.assertEquals((Object)proxyData.getHost(), (Object)sysProps.get("socksProxyHost"));
            String portString = (String)sysProps.get("socksProxyPort");
            int port = -1;
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            NetTest.assertEquals((int)proxyData.getPort(), (int)port);
        } else {
            NetTest.assertNull((Object)sysProps.get("socksProxyHost"));
            NetTest.assertNull((Object)sysProps.get("socksProxyPort"));
        }
    }

    private IProxyData getProxyData(String type) {
        IProxyData data = (IProxyData)this.dataCache.get(type);
        if (data == null) {
            data = this.getProxyManager().getProxyData(type);
            this.assertProxyDataEqual(data);
        }
        return data;
    }

    private void setProxyData(IProxyData data) throws CoreException {
        if (this.isSetEnabled) {
            this.getProxyManager().setProxyData(new IProxyData[]{data});
            this.assertProxyDataEqual(data);
        } else {
            this.dataCache.put(data.getType(), data);
        }
    }

    private void disableProxy(IProxyData proxyData) throws CoreException {
        proxyData.disable();
        this.setProxyData(proxyData);
    }

    private void changeProxyData(IProxyData oldData, IProxyData data) throws CoreException {
        if (this.isSetEnabled) {
            this.assertProxyDataEqual(oldData);
        }
        this.setProxyData(data);
    }

    private void setHost(String type) throws CoreException {
        String host = "www.eclipse.org";
        this.setHost(type, host);
    }

    private void setHost(String type, String host) throws CoreException {
        IProxyData data = this.getProxyData(type);
        IProxyData oldData = this.getProxyData(type);
        data.setHost(host);
        this.changeProxyData(oldData, data);
    }

    private void setPort(String type, int port) throws CoreException {
        IProxyData data = this.getProxyData(type);
        IProxyData oldData = this.getProxyData(type);
        data.setPort(port);
        this.changeProxyData(oldData, data);
    }

    private void setUser(String type, String user, String password) throws CoreException {
        IProxyData data = this.getProxyData(type);
        IProxyData oldData = this.getProxyData(type);
        data.setUserid(user);
        data.setPassword(password);
        this.changeProxyData(oldData, data);
    }

    private void setDataTest(String type) throws CoreException {
        this.setHost(type, "www.eclipse.org");
        this.setPort(type, 1024);
        this.setUser(type, "me", "passw0rd");
    }

    private boolean isProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private boolean isSystemProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private void setProxiesEnabled(boolean enabled) {
        this.getProxyManager().setProxiesEnabled(enabled);
        if (enabled && this.getProxyManager().isSystemProxiesEnabled() && !this.getProxyManager().hasSystemProxies()) {
            NetTest.assertEquals((boolean)false, (boolean)this.getProxyManager().isProxiesEnabled());
        } else {
            NetTest.assertEquals((boolean)enabled, (boolean)this.getProxyManager().isProxiesEnabled());
        }
    }

    private void setSystemProxiesEnabled(boolean enabled) {
        this.getProxyManager().setSystemProxiesEnabled(enabled);
        NetTest.assertEquals((boolean)enabled, (boolean)this.getProxyManager().isSystemProxiesEnabled());
    }

    private void delaySettingData() {
        this.isSetEnabled = false;
    }

    private void performSettingData() throws CoreException {
        IProxyData[] data = this.dataCache.values().toArray(new IProxyData[this.dataCache.size()]);
        this.getProxyManager().setProxyData(data);
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            this.assertProxyDataEqual(proxyData);
            ++i;
        }
        this.isSetEnabled = true;
        this.dataCache.clear();
    }

    public void testIndividualSetAndClear() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        IProxyData[] data = this.getProxyManager().getProxyData();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            this.disableProxy(proxyData);
            ++i;
        }
    }

    public void testAllSetAndClear() throws CoreException {
        this.delaySettingData();
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        this.performSettingData();
        this.delaySettingData();
        IProxyData[] data = this.getProxyManager().getProxyData();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            this.disableProxy(proxyData);
            ++i;
        }
        this.performSettingData();
    }

    public void testSetWhenDisabled() throws CoreException {
        this.setProxiesEnabled(false);
        String type = "HTTP";
        this.setHost(type);
    }

    public void testDisableAfterSet() throws CoreException {
        String type = "HTTP";
        this.setHost(type);
        IProxyData data = this.getProxyManager().getProxyData(type);
        this.setProxiesEnabled(false);
        this.assertProxyDataEqual(data);
    }

    public void _testSimpleHost() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        IProxyData[] allData = this.getProxyManager().getProxyDataForHost("www.randomhot.com");
        NetTest.assertEquals((int)3, (int)allData.length);
        IProxyData data = this.getProxyManager().getProxyDataForHost("www.randomhot.com", "HTTP");
        NetTest.assertNotNull((Object)data);
        allData = this.getProxyManager().getProxyDataForHost("localhost");
        NetTest.assertEquals((int)0, (int)allData.length);
        data = this.getProxyManager().getProxyDataForHost("localhost", "HTTP");
        NetTest.assertNull((Object)data);
    }

    public void testHostPattern() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        this.getProxyManager().setNonProxiedHosts(new String[]{"*ignore.com"});
        IProxyData[] allData = this.getProxyManager().getProxyDataForHost("www.randomhot.com");
        NetTest.assertEquals((int)3, (int)allData.length);
        IProxyData data = this.getProxyManager().getProxyDataForHost("www.randomhot.com", "HTTP");
        NetTest.assertNotNull((Object)data);
        allData = this.getProxyManager().getProxyDataForHost("www.ignore.com");
        NetTest.assertEquals((int)0, (int)allData.length);
        data = this.getProxyManager().getProxyDataForHost("www.ignore.com", "HTTP");
        NetTest.assertNull((Object)data);
        allData = this.getProxyManager().getProxyDataForHost("ignore.com");
        NetTest.assertEquals((int)0, (int)allData.length);
        data = this.getProxyManager().getProxyDataForHost("ignore.com", "HTTP");
        NetTest.assertNull((Object)data);
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    public void testBug238796() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        this.getProxyManager().setNonProxiedHosts(new String[]{"nonexisting.com"});
        IProxyData[] allData = this.getProxyManager().getProxyDataForHost("NONEXISTING.COM");
        NetTest.assertEquals((int)0, (int)allData.length);
        IProxyData data = this.getProxyManager().getProxyDataForHost("NONEXISTING.COM", "HTTP");
        NetTest.assertNull((Object)data);
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    public void testBug247408() throws CoreException, URISyntaxException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        IProxyData data1 = this.getProxyManager().getProxyDataForHost("randomhost.com", "HTTP");
        IProxyData[] data2 = this.getProxyManager().select(new URI("http://randomhost.com"));
        NetTest.assertEquals((int)data2.length, (int)1);
        NetTest.assertEquals((Object)data1, (Object)data2[0]);
        IProxyData data3 = this.getProxyManager().getProxyDataForHost("randomhost.com", null);
        IProxyData[] data4 = this.getProxyManager().select(new URI(null, "randomhost.com", null, null));
        NetTest.assertNull((Object)data3);
        NetTest.assertEquals((int)data4.length, (int)0);
    }

    public void testBug255981() throws CoreException, URISyntaxException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        this.getProxyManager().setProxiesEnabled(false);
        IProxyData data = this.getProxyManager().getProxyDataForHost("randomhost.com", "HTTP");
        NetTest.assertNull((Object)data);
        IProxyData[] data2 = this.getProxyManager().select(new URI("http://randomhost.com"));
        NetTest.assertEquals((int)data2.length, (int)0);
        IProxyData[] data3 = this.getProxyManager().getProxyDataForHost("http://randomhost.com");
        NetTest.assertEquals((int)data3.length, (int)0);
    }

    public void testBug257503() throws CoreException {
    }

    public void testNonProxyHosts() throws CoreException {
        this.setDataTest("HTTP");
        this.setDataTest("HTTPS");
        this.setDataTest("SOCKS");
        String[] oldHosts = this.getProxyManager().getNonProxiedHosts();
        String testHost = "bug284540.com";
        ArrayList<String> hostsList = new ArrayList<String>();
        hostsList.addAll(Arrays.asList(oldHosts));
        hostsList.add(testHost);
        String[] newHosts = hostsList.toArray(new String[0]);
        this.getProxyManager().setNonProxiedHosts(newHosts);
        String sysPropNonProxyHosts = System.getProperty("http.nonProxyHosts");
        String assertMessage = "http.nonProxyHost should contain '" + testHost + "', but its current value is '" + sysPropNonProxyHosts + "'";
        NetTest.assertTrue((String)assertMessage, (sysPropNonProxyHosts.indexOf(testHost) > -1 ? 1 : 0) != 0);
        this.getProxyManager().setNonProxiedHosts(oldHosts);
    }

    private void validateSystemProperties(boolean present) {
        this.validateProperty("http.proxySet", "true", present);
        this.validateProperty("http.proxyHost", "www.eclipse.org", present);
        this.validateProperty("http.proxyPort", "1024", present);
        this.validateProperty("http.proxyUser", "me", present);
        this.validateProperty("http.proxyUserName", "me", present);
        this.validateProperty("http.proxyPassword", "passw0rd", present);
        this.validateProperty("https.proxySet", "true", present);
        this.validateProperty("https.proxyHost", "www.eclipse.org", present);
        this.validateProperty("https.proxyPort", "1024", present);
        this.validateProperty("https.proxyUser", "me", present);
        this.validateProperty("https.proxyUserName", "me", present);
        this.validateProperty("https.proxyPassword", "passw0rd", present);
        this.validateProperty("socksProxyHost", "www.eclipse.org", present);
        this.validateProperty("socksProxyPort", "1024", present);
    }

    private void validateProperty(String key, String expected, boolean equals) {
        String actual = System.getProperties().getProperty(key);
        NetTest.assertTrue((equals && expected.equals(actual) || !equals && !expected.equals(actual) ? 1 : 0) != 0);
    }
}

