/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.tests.net.Activator;

public class SystemProxyTest
extends TestCase {
    private boolean isProxiesDefault;
    private boolean isSystemProxiesDefault;
    private Map proxyDataMap = new HashMap();
    static /* synthetic */ Class class$0;

    public SystemProxyTest() {
    }

    public SystemProxyTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.tests.net.SystemProxyTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.isSystemProxiesDefault = this.isSystemProxiesEnabled();
        this.setSystemProxiesEnabled(true);
        this.isProxiesDefault = this.isProxiesEnabled();
        this.setProxiesEnabled(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.setProxiesEnabled(this.isProxiesDefault);
        this.setSystemProxiesEnabled(this.isSystemProxiesDefault);
        IProxyData[] data = this.getProxyManager().getProxyData();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            proxyData.disable();
            ++i;
        }
        this.getProxyManager().setProxyData(data);
    }

    private IProxyService getProxyManager() {
        return Activator.getDefault().getProxyService();
    }

    private boolean isProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private boolean isSystemProxiesEnabled() {
        return this.getProxyManager().isProxiesEnabled();
    }

    private void setProxiesEnabled(boolean enabled) {
        this.getProxyManager().setProxiesEnabled(enabled);
        if (enabled && this.getProxyManager().isSystemProxiesEnabled() && !this.getProxyManager().hasSystemProxies()) {
            SystemProxyTest.assertEquals((boolean)false, (boolean)this.getProxyManager().isProxiesEnabled());
        } else {
            SystemProxyTest.assertEquals((boolean)enabled, (boolean)this.getProxyManager().isProxiesEnabled());
        }
    }

    private void setSystemProxiesEnabled(boolean enabled) {
        this.getProxyManager().setSystemProxiesEnabled(enabled);
        SystemProxyTest.assertEquals((boolean)enabled, (boolean)this.getProxyManager().isSystemProxiesEnabled());
    }

    private void assertProxyDataEqual(IProxyData actual, IProxyData expected) {
        ProxyData data = (ProxyData)actual;
        ProxyData expectedData = (ProxyData)expected;
        SystemProxyTest.assertTrue((expectedData.getType() == data.getType() ? 1 : 0) != 0);
        SystemProxyTest.assertEquals((String)expectedData.getHost(), (String)data.getHost());
        SystemProxyTest.assertEquals((int)expectedData.getPort(), (int)data.getPort());
        SystemProxyTest.assertEquals((String)expectedData.getUserId(), (String)data.getUserId());
        SystemProxyTest.assertEquals((String)expectedData.getPassword(), (String)data.getPassword());
        SystemProxyTest.assertEquals((boolean)expectedData.isRequiresAuthentication(), (boolean)data.isRequiresAuthentication());
        SystemProxyTest.assertEquals((String)expectedData.getSource(), (String)data.getSource());
    }

    private void checkGetProxyDataForHost() {
        this.checkGetProxyDataForHost("http://www.something.org");
        this.checkGetProxyDataForHost("https://www.something.org");
        this.checkGetProxyDataForHost("socks://www.something.org");
        this.checkGetProxyDataForHost("www.something.org");
    }

    private void checkGetProxyDataForHost(String host) {
        IProxyData[] proxiesData = this.getProxyManager().getProxyDataForHost(host);
        SystemProxyTest.assertNotNull((Object)proxiesData);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        int i = 0;
        while (i < proxiesData.length) {
            this.assertProxyDataEqual(proxiesData[i], (IProxyData)this.proxyDataMap.get(proxiesData[i].getType()));
            typeMap.put(proxiesData[i].getType(), proxiesData[i].getType());
            ++i;
        }
        SystemProxyTest.assertEquals((int)3, (int)typeMap.size());
    }

    private void checkProxySelector() {
        ProxyData[] proxiesData = ProxySelector.getProxyData((String)"Native");
        SystemProxyTest.assertNotNull((Object)proxiesData);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        int i = 0;
        while (i < proxiesData.length) {
            this.assertProxyDataEqual((IProxyData)proxiesData[i], (IProxyData)this.proxyDataMap.get(proxiesData[i].getType()));
            typeMap.put(proxiesData[i].getType(), proxiesData[i].getType());
            ++i;
        }
        SystemProxyTest.assertEquals((int)3, (int)typeMap.size());
    }

    public void testGetProxyDataForHost_LinuxEnvSettings() {
        this.initializeTestProxyData("LINUX_ENV");
        this.checkGetProxyDataForHost();
    }

    public void testProxySelector_LinuxEnvSettings() {
        this.initializeTestProxyData("LINUX_ENV");
        this.checkProxySelector();
    }

    public void testGetProxyDataForHost_LinuxGnomeSettings() {
        this.initializeTestProxyData("LINUX_GNOME");
        this.checkGetProxyDataForHost();
    }

    public void testProxySelector_LinuxGnomeSettings() {
        this.initializeTestProxyData("LINUX_GNOME");
        this.checkProxySelector();
    }

    public void testGetProxyDataForHost_WindowsIEManualSettings() {
        this.initializeTestProxyData("WINDOWS_IE");
        this.checkGetProxyDataForHost();
    }

    public void testProxySelector_WindowsIEManualSettings() {
        this.initializeTestProxyData("WINDOWS_IE");
        this.checkProxySelector();
    }

    public void testNonProxiedHosts_WindowsIEManualSettings() throws URISyntaxException {
        IProxyData[] proxiesData = this.getProxyManager().select(new URI("http://eclipse"));
        SystemProxyTest.assertEquals((int)1, (int)proxiesData.length);
        proxiesData = this.getProxyManager().select(new URI("http://eclipse.org/bugs"));
        SystemProxyTest.assertEquals((int)0, (int)proxiesData.length);
        proxiesData = this.getProxyManager().select(new URI("http://nonexisting.com"));
        SystemProxyTest.assertEquals((int)0, (int)proxiesData.length);
        proxiesData = this.getProxyManager().select(new URI("http://www.eclipse.org"));
        SystemProxyTest.assertEquals((int)0, (int)proxiesData.length);
        proxiesData = this.getProxyManager().select(new URI("http://www.myDomain.com"));
        SystemProxyTest.assertEquals((int)0, (int)proxiesData.length);
        proxiesData = this.getProxyManager().select(new URI("http://www.test.edu"));
        SystemProxyTest.assertEquals((int)0, (int)proxiesData.length);
    }

    private void initializeTestProxyData(String proxyDataSource) {
        this.proxyDataMap.put("HTTP", new ProxyData("HTTP", "127.0.0.1", 8081, false, proxyDataSource));
        this.proxyDataMap.put("HTTPS", new ProxyData("HTTPS", "127.0.0.2", 8082, false, proxyDataSource));
        this.proxyDataMap.put("SOCKS", new ProxyData("SOCKS", "127.0.0.3", 8083, false, proxyDataSource));
    }
}

