/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.filesystem.FileSystemTest;

public class CreateDirectoryTest
extends FileSystemTest {
    protected IFileStore topDir;
    protected IFileStore subDir;
    protected IFileStore file;
    protected IFileStore subFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.topDir = this.baseStore.getChild("topDir");
        this.subDir = this.topDir.getChild("subDir");
        this.file = this.baseStore.getChild("file");
        this.subFile = this.file.getChild("subFile");
        this.ensureExists(this.topDir.getParent(), true);
        this.ensureDoesNotExist(this.topDir);
        this.ensureDoesNotExist(this.file);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ensureDoesNotExist(this.topDir);
        this.ensureDoesNotExist(this.file);
    }

    public void testParentExistsDeep() {
        try {
            this.topDir.mkdir(0, this.getMonitor());
        }
        catch (CoreException e) {
            CreateDirectoryTest.fail((String)"1.99", (Throwable)e);
        }
        IFileInfo info = this.topDir.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"1.1", (boolean)info.exists());
        CreateDirectoryTest.assertTrue((String)"1.2", (boolean)info.isDirectory());
    }

    public void testParentExistsShallow() {
        try {
            this.topDir.mkdir(4, this.getMonitor());
        }
        catch (CoreException e) {
            CreateDirectoryTest.fail((String)"2.99", (Throwable)e);
        }
        IFileInfo info = this.topDir.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"2.1", (boolean)info.exists());
        CreateDirectoryTest.assertTrue((String)"2.2", (boolean)info.isDirectory());
    }

    public void testParentFileDeep() {
        this.ensureExists(this.file, false);
        try {
            this.subFile.mkdir(0, this.getMonitor());
            CreateDirectoryTest.fail((String)"1.99");
        }
        catch (CoreException coreException) {}
        IFileInfo info = this.subFile.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"2.1", (!info.exists() ? 1 : 0) != 0);
        CreateDirectoryTest.assertTrue((String)"2.2", (!info.isDirectory() ? 1 : 0) != 0);
    }

    public void testParentFileShallow() {
        this.ensureExists(this.file, false);
        try {
            this.subFile.mkdir(4, this.getMonitor());
            CreateDirectoryTest.fail((String)"1.99");
        }
        catch (CoreException coreException) {}
        IFileInfo info = this.subFile.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"2.1", (!info.exists() ? 1 : 0) != 0);
        CreateDirectoryTest.assertTrue((String)"2.2", (!info.isDirectory() ? 1 : 0) != 0);
    }

    public void testParentNotExistsDeep() {
        try {
            this.subDir.mkdir(0, this.getMonitor());
        }
        catch (CoreException e) {
            CreateDirectoryTest.fail((String)"1.99", (Throwable)e);
        }
        IFileInfo info = this.topDir.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"1.1", (boolean)info.exists());
        CreateDirectoryTest.assertTrue((String)"1.2", (boolean)info.isDirectory());
        info = this.subDir.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"1.3", (boolean)info.exists());
        CreateDirectoryTest.assertTrue((String)"1.4", (boolean)info.isDirectory());
    }

    public void testParentNotExistsShallow() {
        try {
            this.subDir.mkdir(4, this.getMonitor());
            CreateDirectoryTest.fail((String)"1.99");
        }
        catch (CoreException coreException) {}
        IFileInfo info = this.topDir.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"1.1", (!info.exists() ? 1 : 0) != 0);
        CreateDirectoryTest.assertTrue((String)"1.2", (!info.isDirectory() ? 1 : 0) != 0);
        info = this.subDir.fetchInfo();
        CreateDirectoryTest.assertTrue((String)"1.3", (!info.exists() ? 1 : 0) != 0);
        CreateDirectoryTest.assertTrue((String)"1.4", (!info.isDirectory() ? 1 : 0) != 0);
    }

    public void testParentNotExistsShallowInLocalFile() {
        try {
            IFileStore localFileTopDir = this.localFileBaseStore.getChild("topDir");
            localFileTopDir.mkdir(4, this.getMonitor());
            CreateDirectoryTest.fail((String)"1.99");
        }
        catch (CoreException e) {
            CreateDirectoryTest.assertNotNull((String)"1.1", (Object)e.getStatus());
            CreateDirectoryTest.assertEquals((String)"1.2", (int)272, (int)e.getStatus().getCode());
        }
    }

    public void testTargetIsFileInLocalFile() {
        try {
            this.ensureExists(this.localFileBaseStore, true);
            IFileStore localFileTopDir = this.localFileBaseStore.getChild("topDir");
            this.ensureExists(localFileTopDir, false);
            localFileTopDir.mkdir(4, this.getMonitor());
            CreateDirectoryTest.fail((String)"1.99");
        }
        catch (CoreException e) {
            CreateDirectoryTest.assertNotNull((String)"1.1", (Object)e.getStatus());
            CreateDirectoryTest.assertEquals((String)"1.2", (int)276, (int)e.getStatus().getCode());
        }
    }

    public void testParentDeviceNotExistsInLocalFile() {
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        String device = this.findNonExistingDevice();
        if (device == null) {
            return;
        }
        try {
            IFileStore localFileTopDir = EFS.getStore((URI)URI.create("file:/" + device + ":" + this.getUniqueString()));
            localFileTopDir.mkdir(4, this.getMonitor());
            CreateDirectoryTest.fail((String)"1.99");
        }
        catch (CoreException e) {
            CreateDirectoryTest.assertNotNull((String)"1.1", (Object)e.getStatus());
            CreateDirectoryTest.assertEquals((String)"1.2", (int)272, (int)e.getStatus().getCode());
        }
    }

    private String findNonExistingDevice() {
        String device = null;
        int i = 97;
        while (i < 123) {
            char c = (char)i;
            if (!new File(String.valueOf(c) + ":\\").exists()) {
                device = "" + c;
                break;
            }
            ++i;
        }
        return device;
    }
}

