/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.filesystem.FileSystemTest;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileStore;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;

public class FileCacheTest
extends FileSystemTest {
    public static Test suite() {
        return new TestSuite(FileCacheTest.class);
    }

    public FileCacheTest(String name) {
        super(name);
    }

    public void assertEquals(String message, byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            FileCacheTest.fail((String)(String.valueOf(message) + " arrays of different length"));
        }
        FileCacheTest.assertEquals((String)(String.valueOf(message) + " different length"), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            if (expected[i] != actual[i]) {
                FileCacheTest.fail((String)(String.valueOf(message) + " arrays differ at position " + i + "; expected: " + expected[i] + " but was: " + actual[i]));
            }
            ++i;
        }
    }

    public void assertNotSame(String message, byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            return;
        }
        int i = 0;
        while (i < actual.length) {
            if (expected[i] != actual[i]) {
                return;
            }
            ++i;
        }
        FileCacheTest.fail((String)(String.valueOf(message) + " arrays should be different, but they are not: " + expected));
    }

    private byte[] getBytes(File cachedFile) {
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new FileInputStream(cachedFile);
            out = new ByteArrayOutputStream();
            this.transferData(in, out);
            in.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            FileCacheTest.fail((String)"Exception in FileCacheTest.getBytes", (Throwable)e);
            return new byte[0];
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        MemoryTree.TREE.deleteAll();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        MemoryTree.TREE.deleteAll();
    }

    public void testCacheFile() {
        try {
            MemoryFileStore store = new MemoryFileStore((IPath)new Path("testCacheFile"));
            OutputStream out = store.openOutputStream(0, this.getMonitor());
            byte[] contents = "test".getBytes();
            out.write(contents);
            out.close();
            File cachedFile = store.toLocalFile(4096, this.getMonitor());
            FileCacheTest.assertTrue((String)"1.0", (boolean)cachedFile.exists());
            FileCacheTest.assertTrue((String)"1.1", (!cachedFile.isDirectory() ? 1 : 0) != 0);
            this.assertEquals("1.2", contents, this.getBytes(cachedFile));
            byte[] newContents = "newContents".getBytes();
            out = store.openOutputStream(0, this.getMonitor());
            out.write(newContents);
            out.close();
            this.assertNotSame("2.0", newContents, this.getBytes(cachedFile));
            cachedFile = store.toLocalFile(4096, this.getMonitor());
            FileCacheTest.assertTrue((String)"3.0", (boolean)cachedFile.exists());
            FileCacheTest.assertTrue((String)"3.1", (!cachedFile.isDirectory() ? 1 : 0) != 0);
            this.assertEquals("3.2", newContents, this.getBytes(cachedFile));
        }
        catch (IOException e) {
            FileCacheTest.fail((String)"1.99", (Throwable)e);
        }
        catch (CoreException e) {
            FileCacheTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testCacheFolder() {
        try {
            MemoryFileStore store = new MemoryFileStore((IPath)new Path("testCacheFolder"));
            store.mkdir(0, this.getMonitor());
            File cachedFile = store.toLocalFile(4096, this.getMonitor());
            FileCacheTest.assertTrue((String)"1.0", (boolean)cachedFile.exists());
            FileCacheTest.assertTrue((String)"1.1", (boolean)cachedFile.isDirectory());
        }
        catch (CoreException e) {
            FileCacheTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testNoCacheFlag() {
        try {
            MemoryFileStore store = new MemoryFileStore((IPath)new Path("testNoCacheFlag"));
            store.mkdir(0, this.getMonitor());
            File cachedFile = store.toLocalFile(0, this.getMonitor());
            FileCacheTest.assertNull((String)"1.0", (Object)cachedFile);
        }
        catch (CoreException e) {
            FileCacheTest.fail((String)"4.99", (Throwable)e);
        }
    }

    public void testNonExisting() {
        try {
            MemoryFileStore store = new MemoryFileStore((IPath)new Path("testNonExisting"));
            File cachedFile = store.toLocalFile(4096, this.getMonitor());
            FileCacheTest.assertTrue((String)"1.0", (!cachedFile.exists() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FileCacheTest.fail((String)"4.99", (Throwable)e);
        }
    }
}

