/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.filesystem.FileSystemTest;

public class PutInfoTest
extends FileSystemTest {
    public void testSetFileLastModified() {
        IFileStore file = this.baseStore.getChild("file");
        this.ensureExists(file, false);
        IFileInfo info = file.fetchInfo();
        long oldLastModified = info.getLastModified();
        long newLastModified = oldLastModified + 100L;
        info = EFS.createFileInfo();
        info.setLastModified(newLastModified);
        try {
            file.putInfo(info, 2048, this.getMonitor());
        }
        catch (CoreException e) {
            PutInfoTest.fail((String)"1.99", (Throwable)e);
        }
        info = file.fetchInfo();
        PutInfoTest.assertEquals((String)"1.0", (long)newLastModified, (long)info.getLastModified());
        PutInfoTest.assertEquals((String)"1.1", (String)file.getName(), (String)info.getName());
    }

    public void testSetReadOnly() {
        IFileStore file = this.baseStore.getChild("file");
        this.ensureExists(file, false);
        IFileInfo info = EFS.createFileInfo();
        info.setAttribute(2, true);
        try {
            file.putInfo(info, 1024, this.getMonitor());
        }
        catch (CoreException e) {
            PutInfoTest.fail((String)"1.99", (Throwable)e);
        }
        info = file.fetchInfo();
        PutInfoTest.assertEquals((String)"1.0", (boolean)true, (boolean)info.getAttribute(2));
        PutInfoTest.assertEquals((String)"1.1", (String)file.getName(), (String)info.getName());
    }
}

