/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.filesystem.FileSystemTest;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;

public class URIUtilTest
extends FileSystemTest {
    public static Test suite() {
        return new TestSuite(URIUtilTest.class);
    }

    public URIUtilTest() {
        super("");
    }

    public URIUtilTest(String name) {
        super(name);
    }

    public void testEquals() {
        if (EFS.getLocalFileSystem().isCaseSensitive()) {
            URI two;
            URI one = new File("c:\\temp\\test").toURI();
            URIUtilTest.assertTrue((String)"1.0", (!URIUtil.equals((URI)one, (URI)(two = new File("c:\\TEMP\\test").toURI())) ? 1 : 0) != 0);
        } else {
            URI one = new File("c:\\temp\\test").toURI();
            URI two = new File("c:\\TEMP\\test").toURI();
            URIUtilTest.assertTrue((String)"1.0", (boolean)URIUtil.equals((URI)one, (URI)two));
        }
    }

    public void testPathToURI() {
        if (Platform.getOS().equals("win32")) {
            URIUtilTest.assertEquals((String)"1.0", (String)"/c:/temp/with spaces", (String)URIUtil.toURI((String)"c:\\temp\\with spaces").getSchemeSpecificPart());
        } else {
            URIUtilTest.assertEquals((String)"2.0", (String)"/tmp/with spaces", (String)URIUtil.toURI((String)"/tmp/with spaces").getSchemeSpecificPart());
        }
    }

    public void testStringToURI() {
        if (Platform.getOS().equals("win32")) {
            URIUtilTest.assertEquals((String)"1.0", (String)"/c:/temp/with spaces", (String)URIUtil.toURI((IPath)new Path("c:\\temp\\with spaces")).getSchemeSpecificPart());
        } else {
            URIUtilTest.assertEquals((String)"1.0", (String)"/tmp/with spaces", (String)URIUtil.toURI((IPath)new Path("/tmp/with spaces")).getSchemeSpecificPart());
        }
    }

    public void testToPath() throws Exception {
        String pathString = "test/path with/spaces to_file.txt";
        URIUtilTest.assertEquals((String)"1.0", (Object)new Path(pathString), (Object)URIUtil.toPath((URI)URIUtil.toURI((String)pathString, (boolean)false)));
        pathString = Platform.getOS().equals("win32") ? "c:/test/path with/spaces to_file.txt" : "/test/path with/spaces to_file.txt";
        URIUtilTest.assertEquals((String)"2.0", (Object)new Path(pathString), (Object)URIUtil.toPath((URI)URIUtil.toURI((String)pathString)));
        URIUtilTest.assertEquals((String)"3.0", (Object)new Path(pathString), (Object)URIUtil.toPath((URI)WrapperFileSystem.getWrappedURI(URIUtil.toURI((String)pathString))));
    }

    public void testToURIAbsolute() {
        String pathString = null;
        pathString = Platform.getOS().equals("win32") ? "c:/test/path with/spaces to_file.txt" : "/test/path with/spaces to_file.txt";
        Path path = new Path(pathString);
        URI uri01 = URIUtil.toURI((IPath)path);
        URI uri02 = URIUtil.toURI((String)pathString);
        URIUtilTest.assertEquals((String)"1.0", (Object)uri01, (Object)uri02);
    }

    public void testToURIRelative() {
        String pathString = "test/path with/spaces to_file.txt";
        Path path = new Path(pathString);
        URI uri01 = URIUtil.toURI((IPath)path);
        URI uri02 = URIUtil.toURI((String)pathString, (boolean)false);
        URIUtilTest.assertEquals((String)"1.0", (Object)uri01, (Object)uri02);
        URIUtilTest.assertTrue((String)"1.1", (!uri01.isAbsolute() ? 1 : 0) != 0);
        URIUtilTest.assertTrue((String)"1.2", (!uri02.isAbsolute() ? 1 : 0) != 0);
    }

    public void testFromPathToURI() {
        Path aPath = null;
        aPath = Platform.getOS().equals("win32") ? new Path("c:/test/path with spaces/to_file.txt") : new Path("/test/path with spaces/to_file.txt");
        Path rPath = new Path("relative/with spaces/path/to_file.txt");
        URI aUri = URIUtil.toURI((IPath)aPath);
        URI rUri = URIUtil.toURI((IPath)rPath);
        URIUtilTest.assertEquals((String)"1.0", (String)aPath.toString(), (String)URIUtil.toPath((URI)aUri).toString());
        URIUtilTest.assertEquals((String)"2.0", (String)rPath.toString(), (String)URIUtil.toPath((URI)rUri).toString());
    }

    public void testBug291323_doubleDotLocationPath() {
        URI aUri = URIUtil.toURI((String)"..");
        URI bUri = URIUtil.toURI((String)"");
        URIUtilTest.assertEquals((String)"1.0", (String)URIUtil.toPath((URI)bUri).toString(), (String)URIUtil.toPath((URI)aUri).toString());
    }
}

