/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.events.BuildContext;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IBuildContext;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.ContextBuilder;

public class BuildContextTest
extends AbstractBuilderTest {
    private IProject project0;
    private IProject project1;
    private IProject project2;
    private final String variant0 = "Variant0";
    private final String variant1 = "Variant1";

    public static Test suite() {
        return new TestSuite(BuildContextTest.class);
    }

    public BuildContextTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = BuildContextTest.getWorkspace().getRoot();
        this.project0 = root.getProject("BuildContextTests_p0");
        this.project1 = root.getProject("BuildContextTests_p1");
        this.project2 = root.getProject("BuildContextTests_p2");
        IResource[] resources = new IResource[]{this.project0, this.project1, this.project2};
        this.ensureExistsInWorkspace(resources, true);
        this.setAutoBuilding(false);
        this.setupProject(this.project0);
        this.setupProject(this.project1);
        this.setupProject(this.project2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project0.delete(true, null);
        this.project1.delete(true, null);
        this.project2.delete(true, null);
    }

    private void setupProject(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand command = this.createCommand(desc, "org.eclipse.core.tests.resources.contextbuilder", "Build0");
        command.setBuilding(9, true);
        command.setBuilding(6, true);
        command.setBuilding(10, true);
        command.setBuilding(15, true);
        desc.setBuildSpec(new ICommand[]{command});
        desc.setBuildConfigs(new String[]{"Variant0", "Variant1"});
        project.setDescription(desc, this.getMonitor());
    }

    private IBuildConfiguration changeActiveBuildConfig(IProject project) throws CoreException {
        IBuildConfiguration[] configs = project.getBuildConfigs();
        IBuildConfiguration active = project.getActiveBuildConfig();
        IProjectDescription desc = project.getDescription();
        IBuildConfiguration[] iBuildConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            if (!config.equals(active)) {
                desc.setActiveBuildConfig(config.getName());
                project.setDescription(desc, this.getMonitor());
                return config;
            }
            ++n2;
        }
        BuildContextTest.assertTrue((boolean)false);
        return null;
    }

    private void setupSimpleReferences() throws CoreException {
        this.setReferences(this.project0.getActiveBuildConfig(), new IBuildConfiguration[]{this.project1.getActiveBuildConfig()});
        this.setReferences(this.project1.getActiveBuildConfig(), new IBuildConfiguration[]{this.project2.getActiveBuildConfig()});
        this.setReferences(this.project2.getActiveBuildConfig(), new IBuildConfiguration[0]);
    }

    private void setReferences(IBuildConfiguration variant, IBuildConfiguration[] refs) throws CoreException {
        IProjectDescription desc = variant.getProject().getDescription();
        desc.setBuildConfigReferences(variant.getName(), refs);
        variant.getProject().setDescription(desc, this.getMonitor());
    }

    public void testBuildContext() {
        IBuildConfiguration p0v0 = BuildContextTest.getWorkspace().newBuildConfig(this.project0.getName(), "Variant0");
        IBuildConfiguration p0v1 = BuildContextTest.getWorkspace().newBuildConfig(this.project0.getName(), "Variant1");
        IBuildConfiguration p1v0 = BuildContextTest.getWorkspace().newBuildConfig(this.project1.getName(), "Variant0");
        IBuildConfiguration[] buildOrder = new IBuildConfiguration[]{p0v0, p0v1, p1v0};
        BuildContext context = new BuildContext(p0v0, new IBuildConfiguration[]{p0v0, p1v0}, buildOrder);
        this.assertEquals("1.0", new IBuildConfiguration[0], context.getAllReferencedBuildConfigs());
        this.assertEquals("1.1", new IBuildConfiguration[]{p0v1, p1v0}, context.getAllReferencingBuildConfigs());
        this.assertEquals("1.2", new IBuildConfiguration[]{p0v0, p1v0}, context.getRequestedConfigs());
        context = new BuildContext(p0v1, buildOrder, buildOrder);
        this.assertEquals("2.0", new IBuildConfiguration[]{p0v0}, context.getAllReferencedBuildConfigs());
        this.assertEquals("2.1", new IBuildConfiguration[]{p1v0}, context.getAllReferencingBuildConfigs());
        context = new BuildContext(p1v0, buildOrder, buildOrder);
        this.assertEquals("3.0", new IBuildConfiguration[]{p0v0, p0v1}, context.getAllReferencedBuildConfigs());
        this.assertEquals("3.1", new IBuildConfiguration[0], context.getAllReferencingBuildConfigs());
        context = new BuildContext(p1v0);
        this.assertEquals("4.0", new IBuildConfiguration[0], context.getAllReferencedBuildConfigs());
        this.assertEquals("4.1", new IBuildConfiguration[0], context.getAllReferencingBuildConfigs());
    }

    public void testSingleProjectBuild() throws CoreException {
        this.setAutoBuilding(true);
        this.setupSimpleReferences();
        ContextBuilder.clearStats();
        this.project0.build(6, this.getMonitor());
        BuildContextTest.assertTrue((String)"1.0", (boolean)ContextBuilder.checkValid());
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        BuildContextTest.assertEquals((String)"2.0", (int)0, (int)context.getAllReferencedBuildConfigs().length);
        BuildContextTest.assertEquals((String)"2.1", (int)0, (int)context.getAllReferencingBuildConfigs().length);
        ContextBuilder.clearStats();
        IBuildConfiguration newActive = this.changeActiveBuildConfig(this.project0);
        this.waitForBuild();
        BuildContextTest.assertTrue((String)"3.0", (boolean)ContextBuilder.checkValid());
        context = ContextBuilder.getContext(newActive);
        BuildContextTest.assertEquals((String)"3.1", (int)0, (int)context.getAllReferencedBuildConfigs().length);
    }

    public void testWorkspaceBuildProject() throws CoreException {
        this.setupSimpleReferences();
        ContextBuilder.clearStats();
        BuildContextTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, this.getMonitor());
        BuildContextTest.assertTrue((String)"1.0", (boolean)ContextBuilder.checkValid());
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        this.assertEquals("2.0", new IBuildConfiguration[]{this.project2.getActiveBuildConfig(), this.project1.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        BuildContextTest.assertEquals((String)"2.1", (int)0, (int)context.getAllReferencingBuildConfigs().length);
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        this.assertEquals("3.0", new IBuildConfiguration[]{this.project2.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        this.assertEquals("3.1", new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project2.getActiveBuildConfig()).contextForLastBuild;
        BuildContextTest.assertEquals((String)"4.0", (int)0, (int)context.getAllReferencedBuildConfigs().length);
        this.assertEquals("4.1", new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
        ContextBuilder.clearStats();
        BuildContextTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, false, this.getMonitor());
        BuildContextTest.assertTrue((String)"5.0", (boolean)ContextBuilder.checkValid());
        context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        BuildContextTest.assertTrue((String)"5.1", (context.getAllReferencedBuildConfigs().length == 0 ? 1 : 0) != 0);
        BuildContextTest.assertTrue((String)"5.2", (context.getAllReferencingBuildConfigs().length == 0 ? 1 : 0) != 0);
    }

    public void testWorkspaceBuildProjects() throws CoreException {
        this.setupSimpleReferences();
        ContextBuilder.clearStats();
        BuildContextTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig(), this.project2.getActiveBuildConfig()}, 6, true, this.getMonitor());
        BuildContextTest.assertTrue((String)"1.0", (boolean)ContextBuilder.checkValid());
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        this.assertEquals("2.0", new IBuildConfiguration[]{this.project2.getActiveBuildConfig(), this.project1.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        BuildContextTest.assertEquals((String)"2.1", (int)0, (int)context.getAllReferencingBuildConfigs().length);
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        this.assertEquals("3.0", new IBuildConfiguration[]{this.project2.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        this.assertEquals("3.1", new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project2.getActiveBuildConfig()).contextForLastBuild;
        BuildContextTest.assertEquals((String)"4.0", (int)0, (int)context.getAllReferencedBuildConfigs().length);
        this.assertEquals("4.1", new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
    }

    public void testReferenceActiveVariant() throws CoreException {
        this.setReferences(this.project0.getActiveBuildConfig(), new IBuildConfiguration[]{BuildContextTest.getWorkspace().newBuildConfig(this.project1.getName(), null)});
        this.setReferences(this.project1.getActiveBuildConfig(), new IBuildConfiguration[]{BuildContextTest.getWorkspace().newBuildConfig(this.project2.getName(), null)});
        this.setReferences(this.project2.getActiveBuildConfig(), new IBuildConfiguration[0]);
        ContextBuilder.clearStats();
        BuildContextTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, this.getMonitor());
        BuildContextTest.assertTrue((String)"1.0", (boolean)ContextBuilder.checkValid());
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        this.assertEquals("2.0", new IBuildConfiguration[]{this.project2.getActiveBuildConfig(), this.project1.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        BuildContextTest.assertEquals((String)"2.1", (int)0, (int)context.getAllReferencingBuildConfigs().length);
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        this.assertEquals("3.0", new IBuildConfiguration[]{this.project2.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        this.assertEquals("3.1", new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project2.getActiveBuildConfig()).contextForLastBuild;
        BuildContextTest.assertEquals((String)"4.0", (int)0, (int)context.getAllReferencedBuildConfigs().length);
        this.assertEquals("4.1", new IBuildConfiguration[]{this.project1.getActiveBuildConfig(), this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
    }

    public void testReferenceVariantTwice() throws CoreException {
        BuildConfiguration ref1 = new BuildConfiguration(this.project1, null);
        BuildConfiguration ref2 = new BuildConfiguration(this.project1, this.project1.getActiveBuildConfig().getName());
        this.setReferences(this.project0.getActiveBuildConfig(), new IBuildConfiguration[]{ref1, ref2});
        this.setReferences(this.project1.getActiveBuildConfig(), new IBuildConfiguration[0]);
        ContextBuilder.clearStats();
        BuildContextTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, this.getMonitor());
        BuildContextTest.assertTrue((String)"1.0", (boolean)ContextBuilder.checkValid());
        IBuildContext context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        this.assertEquals("2.0", new IBuildConfiguration[]{this.project1.getActiveBuildConfig()}, context.getAllReferencedBuildConfigs());
        BuildContextTest.assertEquals((String)"2.1", (int)0, (int)context.getAllReferencingBuildConfigs().length);
        this.assertEquals("2.2", new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, context.getRequestedConfigs());
        context = ContextBuilder.getBuilder((IBuildConfiguration)this.project1.getActiveBuildConfig()).contextForLastBuild;
        BuildContextTest.assertEquals((String)"3.0", (int)0, (int)context.getAllReferencedBuildConfigs().length);
        this.assertEquals("3.1", new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, context.getAllReferencingBuildConfigs());
        ContextBuilder.clearStats();
        IBuildConfiguration project1PreviousActive = this.project1.getActiveBuildConfig();
        IBuildConfiguration project1NewActive = this.changeActiveBuildConfig(this.project1);
        BuildContextTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, 6, true, this.getMonitor());
        BuildContextTest.assertTrue((String)"4.0", (boolean)ContextBuilder.checkValid());
        context = ContextBuilder.getContext(this.project0.getActiveBuildConfig());
        this.assertEquals("4.1", new IBuildConfiguration[]{project1PreviousActive, project1NewActive}, context.getAllReferencedBuildConfigs());
        BuildContextTest.assertEquals((String)"4.2", (int)0, (int)context.getAllReferencingBuildConfigs().length);
        this.assertEquals("4.3", new IBuildConfiguration[]{this.project0.getActiveBuildConfig()}, context.getRequestedConfigs());
    }
}

