/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.TestBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.configbuilder";
    private static HashMap<IBuildConfiguration, ConfigurationBuilder> builders = new HashMap();
    static List<IBuildConfiguration> buildOrder = new ArrayList<IBuildConfiguration>();
    int triggerForLastBuild;
    IResourceDelta deltaForLastBuild;
    int buildCount;

    public static ConfigurationBuilder getBuilder(IBuildConfiguration config) {
        return builders.get(config);
    }

    public static void clearBuildOrder() {
        buildOrder = new ArrayList<IBuildConfiguration>();
    }

    public static void clearStats() {
        for (ConfigurationBuilder builder : builders.values()) {
            builder.buildCount = 0;
            builder.triggerForLastBuild = 0;
            builder.deltaForLastBuild = null;
        }
    }

    @Override
    protected void startupOnInitialize() {
        super.startupOnInitialize();
        builders.put(this.getBuildConfig(), this);
        this.buildCount = 0;
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        ++this.buildCount;
        this.triggerForLastBuild = kind;
        this.deltaForLastBuild = this.getDelta(this.getProject());
        buildOrder.add(this.getBuildConfig());
        return super.build(kind, args, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IResourceDelta delta = this.getDelta(this.getProject());
        Assert.assertNull((Object)delta);
        ++this.buildCount;
        this.triggerForLastBuild = 15;
    }
}

